/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources.format;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.plugins.JavaClassProviderLoadable;
import com.dtolabs.rundeck.core.plugins.PluggableProviderRegistryService;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableService;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParser;
import com.dtolabs.rundeck.core.resources.format.ResourceXMLFormatParser;
import com.dtolabs.rundeck.core.resources.format.ResourceYamlFormatParser;
import com.dtolabs.rundeck.core.resources.format.UnsupportedFormatException;
import com.dtolabs.rundeck.core.resources.format.json.ResourceJsonFormatParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResourceFormatParserService
extends PluggableProviderRegistryService<ResourceFormatParser>
implements DescribableService,
JavaClassProviderLoadable<ResourceFormatParser> {
    public static final String SERVICE_NAME = "ResourceFormatParser";

    public List<String> getBundledProviderNames() {
        return Collections.unmodifiableList(new ArrayList(this.registry.keySet()));
    }

    public ResourceFormatParserService(Framework framework) {
        super(framework);
        this.registry.put("resourcexml", ResourceXMLFormatParser.class);
        this.registry.put("resourceyaml", ResourceYamlFormatParser.class);
        this.registry.put("resourcejson", ResourceJsonFormatParser.class);
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    public List<String> listFormats() {
        ArrayList<String> list = new ArrayList<String>();
        for (ProviderIdent providerIdent : this.listProviders()) {
            list.add(providerIdent.getProviderName());
        }
        return list;
    }

    public List<String> listSupportedFileExtensions() {
        ArrayList<String> list = new ArrayList<String>();
        for (ProviderIdent providerIdent : this.listProviders()) {
            try {
                ResourceFormatParser resourceFormatParser = (ResourceFormatParser)this.providerOfType(providerIdent.getProviderName());
                list.addAll(resourceFormatParser.getFileExtensions());
            }
            catch (ExecutionServiceException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public ResourceFormatParser getParserForFileExtension(File file) throws UnsupportedFormatException {
        String extension = ResourceFormatParserService.getFileExtension(file.getName());
        if (null != extension) {
            return this.getParserForFileExtension(extension);
        }
        throw new UnsupportedFormatException("Could not determine format for file: " + file.getAbsolutePath());
    }

    public static String getFileExtension(String name) {
        int i = name.lastIndexOf(".");
        return i > 0 && i < name.length() - 1 ? name.substring(name.lastIndexOf(".") + 1) : null;
    }

    public ResourceFormatParser getParserForFileExtension(String extension) throws UnsupportedFormatException {
        for (ResourceFormatParser resourceFormatParser : this.listParsers()) {
            if (!resourceFormatParser.getFileExtensions().contains(extension)) continue;
            return resourceFormatParser;
        }
        throw new UnsupportedFormatException("No provider available to parse file extension: " + extension);
    }

    public ResourceFormatParser getParserForFormat(String format) throws UnsupportedFormatException {
        try {
            return (ResourceFormatParser)this.providerOfType(format);
        }
        catch (ExecutionServiceException e) {
            throw new UnsupportedFormatException("No provider available to parse format: " + format, e);
        }
    }

    public ResourceFormatParser getParserForMIMEType(String mimeType) throws UnsupportedFormatException {
        String cleanMime = null != mimeType && mimeType.indexOf(";") > 0 ? mimeType.substring(0, mimeType.indexOf(";")) : mimeType;
        if (!ResourceFormatParserService.validMimeType(cleanMime)) {
            throw new IllegalArgumentException("Invalid MIME type: " + mimeType);
        }
        for (ResourceFormatParser resourceFormatParser : this.listParsers()) {
            if (null == resourceFormatParser.getMIMETypes()) continue;
            if (resourceFormatParser.getMIMETypes().contains(cleanMime)) {
                return resourceFormatParser;
            }
            for (String s : resourceFormatParser.getMIMETypes()) {
                String t2;
                String t1;
                if (!ResourceFormatParserService.validMimeType(s) || !s.startsWith("*/") || !(t1 = s.substring(2)).equals(t2 = cleanMime.substring(cleanMime.indexOf("/") + 1))) continue;
                return resourceFormatParser;
            }
        }
        throw new UnsupportedFormatException("No provider available to parse MIME type: " + mimeType);
    }

    static boolean validMimeType(String cleanMime) {
        if (null == cleanMime) {
            return false;
        }
        int l = cleanMime.indexOf("/");
        return l > 0 && l < cleanMime.length() - 1 && l == cleanMime.lastIndexOf("/");
    }

    @Override
    public boolean isValidProviderClass(Class clazz) {
        return ResourceFormatParser.class.isAssignableFrom(clazz) && this.hasValidProviderSignature(clazz);
    }

    @Override
    public <X extends ResourceFormatParser> ResourceFormatParser createProviderInstance(Class<X> clazz, String name) throws PluginException, ProviderCreationException {
        return (ResourceFormatParser)this.createProviderInstanceFromType(clazz, name);
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return this.listProviders();
    }

    @Override
    public List<Description> listDescriptions() {
        ArrayList<Description> list = new ArrayList<Description>();
        for (ResourceFormatParser provider : this.listParsers()) {
            if (!(provider instanceof Describable)) continue;
            Describable desc = (Describable)((Object)provider);
            list.add(desc.getDescription());
        }
        return list;
    }

    private List<ResourceFormatParser> listParsers() {
        ArrayList<ResourceFormatParser> list = new ArrayList<ResourceFormatParser>();
        for (ProviderIdent providerIdent : this.listProviders()) {
            try {
                ResourceFormatParser providerForType = (ResourceFormatParser)this.providerOfType(providerIdent.getProviderName());
                list.add(providerForType);
            }
            catch (ExecutionServiceException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static ResourceFormatParserService getInstanceForFramework(Framework framework) {
        if (null == framework.getService(SERVICE_NAME)) {
            ResourceFormatParserService service = new ResourceFormatParserService(framework);
            framework.setService(SERVICE_NAME, service);
            return service;
        }
        return (ResourceFormatParserService)framework.getService(SERVICE_NAME);
    }
}

