/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.Project;

public class PropertyUtil {
    public static Properties expand(Map properties) {
        Properties expandedProperties = new Properties();
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String key = (String)entry.getKey();
            String keyValue = (String)entry.getValue();
            String expandedKeyValue = PropertyUtil.expand(keyValue, properties);
            expandedProperties.setProperty(key, expandedKeyValue);
        }
        return expandedProperties;
    }

    public static String expand(String keyString, Properties properties) {
        return PropertyUtil.expand(keyString, (Map)properties);
    }

    public static String expand(String keyString, Map properties) {
        String expandedLine = PropertyUtil.lineExpand(keyString, properties);
        if (PropertyUtil.resolvesToLiteral(expandedLine) || expandedLine.equals(keyString)) {
            return expandedLine;
        }
        return PropertyUtil.expand(expandedLine, properties);
    }

    public static String expand(String keyString, Project project) {
        return PropertyUtil.expand(keyString, project.getProperties());
    }

    private static String lineExpand(String keyString, Map properties) {
        if (PropertyUtil.resolvesToLiteral(keyString)) {
            return keyString;
        }
        StringTokenizer keyStringTokenizer = new StringTokenizer(keyString, "${}", true);
        StringBuffer sb = new StringBuffer();
        if (keyStringTokenizer.countTokens() == 1) {
            if (!properties.containsKey(keyString)) {
                return "";
            }
            return (String)properties.get(keyString);
        }
        boolean dollar = false;
        boolean lp = false;
        boolean rp = false;
        while (keyStringTokenizer.hasMoreTokens()) {
            if (dollar && lp && rp) {
                dollar = false;
                lp = false;
                rp = false;
            }
            String tok = keyStringTokenizer.nextToken();
            if (!(dollar || lp || rp || tok.equals("$"))) {
                sb.append(tok);
            }
            if (dollar && lp && !rp) {
                if (!tok.equals("}")) {
                    String expTok = tok;
                    String expVal = (String)properties.get(expTok);
                    if (expVal == null) {
                        sb.append("${").append(expTok).append("}");
                    } else {
                        sb.append(expVal);
                    }
                } else {
                    rp = true;
                    continue;
                }
            }
            if (tok.equals("$")) {
                if (dollar) {
                    throw new PropertyUtilException("parsing error: $$ invalid");
                }
                if (lp) {
                    throw new PropertyUtilException("parsing error: {$ invalid");
                }
                if (rp) {
                    throw new PropertyUtilException("parsing error: }$ invalid");
                }
                dollar = true;
                continue;
            }
            if (tok.equals("{")) {
                if (!dollar) {
                    throw new PropertyUtilException("parsing error: $ symbol must occur before { symbol");
                }
                if (lp) {
                    throw new PropertyUtilException("parsing error: {{ invalid");
                }
                if (rp) {
                    throw new PropertyUtilException("parsing error: }{ invalid");
                }
                lp = true;
                continue;
            }
            if (!tok.equals("}")) continue;
            if (!dollar) {
                throw new PropertyUtilException("parsing error: $ symbol must occur before } symbol");
            }
            if (!lp) {
                throw new PropertyUtilException("parsing error: { symbol must occur before } symbol");
            }
            if (rp) {
                throw new PropertyUtilException("parsing error: }} invalid");
            }
            rp = true;
        }
        if (null == sb.toString() || "".equals(sb.toString())) {
            throw new PropertyUtilException("null string return:" + keyString);
        }
        return sb.toString();
    }

    private static boolean resolvesToLiteral(String keyString) {
        return keyString.indexOf("${") <= -1;
    }

    public static class PropertyUtilException
    extends RuntimeException {
        public PropertyUtilException(String msg) {
            super(msg);
        }
    }
}

