/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps.node;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.data.MutableDataContext;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.FileBasedGeneratedScript;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.plugins.BaseScriptPlugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.utils.MapData;
import com.dtolabs.rundeck.plugins.step.GeneratedScript;
import com.dtolabs.rundeck.plugins.step.PluginStepContext;
import com.dtolabs.rundeck.plugins.step.RemoteScriptNodeStepPlugin;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.File;
import java.util.Map;

class ScriptBasedRemoteScriptNodeStepPlugin
extends BaseScriptPlugin
implements RemoteScriptNodeStepPlugin {
    public static final String SCRIPT_FILE_EXTENSION_META_KEY = "script-file-extension";
    public static final String SCRIPT_FILE_USE_EXTENSION_META_KEY = "use-original-file-extension";

    ScriptBasedRemoteScriptNodeStepPlugin(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
    }

    @Override
    public boolean isAllowCustomProperties() {
        return true;
    }

    static void validateScriptPlugin(ScriptPluginProvider plugin) throws PluginException {
        try {
            ScriptBasedRemoteScriptNodeStepPlugin.createDescription(plugin, true, DescriptionBuilder.builder());
        }
        catch (ConfigurationException e) {
            throw new PluginException(e);
        }
    }

    @Override
    public GeneratedScript generateScript(PluginStepContext context, Map<String, Object> configuration, INodeEntry node) throws NodeStepException {
        Object o;
        ScriptPluginProvider provider = this.getProvider();
        Description description = this.getDescription();
        Map<String, String> configData = MapData.toStringStringMap(configuration);
        try {
            this.loadContentConversionPropertyValues(configData, context.getExecutionContext(), description.getProperties());
        }
        catch (ConfigurationException e) {
            throw new NodeStepException(e.getMessage(), (Throwable)e, (FailureReason)StepFailureReason.ConfigurationFailure, node.getNodename());
        }
        MutableDataContext finalDataContext = DataContextUtils.context("config", configData);
        finalDataContext.merge(context.getDataContextObject());
        String args = provider.getScriptArgs();
        String[] argsarr = provider.getScriptArgsArray();
        if (null != args) {
            argsarr = args.split(" ");
        }
        argsarr = finalDataContext.replaceDataReferences(argsarr);
        boolean useOriginalFileExtension = true;
        if (provider.getMetadata().containsKey(SCRIPT_FILE_USE_EXTENSION_META_KEY)) {
            useOriginalFileExtension = this.getMetaBoolean(provider, SCRIPT_FILE_USE_EXTENSION_META_KEY, true);
        }
        String fileExtension = null;
        if (provider.getMetadata().containsKey(SCRIPT_FILE_EXTENSION_META_KEY) && (o = provider.getMetadata().get(SCRIPT_FILE_EXTENSION_META_KEY)) instanceof String) {
            fileExtension = (String)o;
        }
        if (null == fileExtension && useOriginalFileExtension) {
            fileExtension = ScriptBasedRemoteScriptNodeStepPlugin.getFileExtension(provider.getScriptFile().getName());
        }
        return ScriptBasedRemoteScriptNodeStepPlugin.createFileGeneratedScript(provider.getScriptFile(), argsarr, fileExtension, provider.getScriptInterpreter(), provider.getInterpreterArgsQuoted(), configData);
    }

    static String getFileExtension(String name) {
        int i = name.lastIndexOf(".");
        if (i > 0 && i < name.length() - 1) {
            return name.substring(i + 1);
        }
        return null;
    }

    private boolean getMetaBoolean(ScriptPluginProvider provider, String key, boolean defVal) {
        Object o = provider.getMetadata().get(key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o != null) {
            return Boolean.parseBoolean(o.toString());
        }
        return defVal;
    }

    static GeneratedScript createFileGeneratedScript(final File file, final String[] args, final String fileExtension, final String scriptInterpreter, final boolean interpreterArgsQuoted, final Map<String, String> configData) {
        return new FileBasedGeneratedScript(){

            @Override
            public File getScriptFile() {
                return file;
            }

            @Override
            public String getScript() {
                return null;
            }

            @Override
            public String[] getArgs() {
                return args;
            }

            @Override
            public String[] getCommand() {
                return null;
            }

            @Override
            public String getFileExtension() {
                return fileExtension;
            }

            @Override
            public String getScriptInterpreter() {
                return scriptInterpreter;
            }

            @Override
            public boolean isInterpreterArgsQuoted() {
                return interpreterArgsQuoted;
            }

            @Override
            public Map<String, String> getConfigData() {
                return configData;
            }
        };
    }
}

