/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins.configuration;

import com.dtolabs.rundeck.core.common.PropertyRetriever;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import org.apache.log4j.Logger;

class RuntimePropertyResolver
implements PropertyResolver {
    static final Logger log = Logger.getLogger(RuntimePropertyResolver.class);
    private PropertyRetriever instanceScopeResolver;
    private PropertyRetriever projectScopeResolver;
    private PropertyRetriever frameworkScopeResolver;

    RuntimePropertyResolver(PropertyRetriever instanceScopeResolver, PropertyRetriever projectScopeResolver, PropertyRetriever frameworkScopeResolver) {
        this.instanceScopeResolver = instanceScopeResolver;
        this.projectScopeResolver = projectScopeResolver;
        this.frameworkScopeResolver = frameworkScopeResolver;
    }

    @Override
    public String resolvePropertyValue(String name, PropertyScope scope) {
        if (null == scope || scope == PropertyScope.Unspecified) {
            throw new IllegalArgumentException("scope must be specified");
        }
        String value = null;
        if (scope.isInstanceLevel() && null != this.instanceScopeResolver) {
            value = this.instanceScopeResolver.getProperty(name);
            log.trace((Object)("resolvePropertyValue(" + (Object)((Object)scope) + ")(I) " + name + " = " + value));
        }
        if (null != value || scope == PropertyScope.InstanceOnly) {
            log.debug((Object)("resolvePropertyValue(" + (Object)((Object)scope) + ") " + name + " = " + value));
            return value;
        }
        if (scope.isProjectLevel() && null != this.projectScopeResolver) {
            value = this.projectScopeResolver.getProperty(name);
            log.trace((Object)("resolvePropertyValue(" + (Object)((Object)scope) + ")(P) " + name + " = " + value));
        }
        if (null != value || scope == PropertyScope.ProjectOnly) {
            log.debug((Object)("resolvePropertyValue(" + (Object)((Object)scope) + ") " + name + " = " + value));
            return value;
        }
        if (null != this.frameworkScopeResolver && scope.isFrameworkLevel()) {
            value = this.frameworkScopeResolver.getProperty(name);
            log.trace((Object)("resolvePropertyValue(" + (Object)((Object)scope) + ")(F) " + name + " = " + value));
        }
        log.debug((Object)("resolvePropertyValue(" + (Object)((Object)scope) + ") " + name + " = " + value));
        return value;
    }
}

