/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.plugins.BaseScriptPlugin;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.ServiceProviderLoader;
import com.dtolabs.rundeck.plugins.tours.TourLoaderPlugin;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ScriptTourLoader
extends BaseScriptPlugin
implements TourLoaderPlugin {
    private static final Logger LOG = Logger.getLogger(ScriptTourLoader.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final ServiceProviderLoader pluginManager;

    public ScriptTourLoader(ScriptPluginProvider provider, ServiceProviderLoader pluginManager) {
        super(provider);
        this.pluginManager = pluginManager;
    }

    @Override
    public boolean isAllowCustomProperties() {
        return true;
    }

    @Override
    public Map getTourManifest() {
        ScriptPluginProvider plugin = this.getProvider();
        try {
            return (Map)mapper.readValue(new File(plugin.getContentsBasedir(), "resources/tour-manifest.json"), TreeMap.class);
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to serve tour manifest.", (Throwable)ex);
            return new TreeMap();
        }
    }

    @Override
    public Map getTour(String tourId) {
        String tourKey = tourId.endsWith(".json") ? tourId : tourId + ".json";
        ScriptPluginProvider plugin = this.getProvider();
        try {
            return (Map)mapper.readValue(new File(plugin.getContentsBasedir(), "resources/tours/" + tourKey), TreeMap.class);
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to serve tour.", (Throwable)ex);
            return new TreeMap();
        }
    }
}

