/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class JARVerifier {
    private X509Certificate[] trustedCaCerts;

    public JARVerifier(X509Certificate[] trustedCaCerts) {
        this.trustedCaCerts = null != trustedCaCerts ? (X509Certificate[])trustedCaCerts.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JARVerifier create(String keystore, String alias, char[] passwd) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream(keystore);
            keyStore.load(fileIn, passwd);
        }
        finally {
            if (null != fileIn) {
                fileIn.close();
            }
        }
        Certificate[] chain = keyStore.getCertificateChain(alias);
        if (chain == null) {
            Certificate cert = keyStore.getCertificate(alias);
            if (cert == null) {
                throw new IllegalArgumentException("No trusted certificate or chain found for alias: " + alias);
            }
            chain = new Certificate[]{cert};
        }
        X509Certificate[] certChain = new X509Certificate[chain.length];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int count = 0; count < chain.length; ++count) {
            X509Certificate cert;
            ByteArrayInputStream certIn = new ByteArrayInputStream(chain[count].getEncoded());
            certChain[count] = cert = (X509Certificate)cf.generateCertificate(certIn);
        }
        JARVerifier jarVerifier = new JARVerifier(certChain);
        return jarVerifier;
    }

    public final void verifySingleJarFile(JarFile jf) throws IOException, CertificateException, VerifierException {
        Vector<JarEntry> entriesVec = new Vector<JarEntry>();
        Manifest man = jf.getManifest();
        if (man == null) {
            throw new VerifierException("The JAR is not signed");
        }
        byte[] buffer = new byte[8192];
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            int n;
            JarEntry je = entries.nextElement();
            entriesVec.addElement(je);
            InputStream is = jf.getInputStream(je);
            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            }
            is.close();
        }
        jf.close();
        Enumeration e = entriesVec.elements();
        while (e.hasMoreElements()) {
            JarEntry je = (JarEntry)e.nextElement();
            if (je.isDirectory()) continue;
            Certificate[] certs = je.getCertificates();
            if (certs == null || certs.length == 0) {
                if (je.getName().startsWith("META-INF")) continue;
                throw new VerifierException("The JAR file has unsigned files.");
            }
            Certificate[] chainRoots = JARVerifier.getChainRoots(certs);
            boolean signedAsExpected = false;
            for (int i = 0; i < chainRoots.length; ++i) {
                if (!JARVerifier.isTrusted((X509Certificate)chainRoots[i], this.trustedCaCerts)) continue;
                signedAsExpected = true;
                break;
            }
            if (signedAsExpected) continue;
            throw new VerifierException("The JAR file is not signed by a trusted signer");
        }
    }

    private static boolean isTrusted(X509Certificate cert, X509Certificate[] trustedCaCerts) {
        int i;
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!cert.getSubjectDN().equals(trustedCaCerts[i].getSubjectDN()) || !cert.equals(trustedCaCerts[i])) continue;
            return true;
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!cert.getIssuerDN().equals(trustedCaCerts[i].getSubjectDN())) continue;
            try {
                cert.verify(trustedCaCerts[i].getPublicKey());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static Certificate[] getChainRoots(Certificate[] certs) {
        Vector<Certificate> result = new Vector<Certificate>(3);
        for (int i = 0; i < certs.length - 1; ++i) {
            if (((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN())) continue;
            result.addElement(certs[i]);
        }
        result.addElement(certs[certs.length - 1]);
        Object[] ret = new Certificate[result.size()];
        result.copyInto(ret);
        return ret;
    }

    public static final class VerifierException
    extends Exception {
        public VerifierException(Throwable throwable) {
            super(throwable);
        }

        public VerifierException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public VerifierException(String s) {
            super(s);
        }

        public VerifierException() {
        }
    }
}

