/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkSupportService;
import com.dtolabs.rundeck.core.execution.service.MissingProviderException;
import com.dtolabs.rundeck.core.execution.service.ProviderLoaderException;
import com.dtolabs.rundeck.core.plugins.BasePluginProviderService;
import com.dtolabs.rundeck.core.plugins.CloseableProvider;
import com.dtolabs.rundeck.core.plugins.PluggableProviderService;
import com.dtolabs.rundeck.core.plugins.PluggableService;
import com.dtolabs.rundeck.core.plugins.PluginCache;
import com.dtolabs.rundeck.core.plugins.PluginMetadata;
import com.dtolabs.rundeck.core.plugins.PluginResourceLoader;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.ServiceProviderLoader;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import com.dtolabs.rundeck.plugins.ServiceTypes;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PluginManagerService
implements FrameworkSupportService,
ServiceProviderLoader {
    private static final Logger log = Logger.getLogger((String)PluginManagerService.class.getName());
    public static final String SERVICE_NAME = "PluginManager";
    private File extdir;
    private File cachedir;
    private PluginCache cache;
    private Map<String, String> serviceAliases;

    public PluginManagerService() {
    }

    @Override
    public <T> PluggableProviderService<T> createPluginService(Class<T> type, String serviceName) {
        PluggableProviderService<T> pluginProviderService = ServiceTypes.getPluginProviderService(type, serviceName, this);
        if (null != pluginProviderService) {
            return pluginProviderService;
        }
        BasePluginProviderService<T> basePluginProviderService = new BasePluginProviderService<T>(serviceName, type);
        basePluginProviderService.setRundeckServerServiceProviderLoader(this);
        return basePluginProviderService;
    }

    public PluginManagerService(File extdir, File cachedir, PluginCache cache) {
        this.setExtdir(extdir);
        this.setCachedir(cachedir);
        this.setCache(cache);
        log.debug((Object)("Create PluginManagerService with cache: " + cache));
    }

    public static FileCache<ProviderLoader> createProviderLoaderFileCache() {
        return new FileCache<ProviderLoader>();
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    public static PluginManagerService getInstanceForFramework(Framework framework) {
        return (PluginManagerService)framework.getService(SERVICE_NAME);
    }

    @Override
    public synchronized List<ProviderIdent> listProviders() {
        return this.getCache().listProviders();
    }

    @Override
    public <T> CloseableProvider<T> loadCloseableProvider(PluggableService<T> service, String providerName) throws ProviderLoaderException {
        CloseableProvider<T> load;
        ProviderIdent ident = new ProviderIdent(service.getName(), providerName);
        ProviderLoader loaderForIdent = this.getCache().getLoaderForIdent(ident);
        if (null == loaderForIdent) {
            throw new MissingProviderException("No matching plugin found", service.getName(), providerName);
        }
        if (service.canLoadWithLoader(loaderForIdent) && null != (load = service.loadCloseableWithLoader(providerName, loaderForIdent))) {
            return load;
        }
        throw new ProviderLoaderException("Unable to load provider: " + providerName + ", for service: " + service.getName(), service.getName(), providerName);
    }

    @Override
    public synchronized <T> T loadProvider(PluggableService<T> service, String providerName) throws ProviderLoaderException {
        T load;
        ProviderIdent ident = new ProviderIdent(service.getName(), providerName);
        ProviderLoader loaderForIdent = this.getCache().getLoaderForIdent(ident);
        if (null == loaderForIdent) {
            throw new MissingProviderException("No matching plugin found", service.getName(), providerName);
        }
        if (service.canLoadWithLoader(loaderForIdent) && null != (load = service.loadWithLoader(providerName, loaderForIdent))) {
            return load;
        }
        throw new ProviderLoaderException("Unable to load provider: " + providerName + ", for service: " + service.getName(), service.getName(), providerName);
    }

    @Override
    public PluginResourceLoader getResourceLoader(String service, String provider) throws ProviderLoaderException {
        PluginResourceLoader pluginResourceLoader = this.tryResourceLoader(service, provider);
        if (pluginResourceLoader == null && this.serviceAliases != null && this.serviceAliases.containsKey(service)) {
            pluginResourceLoader = this.tryResourceLoader(this.serviceAliases.get(service), provider);
        }
        return pluginResourceLoader;
    }

    private PluginResourceLoader tryResourceLoader(String service, String provider) throws ProviderLoaderException {
        ProviderLoader loaderForIdent = this.getCache().getLoaderForIdent(new ProviderIdent(service, provider));
        if (null != loaderForIdent && loaderForIdent instanceof PluginResourceLoader) {
            return (PluginResourceLoader)((Object)loaderForIdent);
        }
        return null;
    }

    @Override
    public PluginMetadata getPluginMetadata(String service, String provider) throws ProviderLoaderException {
        PluginMetadata pluginMetadata = this.tryPluginMetadata(service, provider);
        if (pluginMetadata == null && this.serviceAliases != null && this.serviceAliases.containsKey(service)) {
            pluginMetadata = this.tryPluginMetadata(this.serviceAliases.get(service), provider);
        }
        return pluginMetadata;
    }

    private PluginMetadata tryPluginMetadata(String service, String provider) throws ProviderLoaderException {
        ProviderLoader loaderForIdent = this.getCache().getLoaderForIdent(new ProviderIdent(service, provider));
        if (null != loaderForIdent && loaderForIdent instanceof PluginMetadata) {
            return (PluginMetadata)((Object)loaderForIdent);
        }
        return null;
    }

    public File getExtdir() {
        return this.extdir;
    }

    public void setExtdir(File extdir) {
        this.extdir = extdir;
    }

    public File getCachedir() {
        return this.cachedir;
    }

    public void setCachedir(File cachedir) {
        this.cachedir = cachedir;
    }

    public PluginCache getCache() {
        return this.cache;
    }

    public void setCache(PluginCache cache) {
        this.cache = cache;
    }

    public Map<String, String> getServiceAliases() {
        return this.serviceAliases;
    }

    public void setServiceAliases(Map<String, String> serviceAliases) {
        this.serviceAliases = serviceAliases;
    }
}

