/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.common.UpdateUtils;
import com.dtolabs.rundeck.core.common.impl.URLFileUpdater;
import com.dtolabs.rundeck.core.common.impl.URLFileUpdaterBuilder;
import com.dtolabs.rundeck.core.plugins.configuration.Configurable;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyValidator;
import com.dtolabs.rundeck.core.plugins.configuration.ValidationException;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParser;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserException;
import com.dtolabs.rundeck.core.resources.format.UnsupportedFormatException;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class URLResourceModelSource
implements ResourceModelSource,
Configurable {
    static final Logger logger = Logger.getLogger((String)URLResourceModelSource.class.getName());
    public static final int DEFAULT_TIMEOUT = 30;
    private final Framework framework;
    Configuration configuration;
    private File destinationTempFile;
    private File destinationCacheData;
    private String tempFileName;
    URLFileUpdater.httpClientInteraction interaction;
    static final HashSet<String> allowedProtocols = new HashSet<String>(Arrays.asList("http", "https", "file"));
    public static final Description DESCRIPTION = DescriptionBuilder.builder().name("url").title("URL Source").description("Retrieves a URL containing node definitions in a supported format").property(PropertyBuilder.builder().string("url").title("URL").description("URL for the remote resource model document").required(true).validator(new URLValidator()).build()).property(PropertyBuilder.builder().integer("timeout").title("Timeout").description("Timeout (in seconds) before requests fail. 0 means no timeout.").defaultValue("30").build()).property(PropertyBuilder.builder().booleanType("cache").title("Cache results").description("Refresh results only if modified?").required(true).defaultValue("true").build()).metadata("faicon", "globe").build();

    public URLResourceModelSource(Framework framework) {
        this.framework = framework;
    }

    @Override
    public void configure(Properties configuration) throws ConfigurationException {
        this.configuration = new Configuration(configuration);
        this.configuration.validate();
        this.tempFileName = this.hashURL(this.configuration.nodesUrl.toExternalForm()) + ".temp";
        this.destinationTempFile = new File(this.framework.getBaseDir(), "var/urlResourceModelSourceCache/" + this.configuration.project + "/" + this.tempFileName);
        this.destinationCacheData = new File(this.framework.getBaseDir(), "var/urlResourceModelSourceCache/" + this.configuration.project + "/" + this.tempFileName + ".cache.properties");
        if (!this.destinationTempFile.getParentFile().isDirectory() && !this.destinationTempFile.getParentFile().mkdirs()) {
            logger.warn((Object)("Unable to create destination directory: " + this.destinationTempFile.getParentFile().getAbsolutePath()));
        }
    }

    private String hashURL(String url) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(url.getBytes(Charset.forName("UTF-8")));
            return new String(Hex.encodeHex((byte[])digest.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return Integer.toString(url.hashCode());
        }
    }

    @Override
    public INodeSet getNodes() throws ResourceModelSourceException {
        ResourceFormatParser parser;
        URLFileUpdaterBuilder urlFileUpdaterBuilder = new URLFileUpdaterBuilder().setUrl(this.configuration.nodesUrl).setAcceptHeader("*/*").setTimeout(this.configuration.timeout);
        if (this.configuration.useCache) {
            urlFileUpdaterBuilder.setCacheMetadataFile(this.destinationCacheData).setCachedContent(this.destinationTempFile).setUseCaching(true);
        }
        URLFileUpdater updater = urlFileUpdaterBuilder.createURLFileUpdater();
        try {
            if (null != this.interaction) {
                updater.setInteraction(this.interaction);
            }
            UpdateUtils.update(updater, this.destinationTempFile);
            logger.debug((Object)("Updated nodes resources file: " + this.destinationTempFile));
        }
        catch (UpdateUtils.UpdateException e) {
            if (!this.destinationTempFile.isFile() || this.destinationTempFile.length() < 1L) {
                throw new ResourceModelSourceException("Error requesting URL Resource Model Source: " + this.configuration.nodesUrl + ": " + e.getMessage(), e);
            }
            logger.error((Object)("Error requesting URL Resource Model Source: " + this.configuration.nodesUrl + ": " + e.getMessage()), (Throwable)e);
        }
        if ("file".equalsIgnoreCase(this.configuration.nodesUrl.getProtocol())) {
            try {
                parser = this.framework.getResourceFormatParserService().getParserForFileExtension(new File(this.configuration.nodesUrl.toURI()));
            }
            catch (UnsupportedFormatException e) {
                throw new ResourceModelSourceException("Error requesting URL Resource Model Source: " + this.configuration.nodesUrl + ": No supported format available for file extension", e);
            }
            catch (URISyntaxException e) {
                throw new ResourceModelSourceException("Error requesting URL Resource Model Source: " + this.configuration.nodesUrl + ": " + e.getMessage(), e);
            }
            logger.debug((Object)("Determined URL content format from file name: " + this.configuration.nodesUrl));
        } else {
            String mimetype = updater.getContentType();
            try {
                parser = this.framework.getResourceFormatParserService().getParserForMIMEType(mimetype);
            }
            catch (UnsupportedFormatException e) {
                throw new ResourceModelSourceException("Error requesting URL Resource Model Source: " + this.configuration.nodesUrl + ": Response content type is not supported: " + mimetype, e);
            }
            logger.debug((Object)("Determined URL content format from MIME type: " + mimetype));
        }
        if (this.destinationTempFile.isFile() && this.destinationTempFile.length() > 0L) {
            try {
                return parser.parseDocument(this.destinationTempFile);
            }
            catch (ResourceFormatParserException e) {
                throw new ResourceModelSourceException("Error requesting URL Resource Model Source: " + this.configuration.nodesUrl + ": Content could not be parsed: " + e.getMessage(), e);
            }
        }
        return new NodeSetImpl();
    }

    public String toString() {
        return "URLResourceModelSource{URL='" + this.configuration.nodesUrl + '\'' + '}';
    }

    public static class Configuration {
        public static final String URL = "url";
        public static final String PROJECT = "project";
        public static final String CACHE = "cache";
        public static final String TIMEOUT = "timeout";
        URL nodesUrl;
        String project;
        boolean useCache = true;
        int timeout = 30;
        private final Properties properties;

        Configuration() {
            this.properties = new Properties();
        }

        Configuration(Properties configuration) {
            if (null == configuration) {
                throw new NullPointerException("configuration");
            }
            this.properties = configuration;
            this.configure();
        }

        private void configure() {
            if (this.properties.containsKey(URL)) {
                try {
                    this.nodesUrl = new URL(this.properties.getProperty(URL));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            if (this.properties.containsKey(PROJECT)) {
                this.project = this.properties.getProperty(PROJECT);
            }
            if (this.properties.containsKey(CACHE)) {
                this.useCache = Boolean.parseBoolean(this.properties.getProperty(CACHE));
            }
            if (this.properties.containsKey(TIMEOUT)) {
                try {
                    this.timeout = Integer.parseInt(this.properties.getProperty(TIMEOUT));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        void validate() throws ConfigurationException {
            if (null == this.project) {
                throw new ConfigurationException("project is required");
            }
            if (null == this.nodesUrl && this.properties.containsKey(URL)) {
                try {
                    this.nodesUrl = new URL(this.properties.getProperty(URL));
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("url is malformed: " + e.getMessage(), e);
                }
            } else if (null == this.nodesUrl) {
                throw new ConfigurationException("url is required");
            }
            if (null != this.nodesUrl && !allowedProtocols.contains(this.nodesUrl.getProtocol().toLowerCase())) {
                throw new ConfigurationException("url protocol not allowed: " + this.nodesUrl.getProtocol());
            }
            if (this.properties.containsKey(TIMEOUT)) {
                try {
                    this.timeout = Integer.parseInt(this.properties.getProperty(TIMEOUT));
                }
                catch (NumberFormatException e) {
                    throw new ConfigurationException("timeout is invalid: " + e.getMessage(), e);
                }
            }
        }

        Configuration(Configuration configuration) {
            this(configuration.getProperties());
        }

        public Configuration url(String url) {
            try {
                this.nodesUrl = new URL(url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.properties.setProperty(URL, url);
            return this;
        }

        public Configuration project(String project) {
            this.project = project;
            this.properties.setProperty(PROJECT, project);
            return this;
        }

        public Configuration cache(boolean cache) {
            this.useCache = cache;
            this.properties.setProperty(CACHE, Boolean.toString(cache));
            return this;
        }

        public Configuration timeout(int timeout) {
            this.timeout = timeout;
            this.properties.setProperty(TIMEOUT, Integer.toString(timeout));
            return this;
        }

        public static Configuration fromProperties(Properties configuration) {
            return new Configuration(configuration);
        }

        public static Configuration clone(Configuration configuration) {
            return Configuration.fromProperties(configuration.getProperties());
        }

        public static Configuration build() {
            return new Configuration();
        }

        public Properties getProperties() {
            return this.properties;
        }
    }

    public static final class URLValidator
    implements PropertyValidator {
        @Override
        public boolean isValid(String value) throws ValidationException {
            URL url;
            try {
                url = new URL(value);
            }
            catch (MalformedURLException e) {
                throw new ValidationException(e.getMessage());
            }
            if (null != url && !allowedProtocols.contains(url.getProtocol().toLowerCase())) {
                throw new ValidationException("url protocol not supported: " + url.getProtocol());
            }
            return true;
        }
    }
}

