/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.StateObj;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface WorkflowSystem<P> {
    public <D, T extends OperationCompleted<D>, X extends Operation<D, T>> Set<OperationResult<D, T, X>> processOperations(Set<X> var1, SharedData<D, P> var2);

    public boolean isInterrupted();

    public static interface Operation<X, T extends OperationCompleted>
    extends Function<X, T> {
        public String getIdentity();

        public boolean shouldRun(StateObj var1);

        public boolean shouldSkip(StateObj var1);

        public StateObj getSkipState(StateObj var1);

        public StateObj getFailureState(Throwable var1);
    }

    public static interface OperationCompleted<T> {
        public String getIdentity();

        public StateObj getNewState();

        public boolean isSuccess();

        public T getResult();
    }

    public static interface SharedData<T, Y> {
        public void addData(T var1);

        public T produceNext();

        public Y produceState();

        public static <T, Y> SharedData<T, Y> with(final Consumer<T> adder, final Supplier<T> producer, final Supplier<Y> stateProducer) {
            return new SharedData<T, Y>(){

                @Override
                public void addData(T item) {
                    adder.accept(item);
                }

                @Override
                public T produceNext() {
                    return producer.get();
                }

                @Override
                public Y produceState() {
                    return stateProducer.get();
                }
            };
        }
    }

    public static interface OperationResult<D, T extends OperationCompleted<D>, X extends Operation<D, T>> {
        public Throwable getFailure();

        public T getSuccess();

        public X getOperation();
    }
}

