/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.ValidationSet;
import com.dtolabs.rundeck.core.authorization.providers.CacheableYamlSource;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesParseException;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import com.dtolabs.rundeck.core.authorization.providers.SourceProvider;
import com.dtolabs.rundeck.core.authorization.providers.YamlProvider;
import com.dtolabs.rundeck.core.authorization.providers.YamlSource;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.parser.ParserException;

public class PoliciesCache
implements Iterable<PolicyCollection> {
    static final long DIR_LIST_CHECK_DELAY = Long.getLong(PoliciesCache.class.getName() + ".DirListCheckDelay", 60000L);
    static final long FILE_CHECK_DELAY = Long.getLong(PoliciesCache.class.getName() + ".FileCheckDelay", 60000L);
    private static final Logger logger = Logger.getLogger(PoliciesCache.class);
    private Set<File> warned = new HashSet<File>();
    private Map<String, CacheItem> cache = new HashMap<String, CacheItem>();
    private SourceProvider provider;
    private final Set<Attribute> forcedContext;
    private Map<CacheableYamlSource, Long> cooldownset = Collections.synchronizedMap(new HashMap());

    private PoliciesCache(SourceProvider provider) {
        this.provider = provider;
        this.forcedContext = null;
    }

    private PoliciesCache(SourceProvider provider, Set<Attribute> forcedContext) {
        this.provider = provider;
        this.forcedContext = forcedContext;
    }

    private PolicyCollection createEntry(YamlSource source, ValidationSet validation) throws PoliciesParseException {
        try {
            return YamlProvider.policiesFromSource(source, this.forcedContext, validation);
        }
        catch (ParserException e1) {
            throw new PoliciesParseException("YAML syntax error: " + e1.toString(), e1);
        }
        catch (Exception e1) {
            throw new PoliciesParseException(e1);
        }
    }

    public synchronized PolicyCollection getDocument(CacheableYamlSource source) throws PoliciesParseException {
        CacheItem entry = this.cache.get(source.getIdentity());
        long checkTime = System.currentTimeMillis();
        if (null == entry || checkTime - entry.cacheTime > FILE_CHECK_DELAY) {
            long lastmod = source.getLastModified().getTime();
            if (null == entry || lastmod > entry.modTime) {
                if (!source.isValid()) {
                    CacheItem remove = this.cache.remove(source.getIdentity());
                    entry = null;
                } else {
                    ValidationSet validation = new ValidationSet();
                    PolicyCollection entry1 = this.createEntry(source, validation);
                    validation.complete();
                    if (null != entry1) {
                        entry = new CacheItem(entry1, lastmod);
                        this.cache.put(source.getIdentity(), entry);
                        if (!validation.isValid()) {
                            logger.warn((Object)validation.toString());
                            System.err.println(validation.toString());
                        }
                    } else {
                        this.cache.remove(source.getIdentity());
                        entry = null;
                        if (!validation.isValid()) {
                            throw new PoliciesParseException(validation.toString());
                        }
                    }
                }
            } else {
                entry.touch(checkTime);
            }
        }
        return null != entry ? entry.policyCollection : null;
    }

    @Override
    public Iterator<PolicyCollection> iterator() {
        return new cacheIterator(this.provider.getSourceIterator());
    }

    public static PoliciesCache fromFile(File singleFile) {
        return PoliciesCache.fromSourceProvider(YamlProvider.getFileProvider(singleFile));
    }

    public static PoliciesCache fromFile(File singleFile, Set<Attribute> forcedContext) {
        return PoliciesCache.fromSourceProvider(YamlProvider.getFileProvider(singleFile), forcedContext);
    }

    public static PoliciesCache fromSourceProvider(SourceProvider provider) {
        return new PoliciesCache(provider);
    }

    public static PoliciesCache fromSourceProvider(SourceProvider provider, Set<Attribute> forcedContext) {
        return new PoliciesCache(provider, forcedContext);
    }

    public static PoliciesCache fromDir(File rootDir) {
        return PoliciesCache.fromSourceProvider(YamlProvider.getDirProvider(rootDir));
    }

    public static PoliciesCache fromDir(File rootDir, Set<Attribute> forcedContext) {
        return PoliciesCache.fromSourceProvider(YamlProvider.getDirProvider(rootDir), forcedContext);
    }

    public static PoliciesCache fromSources(final Iterable<CacheableYamlSource> sources) {
        return PoliciesCache.fromSourceProvider(new SourceProvider(){

            @Override
            public Iterator<CacheableYamlSource> getSourceIterator() {
                return sources.iterator();
            }
        });
    }

    public static PoliciesCache fromSources(final Iterable<CacheableYamlSource> sources, Set<Attribute> context) {
        return PoliciesCache.fromSourceProvider(new SourceProvider(){

            @Override
            public Iterator<CacheableYamlSource> getSourceIterator() {
                return sources.iterator();
            }
        }, context);
    }

    private class cacheIterator
    implements Iterator<PolicyCollection> {
        Iterator<CacheableYamlSource> intIter;
        private CacheableYamlSource nextSource;
        private PolicyCollection nextPolicyCollection;

        public cacheIterator(Iterator<CacheableYamlSource> intIter) {
            this.intIter = intIter;
            this.nextSource = this.intIter.hasNext() ? this.intIter.next() : null;
            this.loadNextSource();
        }

        private void loadNextSource() {
            while (this.hasNextFile() && null == this.nextPolicyCollection) {
                CacheableYamlSource newNextSource = this.getNextSource();
                Long aLong = (Long)PoliciesCache.this.cooldownset.get(newNextSource);
                if (null != aLong && newNextSource.getLastModified().getTime() == aLong.longValue()) {
                    logger.debug((Object)("Skip parsing of: " + newNextSource + ". Reason: parse error cooldown until modified"));
                    continue;
                }
                if (null != aLong) {
                    PoliciesCache.this.cooldownset.remove(newNextSource);
                }
                try {
                    this.nextPolicyCollection = PoliciesCache.this.getDocument(newNextSource);
                }
                catch (PoliciesParseException e) {
                    logger.error((Object)("ERROR unable to parse aclpolicy: " + newNextSource + ". Reason: " + e.getMessage()));
                    logger.debug((Object)("ERROR unable to parse aclpolicy: " + newNextSource + ". Reason: " + e.getMessage()), (Throwable)e);
                    PoliciesCache.this.cache.remove(newNextSource.getIdentity());
                    PoliciesCache.this.cooldownset.put(newNextSource, newNextSource.getLastModified().getTime());
                }
            }
        }

        private CacheableYamlSource getNextSource() {
            CacheableYamlSource next = this.nextSource;
            this.nextSource = this.intIter.hasNext() ? this.intIter.next() : null;
            return next;
        }

        private PolicyCollection getNextPolicyCollection() {
            PolicyCollection doc = this.nextPolicyCollection;
            this.nextPolicyCollection = null;
            this.loadNextSource();
            return doc;
        }

        public boolean hasNextFile() {
            return null != this.nextSource;
        }

        @Override
        public boolean hasNext() {
            return null != this.nextPolicyCollection;
        }

        @Override
        public PolicyCollection next() {
            return this.getNextPolicyCollection();
        }

        @Override
        public void remove() {
        }
    }

    private static class CacheItem {
        PolicyCollection policyCollection;
        Long cacheTime;
        Long modTime;

        private CacheItem(PolicyCollection policyCollection, Long modTime) {
            this.policyCollection = policyCollection;
            this.modTime = modTime;
            this.cacheTime = System.currentTimeMillis();
        }

        public void touch(Long time) {
            this.cacheTime = time;
        }
    }
}

