/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.resources.DelegateResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import org.apache.log4j.Logger;

public abstract class ExceptionCatchingResourceModelSource
extends DelegateResourceModelSource {
    public static final Logger logger = Logger.getLogger(ExceptionCatchingResourceModelSource.class);
    String identity;
    ExceptionHandler handler;

    protected ExceptionCatchingResourceModelSource(ResourceModelSource delegate) {
        super(delegate);
    }

    protected ExceptionCatchingResourceModelSource(ResourceModelSource delegate, String identity) {
        super(delegate);
        this.identity = identity;
    }

    protected ExceptionCatchingResourceModelSource(ResourceModelSource delegate, String identity, ExceptionHandler handler) {
        super(delegate);
        this.identity = identity;
        this.handler = handler;
    }

    @Override
    public INodeSet getNodes() throws ResourceModelSourceException {
        INodeSet nodes;
        block4: {
            nodes = null;
            try {
                nodes = this.getDelegate().getNodes();
            }
            catch (Throwable e) {
                this.logException(e);
                if (null == this.handler) break block4;
                this.handler.handleException(e, this.getDelegate());
            }
        }
        try {
            return this.returnResultNodes(nodes);
        }
        catch (Throwable e) {
            this.logException(e);
            return nodes;
        }
    }

    private void logException(Throwable e) {
        logger.error((Object)(null != this.identity ? this.identity + " " : "" + e.getMessage()), e);
    }

    abstract INodeSet returnResultNodes(INodeSet var1) throws ResourceModelSourceException;

    public static interface ExceptionHandler {
        public void handleException(Throwable var1, ResourceModelSource var2);
    }
}

