/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.DataState;
import com.dtolabs.rundeck.core.rules.Rules;
import com.dtolabs.rundeck.core.rules.StateObj;
import com.dtolabs.rundeck.core.rules.StateWorkflowSystem;
import com.dtolabs.rundeck.core.rules.WorkflowEngine;
import com.dtolabs.rundeck.core.rules.WorkflowSystem;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventHandler;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventType;
import com.dtolabs.rundeck.core.rules.Workflows;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class WorkflowEngineOperationsProcessor<DAT, RES extends WorkflowSystem.OperationCompleted<DAT>, OP extends WorkflowSystem.Operation<DAT, RES>> {
    private StateWorkflowSystem workflowEngine;
    private WorkflowSystemEventHandler eventHandler;
    private final Set<OP> operations;
    private final WorkflowSystem.SharedData<DAT, Map<String, String>> sharedData;
    private final Set<WorkflowSystem.Operation> inProcess = Collections.synchronizedSet(new HashSet());
    private final Set<WorkflowSystem.Operation> skipped = new HashSet<WorkflowSystem.Operation>();
    private final Set<OP> pending;
    private volatile boolean interrupted;
    private StateObj initialState = Workflows.getWorkflowStartState();
    private final ListeningExecutorService executorService;
    private final ListeningExecutorService manager;
    private final LinkedBlockingQueue<WorkflowSystem.OperationCompleted<DAT>> stateChangeQueue = new LinkedBlockingQueue();
    private final Set<WorkflowSystem.OperationResult<DAT, RES, OP>> results = Collections.synchronizedSet(new HashSet());
    private final List<ListenableFuture<RES>> futures = new ArrayList<ListenableFuture<RES>>();
    private WorkflowEngine.Sleeper sleeper = new WorkflowEngine.Sleeper();
    private boolean endStateBreak = Boolean.parseBoolean(System.getProperty("WorkflowEngineOperationsProcessor.endStateBreak", "false"));
    private boolean endStateCancel = Boolean.parseBoolean(System.getProperty("WorkflowEngineOperationsProcessor.endStateCancel", "false"));
    private boolean endStateCancelInterrupt = Boolean.parseBoolean(System.getProperty("WorkflowEngineOperationsProcessor.endStateCancelInterrupt", "false"));

    public WorkflowEngineOperationsProcessor(StateWorkflowSystem workflowEngine, WorkflowSystemEventHandler eventHandler, Set<OP> operations, WorkflowSystem.SharedData<DAT, Map<String, String>> sharedData, ListeningExecutorService executorService, ListeningExecutorService manager) {
        this.workflowEngine = workflowEngine;
        this.eventHandler = eventHandler;
        this.operations = operations;
        this.sharedData = sharedData;
        this.pending = new HashSet<OP>(operations);
        this.executorService = executorService;
        this.manager = manager;
    }

    public void beginProcessing() {
        this.eventHandler.event(WorkflowSystemEventType.Begin, "Workflow begin", StateWorkflowSystem.stateEvent(this.workflowEngine.getState(), this.sharedData));
        this.initialize();
        this.continueProcessing();
    }

    private void continueProcessing() {
        boolean cancel = false;
        boolean cancelInterrupt = false;
        try {
            while (!Thread.currentThread().isInterrupted()) {
                boolean changed = false;
                if (!(changed |= this.processCompletedChanges(this.waitForChanges()))) {
                    if (this.detectNoMoreChanges()) {
                        this.eventHandler.event(WorkflowSystemEventType.EndOfChanges, "No more state changes expected, finishing workflow.", StateWorkflowSystem.stateEvent(this.workflowEngine.getState(), this.sharedData));
                        return;
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    break;
                }
                if (this.workflowEngine.isWorkflowEndState()) {
                    this.eventHandler.event(WorkflowSystemEventType.WorkflowEndState, "Workflow end state reached.", StateWorkflowSystem.stateEvent(this.workflowEngine.getState(), this.sharedData));
                    if (this.endStateBreak) {
                        cancel = this.endStateCancel;
                        cancelInterrupt = this.endStateCancelInterrupt;
                        break;
                    }
                    return;
                }
                this.processOperations(this.results::add);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (Thread.currentThread().isInterrupted()) {
            this.eventHandler.event(WorkflowSystemEventType.Interrupted, "Engine interrupted, stopping engine...");
            this.cancelFutures(true);
            this.interrupted = Thread.interrupted();
        } else if (cancel) {
            this.cancelFutures(cancelInterrupt);
        }
        this.awaitFutures();
    }

    private boolean processCompletedChanges(List<WorkflowSystem.OperationCompleted<DAT>> operationCompleteds) {
        if (operationCompleteds == null) {
            return false;
        }
        boolean changed = false;
        for (WorkflowSystem.OperationCompleted<DAT> task : operationCompleteds) {
            DAT result = task.getResult();
            HashMap<String, String> state = new HashMap<String, String>(task.getNewState().getState());
            changed |= this.workflowEngine.processStateChange(StateWorkflowSystem.stateChange(task.getIdentity(), () -> {
                if (null != this.sharedData && null != result) {
                    this.sharedData.addData(result);
                    Map<String, String> sharedState = this.sharedData.produceState();
                    state.putAll(sharedState);
                }
                return state;
            }, this.sharedData));
        }
        return changed;
    }

    boolean detectNoMoreChanges() {
        return this.inProcess.isEmpty() && this.stateChangeQueue.isEmpty();
    }

    private List<WorkflowSystem.OperationCompleted<DAT>> pollChanges() {
        ArrayList<WorkflowSystem.OperationCompleted<DAT>> changes = new ArrayList<WorkflowSystem.OperationCompleted<DAT>>();
        WorkflowSystem.OperationCompleted<DAT> task = this.stateChangeQueue.poll();
        while (task != null && task.getNewState() != null) {
            changes.add(task);
            task = this.stateChangeQueue.poll();
        }
        return changes;
    }

    private void awaitFutures() {
        if (!this.inProcess.isEmpty()) {
            for (ListenableFuture<RES> future : this.futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | CancellationException | ExecutionException exception) {}
            }
        }
    }

    private void cancelFutures(boolean mayInterruptIfRunning) {
        this.futures.forEach(future -> future.cancel(mayInterruptIfRunning));
    }

    public void initialize() {
        this.stateChangeQueue.add(WorkflowEngine.dummyResult(this.initialState, "init", true));
    }

    private void processRunnableOperations(Consumer<WorkflowSystem.OperationResult<DAT, RES, OP>> resultConsumer, List<OP> shouldrun, List<OP> shouldskip, DAT inputData) {
        for (WorkflowSystem.Operation operation : shouldrun) {
            if (shouldskip.contains(operation)) continue;
            this.pending.remove(operation);
            this.eventHandler.event(WorkflowSystemEventType.WillRunOperation, String.format("operation starting: %s", operation), StateWorkflowSystem.operationEvent(operation.getIdentity(), this.workflowEngine.getState(), this.sharedData));
            ListenableFuture<RES> submit = this.beginOperation(inputData, operation);
            OperationFutureCallback callback = new OperationFutureCallback(this, this.eventHandler, operation, resultConsumer);
            Futures.addCallback(submit, (FutureCallback)callback, (Executor)this.manager);
        }
    }

    private ListenableFuture<RES> beginOperation(DAT inputData, OP operation) {
        ListenableFuture submit = this.executorService.submit(() -> (WorkflowSystem.OperationCompleted)operation.apply(inputData));
        this.inProcess.add((WorkflowSystem.Operation)operation);
        this.futures.add(submit);
        return submit;
    }

    private void finishedOperation(WorkflowSystem.OperationCompleted<DAT> e, OP operation) {
        this.stateChangeQueue.add(e);
        this.inProcess.remove(operation);
    }

    private <D, T extends WorkflowSystem.OperationCompleted<D>, X extends WorkflowSystem.Operation<D, T>> WorkflowSystem.OperationResult<D, T, X> result(Throwable t, X operation) {
        return new WorkflowEngine.WResult(operation, t);
    }

    private <D, T extends WorkflowSystem.OperationCompleted<D>, X extends WorkflowSystem.Operation<D, T>> WorkflowSystem.OperationResult<D, T, X> result(T successResult, X operation) {
        return new WorkflowEngine.WResult(operation, successResult);
    }

    private List<WorkflowSystem.OperationCompleted<DAT>> waitForChanges() throws InterruptedException {
        ArrayList<WorkflowSystem.OperationCompleted<DAT>> results = new ArrayList<WorkflowSystem.OperationCompleted<DAT>>();
        WorkflowSystem.OperationCompleted<DAT> take = this.stateChangeQueue.poll(this.sleeper.time(), this.sleeper.unit());
        if (null == take || take.getNewState().getState().isEmpty()) {
            this.sleeper.backoff();
            return results;
        }
        this.sleeper.reset();
        results.add(take);
        results.addAll(this.pollChanges());
        return results;
    }

    private void processStateChanges(Map<String, String> changes) {
        this.eventHandler.event(WorkflowSystemEventType.WillProcessStateChange, String.format("saw state changes: %s", changes), changes);
        this.workflowEngine.getState().updateState(changes);
        boolean update = Rules.update(this.workflowEngine.getRuleEngine(), this.workflowEngine.getState());
        this.eventHandler.event(WorkflowSystemEventType.DidProcessStateChange, String.format("applied state changes and rules (changed? %s): %s", update, this.workflowEngine.getState()), this.workflowEngine.getState());
    }

    private void processOperations(Consumer<WorkflowSystem.OperationResult<DAT, RES, OP>> resultConsumer) {
        int origPendingCount = this.pending.size();
        List shouldrun = this.pending.stream().filter(input -> input.shouldRun(this.workflowEngine.getState())).collect(Collectors.toList());
        List shouldskip = shouldrun.stream().filter(input -> input.shouldSkip(this.workflowEngine.getState())).collect(Collectors.toList());
        DAT inputData = null != this.sharedData ? (DAT)this.sharedData.produceNext() : null;
        this.processRunnableOperations(resultConsumer, shouldrun, shouldskip, inputData);
        this.processSkippedOperations(shouldskip);
        this.eventHandler.event(WorkflowSystemEventType.LoopProgress, String.format("Pending(%d) => run(%d), skip(%d), remain(%d)", origPendingCount, shouldrun.size() - shouldskip.size(), shouldskip.size(), this.pending.size()));
    }

    private void processSkippedOperations(List<OP> shouldskip) {
        for (WorkflowSystem.Operation operation : shouldskip) {
            this.eventHandler.event(WorkflowSystemEventType.WillSkipOperation, String.format("Skip condition statisfied for operation: %s, skipping", operation), StateWorkflowSystem.operationEvent(operation.getIdentity(), this.workflowEngine.getState(), this.sharedData));
            StateObj newstate = operation.getSkipState(this.workflowEngine.getState());
            WorkflowSystem.OperationCompleted objectOperationCompleted = WorkflowEngine.dummyResult(newstate, operation.getIdentity(), true);
            this.stateChangeQueue.add(objectOperationCompleted);
            this.pending.remove(operation);
            this.skipped.add(operation);
        }
    }

    public Set<OP> getOperations() {
        return this.operations;
    }

    public WorkflowSystem.SharedData<DAT, Map<String, String>> getSharedData() {
        return this.sharedData;
    }

    public Set<WorkflowSystem.Operation> getInProcess() {
        return this.inProcess;
    }

    public Set<WorkflowSystem.Operation> getSkipped() {
        return this.skipped;
    }

    public Set<OP> getPending() {
        return this.pending;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInitialState(StateObj initialState) {
        this.initialState = initialState;
    }

    public StateObj getInitialState() {
        return this.initialState;
    }

    public Set<WorkflowSystem.OperationResult<DAT, RES, OP>> getResults() {
        return this.results;
    }

    static class OperationFutureCallback
    implements FutureCallback<RES> {
        final WorkflowSystemEventHandler eventHandler;
        final OP operation;
        final Consumer<WorkflowSystem.OperationResult<DAT, RES, OP>> resultConsumer;
        final /* synthetic */ WorkflowEngineOperationsProcessor this$0;

        public void onSuccess(RES successResult) {
            WorkflowSystem.OperationResult result = this.this$0.result(successResult, this.operation);
            this.eventHandler.event(result.getSuccess().isSuccess() ? WorkflowSystemEventType.OperationSuccess : WorkflowSystemEventType.OperationFailed, String.format("operation completed, success? %s: %s", result.getSuccess().isSuccess(), successResult), StateWorkflowSystem.operationCompleteEvent(this.operation.getIdentity(), this.this$0.workflowEngine.getState(), this.this$0.sharedData, result));
            assert (successResult != null);
            this.resultConsumer.accept(result);
            this.this$0.finishedOperation(successResult, this.operation);
        }

        public void onFailure(Throwable t) {
            WorkflowSystem.OperationResult result = this.this$0.result((WorkflowSystem.OperationCompleted)((Object)t), (WorkflowSystem.Operation)this.operation);
            this.eventHandler.event(WorkflowSystemEventType.OperationFailed, String.format("operation failed: %s", t), StateWorkflowSystem.operationCompleteEvent(this.operation.getIdentity(), this.this$0.workflowEngine.getState(), this.this$0.sharedData, result));
            this.resultConsumer.accept(result);
            StateObj newFailureState = this.operation.getFailureState(t);
            if (null == newFailureState) {
                newFailureState = new DataState();
            }
            this.this$0.finishedOperation(WorkflowEngine.dummyResult(newFailureState, this.operation.getIdentity(), false), this.operation);
        }

        public OperationFutureCallback(WorkflowSystemEventHandler eventHandler, OP operation, Consumer<WorkflowSystem.OperationResult<DAT, RES, OP>> resultConsumer) {
            this.this$0 = this$0;
            this.eventHandler = eventHandler;
            this.operation = operation;
            this.resultConsumer = resultConsumer;
        }
    }
}

