/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.utils;

import com.dtolabs.rundeck.core.logging.OffsetIterator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Queue;

public class StreamLineIterator
implements OffsetIterator<String> {
    private InputStreamReader read;
    private long offset;
    private Queue<String> buffer = new ArrayDeque<String>();
    private String encoding;
    boolean closed = false;

    public StreamLineIterator(FileInputStream raf, String encoding) throws IOException {
        this(raf, raf.getChannel().position(), encoding);
    }

    public StreamLineIterator(InputStream stream, String encoding) throws IOException {
        this(stream, 0L, encoding);
    }

    private StreamLineIterator(InputStream stream, long initialOffset, String encoding) throws IOException {
        this.encoding = encoding;
        this.offset = initialOffset;
        this.read = encoding != null ? new InputStreamReader(stream, encoding) : new InputStreamReader(stream);
        this.readNext();
    }

    @Override
    public boolean hasNext() {
        return this.buffer.size() > 0;
    }

    @Override
    public String next() {
        String s = this.buffer.remove();
        try {
            this.offset += (long)(s.getBytes(this.encoding).length + 1);
            this.readNext();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return s;
    }

    private void readNext() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Stream is closed");
        }
        String v = StreamLineIterator.readLine(this.read);
        if (null != v) {
            this.buffer.add(v);
        }
    }

    static String readLine(Reader reader) throws IOException {
        StringBuilder line = new StringBuilder(200);
        int ch = reader.read();
        if (ch < 0) {
            return null;
        }
        while (ch > 0 && ch != 10 && ch != 13) {
            line.append((char)ch);
            ch = reader.read();
        }
        return line.toString();
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.read.close();
        this.closed = true;
    }
}

