/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;

public class NodeExecutorResultImpl
extends NodeStepResultImpl
implements NodeExecutorResult {
    public static final String FAILURE_DATA_RESULT_CODE = "resultCode";
    private int resultCode;

    public static NodeExecutorResultImpl createSuccess(INodeEntry node) {
        return new NodeExecutorResultImpl(node, 0);
    }

    private NodeExecutorResultImpl(INodeEntry node, int resultCode) {
        super(node);
        this.resultCode = resultCode;
        this.getFailureData().put(FAILURE_DATA_RESULT_CODE, resultCode);
    }

    public static NodeExecutorResultImpl createFailure(FailureReason reason, String message, Exception exception, INodeEntry node, int resultCode) {
        return new NodeExecutorResultImpl(exception, node, resultCode, reason, message);
    }

    public static NodeExecutorResultImpl createFailure(FailureReason reason, String message, INodeEntry node, int resultCode) {
        return new NodeExecutorResultImpl(null, node, resultCode, reason, message);
    }

    public static NodeExecutorResultImpl createFailure(FailureReason reason, String message, INodeEntry node) {
        return new NodeExecutorResultImpl(null, node, -1, reason, message);
    }

    private NodeExecutorResultImpl(Exception exception, INodeEntry node, int resultCode, FailureReason reason, String failureMessage) {
        super(exception, reason, failureMessage, node);
        this.resultCode = resultCode;
        this.getFailureData().put(FAILURE_DATA_RESULT_CODE, resultCode);
    }

    @Override
    public int getResultCode() {
        return this.resultCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeExecutorResultImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeExecutorResultImpl result = (NodeExecutorResultImpl)o;
        return this.resultCode == result.resultCode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.resultCode;
        return result;
    }

    @Override
    public String toString() {
        return this.isSuccess() ? "Succeeded" : this.getFailureReason() + ": " + this.getFailureMessage();
    }
}

