/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.IFrameworkResource;
import com.dtolabs.rundeck.core.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;

public class FrameworkResource
implements IFrameworkResource {
    public static final String VALID_RESOURCE_NAME_CHARSET_REGEX = "[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*";
    public static final String VALID_RESOURCE_NAME_REGEX = "^[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*$";
    public static final String VALID_RESOURCE_DESCRIPTION_CHARSET_REGEX = "[a-zA-Z0-9\\p{L}\\p{M}\\s\\.,\\(\\)_-]+";
    public static final String VALID_RESOURCE_DESCRIPTION_REGEX = "^[a-zA-Z0-9\\p{L}\\p{M}\\s\\.,\\(\\)_-]+$";
    final Logger logger;
    private final String name;
    private final File baseDir;

    public FrameworkResource(String name, File dir) {
        if ("".equals(name)) {
            throw new IllegalArgumentException("empty string cannot be used as a name");
        }
        this.name = name;
        this.baseDir = dir;
        this.logger = Logger.getLogger((String)this.getClass().getName());
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    public String toString() {
        return this.name;
    }

    protected boolean existsSubdir(String name) {
        return this.getSubdir(name).isDirectory();
    }

    protected File getSubdir(String name) {
        return new File(this.getBaseDir(), name);
    }

    protected List<File> listSubdirs() {
        File[] values = this.getBaseDir().listFiles(file -> file.isDirectory() && file.getName().matches(VALID_RESOURCE_NAME_REGEX));
        if (values != null) {
            return Stream.of(values).collect(Collectors.toList());
        }
        return new ArrayList<File>();
    }

    protected List<String> listSubdirNames() {
        return this.listSubdirs().stream().map(File::getName).collect(Collectors.toList());
    }

    protected boolean removeSubDir(String name) {
        if (this.existsSubdir(name)) {
            return FileUtils.deleteDir(this.getSubdir(name));
        }
        return false;
    }
}

