/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.FilesystemFramework;
import com.dtolabs.rundeck.core.common.IFilesystemFramework;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfigModifier;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import com.dtolabs.rundeck.core.utils.PropertyLookup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class FrameworkProjectConfig
implements IRundeckProjectConfig,
IRundeckProjectConfigModifier {
    public static final String PROP_FILENAME = "project.properties";
    public static final String ETC_DIR_NAME = "etc";
    public static final Logger logger = Logger.getLogger(FrameworkProjectConfig.class);
    private String name;
    private PropertyLookup lookup;
    private PropertyLookup projectLookup;
    private File propertyFile;
    private IFilesystemFramework filesystemFramework;
    private long propertiesLastReload = 0L;

    public FrameworkProjectConfig(String name, File propertyFile, IFilesystemFramework filesystemFramework) {
        this.name = name;
        this.propertyFile = propertyFile;
        this.filesystemFramework = filesystemFramework;
        this.loadProperties();
    }

    public static FrameworkProjectConfig create(String name, File propertyFile, IFilesystemFramework filesystemFramework) {
        return new FrameworkProjectConfig(name, propertyFile, filesystemFramework);
    }

    public static FrameworkProjectConfig create(String name, File propertyFile, Properties properties, IFilesystemFramework filesystemFramework) {
        if (!propertyFile.exists()) {
            FrameworkProjectConfig.generateProjectPropertiesFile(name, propertyFile, false, properties, true);
        }
        return FrameworkProjectConfig.create(name, propertyFile, filesystemFramework);
    }

    static void generateProjectPropertiesFile(String name, File destfile, boolean overwrite, Properties properties, boolean addDefaultProps) {
        FrameworkProjectConfig.generateProjectPropertiesFile(name, destfile, overwrite, properties, false, null, addDefaultProps);
    }

    @Override
    public void mergeProjectProperties(Properties properties, Set<String> removePrefixes) {
        FrameworkProjectConfig.generateProjectPropertiesFile(this.getName(), this.propertyFile, true, properties, true, removePrefixes, false);
        this.loadProperties();
    }

    @Override
    public void setProjectProperties(Properties properties) {
        FrameworkProjectConfig.generateProjectPropertiesFile(this.getName(), this.propertyFile, true, properties, false, null, false);
        this.loadProperties();
    }

    @Override
    public void generateProjectPropertiesFile(boolean overwrite, Properties properties, boolean addDefault) {
        FrameworkProjectConfig.generateProjectPropertiesFile(this.getName(), this.propertyFile, overwrite, properties, false, null, addDefault);
        this.loadProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void generateProjectPropertiesFile(String name, File destfile, boolean overwrite, Properties properties, boolean merge, Set<String> removePrefixes, boolean addDefaultProps) {
        if (destfile.exists() && !overwrite) {
            return;
        }
        Properties newProps = new Properties();
        if (addDefaultProps) {
            if (null == properties || !properties.containsKey("resources.source.1.type")) {
                newProps.setProperty("resources.source.1.type", "local");
            }
            if (null == properties || !properties.containsKey("service.NodeExecutor.default.provider")) {
                newProps.setProperty("service.NodeExecutor.default.provider", "jsch-ssh");
            }
            if (null == properties || !properties.containsKey("service.FileCopier.default.provider")) {
                newProps.setProperty("service.FileCopier.default.provider", "jsch-scp");
            }
            if (null == properties || !properties.containsKey("project.ssh-keypath")) {
                newProps.setProperty("project.ssh-keypath", new File(System.getProperty("user.home"), ".ssh/id_rsa").getAbsolutePath());
            }
            if (null == properties || !properties.containsKey("project.ssh-authentication")) {
                newProps.setProperty("project.ssh-authentication", "privateKey");
            }
        }
        if (merge) {
            Properties orig = new Properties();
            if (destfile.exists()) {
                try (FileInputStream fileInputStream = new FileInputStream(destfile);){
                    orig.load(fileInputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Iterator<Map.Entry<Object, Object>> iterator = orig.entrySet().iterator();
            block10: while (iterator.hasNext()) {
                Map.Entry<Object, Object> o;
                Map.Entry<Object, Object> entry = o = iterator.next();
                String key = (String)entry.getKey();
                if (null != removePrefixes) {
                    for (String replacePrefix : removePrefixes) {
                        if (!key.startsWith(replacePrefix)) continue;
                        continue block10;
                    }
                }
                newProps.put(entry.getKey(), entry.getValue());
            }
        }
        if (null != properties) {
            newProps.putAll((Map<?, ?>)properties);
        }
        newProps.setProperty("project.name", name);
        try {
            if (!destfile.getParentFile().exists()) {
                destfile.getParentFile().mkdirs();
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(destfile);){
                newProps.store(fileOutputStream, "Project " + name + " configuration, generated");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.debug((Object)("generated project.properties: " + destfile.getAbsolutePath()));
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }

    private synchronized void checkReloadProperties() {
        if (this.needsPropertiesReload()) {
            this.loadProperties();
        }
    }

    private boolean needsPropertiesReload() {
        File fwkProjectPropertyFile = this.getFrameworkPropertyFile();
        long fwkPropsLastModified = fwkProjectPropertyFile.lastModified();
        if (this.propertyFile.exists()) {
            return this.propertyFile.lastModified() > this.propertiesLastReload || fwkPropsLastModified > this.propertiesLastReload;
        }
        return fwkPropsLastModified > this.propertiesLastReload;
    }

    private File getFrameworkPropertyFile() {
        return new File(this.filesystemFramework.getConfigDir(), PROP_FILENAME);
    }

    private static PropertyLookup createDirectProjectPropertyLookup(IFilesystemFramework filesystemFramework, String projectName) {
        Properties ownProps = new Properties();
        ownProps.setProperty("project.name", projectName);
        File projectsBaseDir = filesystemFramework.getFrameworkProjectsBaseDir();
        File propertyFile = FrameworkProjectConfig.getProjectPropertyFile(new File(projectsBaseDir, projectName));
        Properties projectProps = PropertyLookup.fetchProperties(propertyFile);
        PropertyLookup lookup = PropertyLookup.create(projectProps, (IPropertyLookup)PropertyLookup.create(ownProps));
        lookup.expand();
        return lookup;
    }

    private synchronized void loadProperties() {
        File fwkProjectPropertyFile = this.getFrameworkPropertyFile();
        this.loadProperties(fwkProjectPropertyFile);
    }

    private synchronized void loadProperties(File fwkProjectPropertyFile) {
        this.lookup = FrameworkProjectConfig.createProjectPropertyLookup(this.filesystemFramework, this.getName());
        this.projectLookup = FrameworkProjectConfig.createDirectProjectPropertyLookup(this.filesystemFramework, this.getName());
        if (this.propertyFile.exists()) {
            logger.debug((Object)("loading existing project.properties: " + this.propertyFile.getAbsolutePath()));
            long fwkPropsLastModified = fwkProjectPropertyFile.lastModified();
            long propsLastMod = this.propertyFile.lastModified();
            this.propertiesLastReload = propsLastMod > fwkPropsLastModified ? propsLastMod : fwkPropsLastModified;
        } else {
            logger.debug((Object)("loading instance-level project.properties: " + this.propertyFile.getAbsolutePath()));
            this.propertiesLastReload = fwkProjectPropertyFile.lastModified();
        }
    }

    @Override
    public Date getConfigLastModifiedTime() {
        return new Date(this.getPropertyFile().lastModified());
    }

    @Override
    public Date getConfigCreatedTime() {
        Path file = this.getPropertyFile().toPath();
        try {
            BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            return new Date(attr.creationTime().toMillis());
        }
        catch (IOException e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.lookup.getPropertiesMap();
    }

    @Override
    public Map<String, String> getProjectProperties() {
        return this.projectLookup.getPropertiesMap();
    }

    @Override
    public synchronized String getProperty(String name) {
        this.checkReloadProperties();
        return this.lookup.getProperty(name);
    }

    private static PropertyLookup createProjectPropertyLookup(IFilesystemFramework filesystemFramework, String projectName) {
        Properties ownProps = new Properties();
        ownProps.setProperty("project.name", projectName);
        File baseDir = filesystemFramework.getBaseDir();
        File projectsBaseDir = filesystemFramework.getFrameworkProjectsBaseDir();
        File fwkProjectPropertyFile = FilesystemFramework.getPropertyFile(filesystemFramework.getConfigDir());
        Properties nodeWideDepotProps = PropertyLookup.fetchProperties(fwkProjectPropertyFile);
        nodeWideDepotProps.putAll((Map<?, ?>)ownProps);
        File propertyFile = FrameworkProjectConfig.getProjectPropertyFile(new File(projectsBaseDir, projectName));
        PropertyLookup lookup = propertyFile.exists() ? PropertyLookup.create(propertyFile, nodeWideDepotProps, FilesystemFramework.createPropertyLookupFromBasedir(baseDir)) : PropertyLookup.create(fwkProjectPropertyFile, ownProps, FilesystemFramework.createPropertyLookupFromBasedir(baseDir));
        lookup.expand();
        return lookup;
    }

    private static File getProjectEtcDir(File baseDir) {
        return new File(baseDir, ETC_DIR_NAME);
    }

    private static File getProjectPropertyFile(File baseDir) {
        return new File(FrameworkProjectConfig.getProjectEtcDir(baseDir), PROP_FILENAME);
    }

    @Override
    public synchronized boolean hasProperty(String key) {
        this.checkReloadProperties();
        return this.lookup.hasProperty(key);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

