/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.plugins.BaseScriptPlugin;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.ServiceProviderLoader;
import com.dtolabs.rundeck.core.utils.MapData;
import com.dtolabs.rundeck.core.utils.ScriptExecUtil;
import com.dtolabs.rundeck.plugins.option.OptionValue;
import com.dtolabs.rundeck.plugins.option.OptionValuesPlugin;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ScriptOptionValues
extends BaseScriptPlugin
implements OptionValuesPlugin {
    private static final Logger LOG = Logger.getLogger(ScriptOptionValues.class);
    private static final String START_MARKER = "==START_OPTIONS==";
    private static final String END_MARKER = "==END_OPTIONS==";
    private final ServiceProviderLoader pluginManager;

    public ScriptOptionValues(ScriptPluginProvider provider, ServiceProviderLoader pluginManager) {
        super(provider);
        this.pluginManager = pluginManager;
    }

    @Override
    public boolean isAllowCustomProperties() {
        return true;
    }

    @Override
    public List<OptionValue> getOptionValues(Map config) {
        ArrayList<OptionValue> options;
        block18: {
            DataContext ctx = this.createScriptDataContext(DataContextUtils.context("config", MapData.toStringStringMap(config)).getData());
            ExecArgList scriptArgsList = this.createScriptArgsList(ctx);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errStream = new ByteArrayOutputStream();
            options = new ArrayList<OptionValue>();
            int result = -1;
            try {
                result = ScriptExecUtil.runLocalCommand(System.getProperty("os.name").toLowerCase(), scriptArgsList, ctx, null, outStream, errStream);
                if (result == 0) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(outStream.toByteArray())));){
                        boolean started = false;
                        boolean ended = false;
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if (line.startsWith("#")) continue;
                            if (line.equals(START_MARKER)) {
                                started = true;
                                continue;
                            }
                            if (line.equals(END_MARKER)) {
                                ended = true;
                                continue;
                            }
                            if (!started || ended) continue;
                            String[] kv = line.split(":");
                            options.add(new StringOptionValue(kv));
                        }
                        break block18;
                    }
                }
                LOG.error((Object)new String(errStream.toByteArray()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return options;
    }

    class StringOptionValue
    implements OptionValue {
        String name;
        String val;

        StringOptionValue(String[] nameval) {
            this.name = nameval[0];
            this.val = nameval[1];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.val;
        }
    }
}

