/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.data;

import com.dtolabs.rundeck.core.data.BaseVarExpander;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScriptVarExpander
extends BaseVarExpander {
    public static final String PROPERTY_SCRIPT_VAR_NODE_CHAR = "/";
    public static final String PROPERTY_VIEW_VAR_FINAL_CHAR = "@";
    public static final String PROPERTY_VIEW_VAR_GLOB_CHAR = "*";
    public static final String PROPERTY_SCRIPT_TEMPLATE_KEY_REGEX = "(?:(?<STEP>\\d+):)?(?<GROUP>[^\\s.]+)\\.(?<KEY>[^\\s/*]+)(?:/(?<QUAL>[^\\s]+)|(?<GLOB>" + Pattern.quote("*") + "[^\\s]*))?";
    public static final Pattern PROPERTY_SCRIPT_TEMPLATE_PATTERN = Pattern.compile("^" + PROPERTY_SCRIPT_TEMPLATE_KEY_REGEX + "$");

    @Override
    public BaseVarExpander.VariableRef parseVariable(String variableref) {
        Matcher m = PROPERTY_SCRIPT_TEMPLATE_PATTERN.matcher(variableref);
        if (!m.matches()) {
            return null;
        }
        String step = m.group("STEP");
        String group = m.group("GROUP");
        String key = m.group("KEY");
        String qual = m.group("QUAL");
        String glob = m.group("GLOB");
        String globstr = null;
        if (glob != null && glob.startsWith(PROPERTY_VIEW_VAR_GLOB_CHAR) && glob.length() > 1) {
            globstr = glob.substring(1);
        }
        return new BaseVarExpander.VariableRef(variableref, step, group, key, qual, glob != null, globstr);
    }
}

