/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.utils.Reformatter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class FormattedOutputStream
extends FilterOutputStream {
    Reformatter reformatter;
    StringBuffer buffer;
    private final OutputStream originalSink;
    private HashMap<String, String> context;

    public FormattedOutputStream(Reformatter reformatter, OutputStream sink) {
        super(sink);
        this.originalSink = sink;
        this.reformatter = reformatter;
        this.buffer = new StringBuffer();
        this.context = new HashMap();
    }

    private String formatMessage(String message) {
        if (null != this.reformatter) {
            return this.reformatter.reformat(this.context, message);
        }
        return message;
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 10) {
            this.writeBufferedData();
        } else {
            this.buffer.append((char)b);
        }
    }

    private void writeBufferedData() throws IOException {
        if (this.buffer.length() > 0) {
            this.out.write(this.formatMessage(this.buffer.toString()).getBytes());
            this.out.write(10);
            this.buffer = new StringBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        this.writeBufferedData();
        super.close();
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(String key, String value) {
        this.context.put(key, value);
    }

    public OutputStream getOriginalSink() {
        return this.originalSink;
    }
}

