/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.authorization.AclsUtil;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.AuthorizationUtil;
import com.dtolabs.rundeck.core.authorization.providers.Policies;
import com.dtolabs.rundeck.core.common.FilesystemFramework;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkProject;
import com.dtolabs.rundeck.core.common.FrameworkProjectConfig;
import com.dtolabs.rundeck.core.common.FrameworkProjectMgr;
import com.dtolabs.rundeck.core.common.FrameworkSupportService;
import com.dtolabs.rundeck.core.common.IFilesystemFramework;
import com.dtolabs.rundeck.core.common.IFrameworkNodes;
import com.dtolabs.rundeck.core.common.IFrameworkProjectMgr;
import com.dtolabs.rundeck.core.common.IFrameworkServices;
import com.dtolabs.rundeck.core.common.IProjectNodes;
import com.dtolabs.rundeck.core.common.IProjectNodesFactory;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfigModifier;
import com.dtolabs.rundeck.core.common.NodeSupport;
import com.dtolabs.rundeck.core.common.ProjectManager;
import com.dtolabs.rundeck.core.common.ProjectNodeSupport;
import com.dtolabs.rundeck.core.common.PropertyRetriever;
import com.dtolabs.rundeck.core.common.ServiceSupport;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceService;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorService;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import com.dtolabs.rundeck.core.utils.PropertyLookup;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;

public class FrameworkFactory {
    public static Framework createForFilesystem(String rdeck_base_dir) {
        File baseDir = new File(rdeck_base_dir);
        if (!baseDir.exists()) {
            throw new IllegalArgumentException("rdeck_base directory does not exist. " + rdeck_base_dir);
        }
        FilesystemFramework filesystemFramework = FrameworkFactory.createFilesystemFramework(baseDir);
        File propertyFile2 = FilesystemFramework.getPropertyFile(FilesystemFramework.getConfigDir(baseDir));
        PropertyLookup lookup1 = PropertyLookup.createDeferred(propertyFile2);
        lookup1.expand();
        FrameworkProjectMgr projectManager = FrameworkFactory.createProjectManager(filesystemFramework);
        Framework framework = FrameworkFactory.createFramework(lookup1, filesystemFramework, projectManager);
        IProjectNodesFactory nodesFactory = FrameworkFactory.createNodesFactory(filesystemFramework, framework::getResourceFormatGeneratorService, framework::getResourceModelSourceService);
        projectManager.setNodesFactory(nodesFactory);
        return framework;
    }

    public static IProjectNodesFactory createNodesFactory(final IFilesystemFramework filesystemFramework, final Supplier<ResourceFormatGeneratorService> formatGeneratorServiceSupplier, final Supplier<ResourceModelSourceService> resourceModelSourceServiceSupplier) {
        return new IProjectNodesFactory(){

            @Override
            public IProjectNodes getNodes(String name) {
                return new ProjectNodeSupport(FrameworkFactory.loadFrameworkProjectConfig(name, new File(filesystemFramework.getFrameworkProjectsBaseDir(), name), filesystemFramework, null), (ResourceFormatGeneratorService)formatGeneratorServiceSupplier.get(), (ResourceModelSourceService)resourceModelSourceServiceSupplier.get());
            }

            @Override
            public void refreshProjectNodes(String name) {
            }
        };
    }

    public static FilesystemFramework createFilesystemFramework(File baseDir) {
        File propertyFile = FilesystemFramework.getPropertyFile(FilesystemFramework.getConfigDir(baseDir));
        File projectsBase = FrameworkFactory.determineProjectsBasedir(baseDir, propertyFile);
        return new FilesystemFramework(baseDir, projectsBase);
    }

    private static File determineProjectsBasedir(File baseDir, File propertyFile) {
        File projectsBase;
        String projectsBaseDir = null;
        if (propertyFile.exists()) {
            PropertyRetriever propertyRetriever = FilesystemFramework.createPropertyRetriever(baseDir);
            projectsBaseDir = propertyRetriever.getProperty("framework.projects.dir");
        }
        if (null == projectsBaseDir) {
            projectsBaseDir = FilesystemFramework.getProjectsBaseDir(baseDir);
        }
        if (!(projectsBase = new File(projectsBaseDir)).exists() && !projectsBase.mkdirs()) {
            throw new IllegalArgumentException("project base directory could not be created. " + projectsBaseDir);
        }
        return projectsBase;
    }

    public static Framework createFramework(IPropertyLookup lookup1, FilesystemFramework filesystemFramework, ProjectManager projectManager, Map<String, FrameworkSupportService> services) {
        ServiceSupport serviceSupport = new ServiceSupport();
        NodeSupport iFrameworkNodes = new NodeSupport();
        iFrameworkNodes.setLookup(lookup1);
        Framework framework = new Framework((IFilesystemFramework)filesystemFramework, projectManager, lookup1, (IFrameworkServices)serviceSupport, (IFrameworkNodes)iFrameworkNodes);
        filesystemFramework.setFramework(framework);
        if (null != services) {
            for (String s : services.keySet()) {
                framework.setService(s, services.get(s));
            }
        }
        serviceSupport.initialize(framework);
        return framework;
    }

    private static Framework createFramework(PropertyLookup lookup1, FilesystemFramework filesystemFramework, IFrameworkProjectMgr projectManager) {
        ServiceSupport serviceSupport = new ServiceSupport();
        NodeSupport iFrameworkNodes = new NodeSupport();
        iFrameworkNodes.setLookup(lookup1);
        Framework framework = new Framework((IFilesystemFramework)filesystemFramework, projectManager, (IPropertyLookup)lookup1, (IFrameworkServices)serviceSupport, (IFrameworkNodes)iFrameworkNodes);
        filesystemFramework.setFramework(framework);
        serviceSupport.initialize(framework);
        return framework;
    }

    public static FrameworkProjectMgr createProjectManager(File baseDir, FilesystemFramework filesystemFramework, IProjectNodesFactory nodesFactory) {
        return new FrameworkProjectMgr("name", baseDir, filesystemFramework, nodesFactory);
    }

    public static FrameworkProjectMgr createProjectManager(FilesystemFramework filesystemFramework, IProjectNodesFactory nodesFactory) {
        return new FrameworkProjectMgr("name", filesystemFramework.getFrameworkProjectsBaseDir(), filesystemFramework, nodesFactory);
    }

    public static FrameworkProjectMgr createProjectManager(FilesystemFramework filesystemFramework) {
        return new FrameworkProjectMgr("name", filesystemFramework.getFrameworkProjectsBaseDir(), filesystemFramework);
    }

    public static FrameworkProject createFrameworkProject(String projectName, File baseDir, IFilesystemFramework filesystemFramework, IFrameworkProjectMgr mgr, IProjectNodesFactory nodesFactory, Properties properties) {
        FrameworkProjectConfig projectConfig = FrameworkFactory.loadFrameworkProjectConfig(projectName, baseDir, filesystemFramework, properties);
        FrameworkProject frameworkProject = new FrameworkProject(projectName, baseDir, filesystemFramework, mgr, projectConfig, new NodeResetConfigModifier(nodesFactory, projectConfig, projectName));
        frameworkProject.setProjectNodesFactory(nodesFactory);
        File aclPath = new File(baseDir, "acls");
        if (!aclPath.exists()) {
            aclPath.mkdirs();
        }
        frameworkProject.setProjectAuthorization((Authorization)AclsUtil.createAuthorization(Policies.load((File)aclPath, (Set)AuthorizationUtil.projectContext((String)projectName))));
        return frameworkProject;
    }

    public static FrameworkProjectConfig loadFrameworkProjectConfig(String projectName, File baseDir, IFilesystemFramework filesystemFramework, Properties properties) {
        return FrameworkProjectConfig.create(projectName, FrameworkProject.getProjectPropertyFile(baseDir), properties, filesystemFramework);
    }

    static class NodeResetConfigModifier
    implements IRundeckProjectConfigModifier {
        IProjectNodesFactory nodesFactory;
        IRundeckProjectConfigModifier modifier;
        String name;

        public NodeResetConfigModifier(IProjectNodesFactory nodesFactory, IRundeckProjectConfigModifier modifier, String name) {
            this.nodesFactory = nodesFactory;
            this.modifier = modifier;
            this.name = name;
        }

        @Override
        public void mergeProjectProperties(Properties properties, Set<String> removePrefixes) {
            this.modifier.mergeProjectProperties(properties, removePrefixes);
            this.nodesFactory.refreshProjectNodes(this.name);
        }

        @Override
        public void setProjectProperties(Properties properties) {
            this.modifier.setProjectProperties(properties);
            this.nodesFactory.refreshProjectNodes(this.name);
        }

        @Override
        public void generateProjectPropertiesFile(boolean overwrite, Properties properties, boolean addDefault) {
            this.modifier.generateProjectPropertiesFile(overwrite, properties, addDefault);
            this.nodesFactory.refreshProjectNodes(this.name);
        }
    }
}

