/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.ProviderService;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.MissingProviderException;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.plugins.CloseableProvider;
import com.dtolabs.rundeck.core.plugins.Closeables;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderRegistryService;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractProviderRegistryService<T>
implements ProviderRegistryService<T>,
ProviderService<T> {
    protected HashMap<String, Class<? extends T>> registry;
    protected HashMap<String, T> instanceregistry = new HashMap();
    private boolean cacheInstances = false;

    public AbstractProviderRegistryService() {
        this.registry = new HashMap();
    }

    public AbstractProviderRegistryService(boolean cacheInstances) {
        this();
        this.cacheInstances = cacheInstances;
    }

    public AbstractProviderRegistryService(Map<String, Class<? extends T>> classes) {
        this();
        this.instanceregistry = new HashMap();
        this.registry = new HashMap<String, Class<T>>(classes);
    }

    public AbstractProviderRegistryService(Map<String, Class<? extends T>> registry, boolean cacheInstances) {
        this();
        this.instanceregistry = new HashMap();
        this.registry = new HashMap<String, Class<T>>(registry);
        this.cacheInstances = cacheInstances;
    }

    @Override
    public void registerClass(String name, Class<? extends T> clazz) {
        this.registry.put(name, clazz);
    }

    @Override
    public void registerInstance(String name, T object) {
        this.instanceregistry.put(name, object);
    }

    @Override
    public T providerOfType(String providerName) throws ExecutionServiceException {
        if (null == providerName) {
            throw new NullPointerException("provider name was null for Service: " + this.getName());
        }
        if (this.isCacheInstances()) {
            if (null == this.instanceregistry.get(providerName)) {
                T instance = this.createProviderInstanceOfType(providerName);
                this.instanceregistry.put(providerName, instance);
                return instance;
            }
            return this.instanceregistry.get(providerName);
        }
        return this.createProviderInstanceOfType(providerName);
    }

    @Override
    public CloseableProvider<T> closeableProviderOfType(String providerName) throws ExecutionServiceException {
        T t = this.providerOfType(providerName);
        if (t == null) {
            return null;
        }
        return Closeables.closeableProvider(t);
    }

    private T createProviderInstanceOfType(String providerName) throws ExecutionServiceException {
        if (null == this.registry.get(providerName)) {
            throw new MissingProviderException("Not found", this.getName(), providerName);
        }
        Class<? extends T> execClass = this.registry.get(providerName);
        return this.createProviderInstanceFromType(execClass, providerName);
    }

    @Override
    public List<ProviderIdent> listProviders() {
        HashSet<ProviderIdent> providers = new HashSet<ProviderIdent>();
        for (String s : this.registry.keySet()) {
            providers.add(new ProviderIdent(this.getName(), s));
        }
        for (String s : this.instanceregistry.keySet()) {
            providers.add(new ProviderIdent(this.getName(), s));
        }
        return new ArrayList<ProviderIdent>(providers);
    }

    protected T createProviderInstanceFromType(Class<? extends T> execClass, String providerName) throws ProviderCreationException {
        try {
            Constructor<T> method = execClass.getDeclaredConstructor(new Class[0]);
            return method.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ProviderCreationException("No constructor found with signature (): " + e.getMessage(), e, this.getName(), providerName);
        }
        catch (Exception e) {
            throw new ProviderCreationException("Unable to create provider instance: " + e.getMessage(), e, this.getName(), providerName);
        }
    }

    protected boolean hasValidProviderSignature(Class<?> clazz) {
        try {
            Constructor<?> method = clazz.getDeclaredConstructor(new Class[0]);
            return null != method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    @Override
    public boolean isCacheInstances() {
        return this.cacheInstances;
    }

    @Override
    public void setCacheInstances(boolean cacheInstances) {
        this.cacheInstances = cacheInstances;
    }
}

