/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.acl;

import com.dtolabs.rundeck.core.authorization.providers.BaseValidator;
import com.dtolabs.rundeck.core.authorization.providers.YamlProvider;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.rundeck.app.acl.ACLFileManager;
import org.rundeck.app.acl.AclPolicyFile;

public class ACLFSFileManager
implements ACLFileManager {
    final File directory;
    final BaseValidator validator;

    @Override
    public long storePolicyFile(String fileName, InputStream input) throws IOException {
        File file = this.fileForName(fileName);
        try (FileOutputStream out = new FileOutputStream(file);){
            long l = Streams.copyStream(input, out);
            return l;
        }
    }

    private File fileForName(String fileName) {
        if (fileName.contains("/")) {
            throw new IllegalArgumentException("invalid aclpolicy filename: " + fileName);
        }
        if (!fileName.endsWith(".aclpolicy")) {
            throw new IllegalArgumentException("invalid aclpolicy filename: " + fileName);
        }
        if (fileName.charAt(0) == '.') {
            throw new IllegalArgumentException("invalid aclpolicy filename: " + fileName);
        }
        File file = new File(this.directory, fileName);
        if (!file.toPath().normalize().startsWith(this.directory.toPath().normalize())) {
            throw new IllegalArgumentException(String.format("Path is outside of destination directory: %s", file));
        }
        this.requireDirectory();
        return file;
    }

    @Override
    public boolean deletePolicyFile(String fileName) throws IOException {
        return Files.deleteIfExists(this.fileForName(fileName).toPath());
    }

    @Override
    public long storePolicyFileContents(String fileName, String fileText) throws IOException {
        File file = this.fileForName(fileName);
        try (FileOutputStream out = new FileOutputStream(file);){
            byte[] bytes = fileText.getBytes(StandardCharsets.UTF_8);
            out.write(bytes);
            long l = bytes.length;
            return l;
        }
    }

    @Override
    public AclPolicyFile getAclPolicy(String fileName) {
        return new AclPolicyImpl(this.fileForName(fileName));
    }

    @Override
    public String getPolicyFileContents(String fileName) throws IOException {
        File file = this.fileForName(fileName);
        try (InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            String string = this.readString(is);
            return string;
        }
    }

    private String readString(Reader is) throws IOException {
        StringWriter sw = new StringWriter();
        Streams.copyWriterCount(is, sw);
        return sw.toString();
    }

    @Override
    public long loadPolicyFileContents(String fileName, OutputStream outputStream) throws IOException {
        File file = this.fileForName(fileName);
        try (FileInputStream fis = new FileInputStream(file);){
            long l = Streams.copyStream(fis, outputStream);
            return l;
        }
    }

    @Override
    public boolean existsPolicyFile(String file) {
        return this.fileForName(file).exists();
    }

    @Override
    public List<String> listStoredPolicyFiles() {
        this.requireDirectory();
        return Arrays.asList((Object[])Objects.requireNonNull(this.directory.list(YamlProvider.filenameFilter)));
    }

    private void requireDirectory() {
        if (!this.directory.mkdirs() && !this.directory.isDirectory()) {
            throw new IllegalStateException("Unable to create necessary directory: " + this.directory.getAbsolutePath());
        }
    }

    public static ACLFSFileManagerBuilder builder() {
        return new ACLFSFileManagerBuilder();
    }

    public ACLFSFileManager(File directory, BaseValidator validator) {
        this.directory = directory;
        this.validator = validator;
    }

    @Override
    public BaseValidator getValidator() {
        return this.validator;
    }

    public static class ACLFSFileManagerBuilder {
        private File directory;
        private BaseValidator validator;

        ACLFSFileManagerBuilder() {
        }

        public ACLFSFileManagerBuilder directory(File directory) {
            this.directory = directory;
            return this;
        }

        public ACLFSFileManagerBuilder validator(BaseValidator validator) {
            this.validator = validator;
            return this;
        }

        public ACLFSFileManager build() {
            return new ACLFSFileManager(this.directory, this.validator);
        }

        public String toString() {
            return "ACLFSFileManager.ACLFSFileManagerBuilder(directory=" + this.directory + ", validator=" + this.validator + ")";
        }
    }

    static class AclPolicyImpl
    implements AclPolicyFile {
        private final File file;

        @Override
        public InputStream getInputStream() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        @Override
        public Date getModified() {
            return new Date(this.file.lastModified());
        }

        @Override
        public Date getCreated() {
            return new Date(this.file.lastModified());
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        public AclPolicyImpl(File file) {
            this.file = file;
        }
    }
}

