/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.FrameworkSupportService;
import com.dtolabs.rundeck.core.execution.script.ScriptfileUtils;
import com.dtolabs.rundeck.core.execution.service.ProviderLoaderException;
import com.dtolabs.rundeck.core.plugins.CloseableProvider;
import com.dtolabs.rundeck.core.plugins.Closeables;
import com.dtolabs.rundeck.core.plugins.PluggableService;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.PluginMetadata;
import com.dtolabs.rundeck.core.plugins.PluginMetadataValidator;
import com.dtolabs.rundeck.core.plugins.PluginResourceLoader;
import com.dtolabs.rundeck.core.plugins.PluginUtils;
import com.dtolabs.rundeck.core.plugins.PluginValidation;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProviderImpl;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProviderLoadable;
import com.dtolabs.rundeck.core.plugins.VersionCompare;
import com.dtolabs.rundeck.core.plugins.ZipResourceLoader;
import com.dtolabs.rundeck.core.plugins.metadata.PluginMeta;
import com.dtolabs.rundeck.core.plugins.metadata.ProviderDef;
import com.dtolabs.rundeck.core.utils.FileUtils;
import com.dtolabs.rundeck.core.utils.ZipUtil;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class ScriptPluginProviderLoader
implements ProviderLoader,
FileCache.Expireable,
PluginResourceLoader,
PluginMetadata {
    private static final Logger log = LoggerFactory.getLogger((String)ScriptPluginProviderLoader.class.getName());
    public static final String VERSION_1_0 = "1.0";
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    public static final VersionCompare SUPPORTS_RESOURCES_PLUGIN_VERSION = VersionCompare.forString("1.2");
    public static final String VERSION_2_0 = "2.0";
    public static final List<String> SUPPORTED_PLUGIN_VERSIONS = Collections.unmodifiableList(Arrays.asList("1.0", "1.1", "1.2", "2.0"));
    private final File file;
    final File cachedir;
    private File fileExpandedDir;
    private PluginMeta metadata;
    private PluginResourceLoader resourceLoader;
    private Map<ProviderIdent, ScriptPluginProvider> pluginProviderDefs = new HashMap<ProviderIdent, ScriptPluginProvider>();
    private List<String> pluginResourcesList;
    private Date dateLoaded = null;

    public ScriptPluginProviderLoader(File file, File cachedir) {
        this.file = file;
        this.cachedir = cachedir;
    }

    @Override
    public boolean canLoadForService(FrameworkSupportService service) {
        return service instanceof ScriptPluginProviderLoadable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginResourceLoader getResourceLoader() throws PluginException {
        if (null == this.resourceLoader) {
            ScriptPluginProviderLoader scriptPluginProviderLoader = this;
            synchronized (scriptPluginProviderLoader) {
                if (null == this.resourceLoader) {
                    try {
                        ZipResourceLoader loader = new ZipResourceLoader(new File(this.getFileCacheDir(), "resources"), this.file, this.getPluginResourcesList(), this.getFileBasename() + "/" + this.getResourcesBasePath());
                        loader.extractResources();
                        this.resourceLoader = loader;
                    }
                    catch (IOException e) {
                        throw new PluginException("Unable to expand plugin libs: " + e.getMessage(), e);
                    }
                }
            }
        }
        return this.resourceLoader;
    }

    @Override
    public List<String> listResources() throws PluginException, IOException {
        if (ScriptPluginProviderLoader.supportsResources(this.getPluginMeta())) {
            return this.getResourceLoader().listResources();
        }
        return null;
    }

    @Override
    public InputStream openResourceStreamFor(String name) throws PluginException, IOException {
        if (ScriptPluginProviderLoader.supportsResources(this.getPluginMeta())) {
            return this.getResourceLoader().openResourceStreamFor(name);
        }
        return null;
    }

    @Override
    public synchronized <T> T load(PluggableService<T> service, String providerName) throws ProviderLoaderException {
        if (!(service instanceof ScriptPluginProviderLoadable)) {
            return null;
        }
        ScriptPluginProviderLoadable loader = (ScriptPluginProviderLoadable)((Object)service);
        ProviderIdent ident = new ProviderIdent(service.getName(), providerName);
        if (null == this.pluginProviderDefs.get(ident)) {
            PluginMeta pluginMeta;
            try {
                pluginMeta = this.getPluginMeta();
            }
            catch (IOException e) {
                throw new ProviderLoaderException(e, service.getName(), providerName);
            }
            if (null == pluginMeta) {
                throw new ProviderLoaderException("Unable to load plugin metadata for file: " + this.file, service.getName(), providerName);
            }
            for (ProviderDef pluginDef : pluginMeta.getPluginDefs()) {
                ScriptPluginProvider provider;
                if (!this.matchesProvider(ident, pluginDef)) continue;
                try {
                    provider = this.getPlugin(pluginMeta, this.file, pluginDef, ident);
                }
                catch (PluginException e) {
                    throw new ProviderLoaderException(e, service.getName(), providerName);
                }
                this.pluginProviderDefs.put(ident, provider);
                break;
            }
        }
        ScriptPluginProvider scriptPluginProvider = this.pluginProviderDefs.get(ident);
        try {
            this.getResourceLoader().listResources();
        }
        catch (IOException iex) {
            throw new ProviderLoaderException(iex, service.getName(), providerName);
        }
        catch (PluginException e) {
            throw new ProviderLoaderException(e, service.getName(), providerName);
        }
        if (null != scriptPluginProvider) {
            try {
                return loader.createScriptProviderInstance(scriptPluginProvider);
            }
            catch (PluginException e) {
                throw new ProviderLoaderException(e, service.getName(), providerName);
            }
        }
        return null;
    }

    @Override
    public <T> CloseableProvider<T> loadCloseable(PluggableService<T> service, String providerName) throws ProviderLoaderException {
        T load = this.load(service, providerName);
        if (null == load) {
            return null;
        }
        return Closeables.closeableProvider(load);
    }

    private PluginMeta getPluginMeta() throws IOException {
        if (null != this.metadata) {
            return this.metadata;
        }
        this.metadata = ScriptPluginProviderLoader.loadMeta(this.file);
        this.metadata.setId(PluginUtils.generateShaIdFromName(this.metadata.getName()));
        this.dateLoaded = new Date();
        return this.metadata;
    }

    private ScriptPluginProvider getPlugin(PluginMeta pluginMeta, File file, ProviderDef pluginDef, ProviderIdent ident) throws ProviderLoaderException, PluginException {
        File script;
        if (null == this.fileExpandedDir) {
            File dir;
            try {
                dir = this.expandScriptPlugin(file);
            }
            catch (IOException e) {
                throw new ProviderLoaderException(e, ident.getService(), ident.getProviderName());
            }
            this.fileExpandedDir = dir;
            if (pluginDef.getPluginType().equals("script")) {
                File script2 = new File(this.fileExpandedDir, pluginDef.getScriptFile());
                try {
                    ScriptfileUtils.setExecutePermissions(script2);
                }
                catch (IOException e) {
                    log.warn("Unable to set executable bit for script file: " + script2 + ": " + e.getMessage());
                }
            }
            ScriptPluginProviderLoader.debug("expanded plugin dir! " + this.fileExpandedDir);
        } else {
            ScriptPluginProviderLoader.debug("expanded plugin dir: " + this.fileExpandedDir);
        }
        if (!(!pluginDef.getPluginType().equals("script") || (script = new File(this.fileExpandedDir, pluginDef.getScriptFile())).exists() && script.isFile())) {
            throw new PluginException("Script file was not found: " + script.getAbsolutePath());
        }
        return new ScriptPluginProviderImpl(pluginMeta, pluginDef, file, this.fileExpandedDir);
    }

    private boolean matchesProvider(ProviderIdent ident, ProviderDef pluginDef) {
        return ident.getService().equals(pluginDef.getService()) && ident.getProviderName().equals(pluginDef.getName());
    }

    @Override
    public synchronized boolean isLoaderFor(ProviderIdent ident) {
        PluginMeta pluginMeta;
        try {
            pluginMeta = this.getPluginMeta();
        }
        catch (IOException e) {
            log.warn("Unable to load file meta: " + e.getMessage());
            return false;
        }
        if (null == pluginMeta) {
            return false;
        }
        for (ProviderDef pluginDef : pluginMeta.getPluginDefs()) {
            if (!this.matchesProvider(ident, pluginDef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ProviderIdent> listProviders() {
        ArrayList<ProviderIdent> providerIdents = new ArrayList<ProviderIdent>();
        PluginMeta pluginMeta = null;
        try {
            pluginMeta = this.getPluginMeta();
        }
        catch (IOException e) {
            ScriptPluginProviderLoader.debug("Unable to load file meta: " + e.getMessage());
        }
        if (null == pluginMeta) {
            return providerIdents;
        }
        for (ProviderDef pluginDef : pluginMeta.getPluginDefs()) {
            providerIdents.add(new ProviderIdent(pluginDef.getService(), pluginDef.getName()));
        }
        return providerIdents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PluginMeta loadMeta(File jar) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(jar);){
            PluginMeta metadata;
            ZipInputStream zipinput = new ZipInputStream(fileInputStream);
            PluginMeta pluginMeta = metadata = ScriptPluginProviderLoader.loadMeta(jar, zipinput);
            return pluginMeta;
        }
    }

    static PluginMeta loadMeta(File jar, ZipInputStream zipinput) throws IOException {
        String basename = ScriptPluginProviderLoader.basename(jar);
        PluginMeta metadata = null;
        boolean topfound = false;
        boolean found = false;
        boolean dirfound = false;
        boolean resfound = false;
        ZipEntry nextEntry = zipinput.getNextEntry();
        HashSet<String> paths = new HashSet<String>();
        while (null != nextEntry) {
            paths.add(nextEntry.getName());
            if (!found && !nextEntry.isDirectory() && nextEntry.getName().equals(basename + "/plugin.yaml")) {
                try {
                    metadata = ScriptPluginProviderLoader.loadMetadataYaml(zipinput);
                    found = true;
                }
                catch (Throwable e) {
                    log.error("Error parsing metadata file plugin.yaml: " + e.getMessage(), e);
                }
            }
            nextEntry = zipinput.getNextEntry();
        }
        if (!found || metadata == null) {
            log.error("Plugin not loaded: Found no " + basename + "/plugin.yaml within: " + jar.getAbsolutePath());
        }
        String resdir = null != metadata ? ScriptPluginProviderLoader.getResourcesBasePath(metadata) : null;
        for (String path : paths) {
            if (!topfound && path.startsWith(basename + "/")) {
                topfound = true;
            }
            if (!dirfound && (path.startsWith(basename + "/contents/") || path.equals(basename + "/contents"))) {
                dirfound = true;
            }
            if (resfound || resdir == null || !path.startsWith(basename + "/" + resdir + "/") && !path.equals(basename + "/" + resdir)) continue;
            resfound = true;
        }
        if (!topfound) {
            log.error("Plugin not loaded: Found no " + basename + "/ dir within file: " + jar.getAbsolutePath());
        }
        if (!dirfound && !resfound) {
            log.error("Plugin not loaded: Found no " + basename + "/contents or " + basename + "/" + resdir + " dir within: " + jar.getAbsolutePath());
        }
        if (found && (dirfound || resfound)) {
            return metadata;
        }
        return null;
    }

    static PluginMeta loadMetadataYaml(InputStream stream) {
        Yaml yaml = new Yaml();
        return (PluginMeta)yaml.loadAs(stream, PluginMeta.class);
    }

    static PluginValidation validatePluginMeta(PluginMeta pluginList, File file) {
        PluginValidation.State state = PluginValidation.State.VALID;
        if (pluginList == null) {
            return PluginValidation.builder().message("No metadata").state(PluginValidation.State.INVALID).build();
        }
        ArrayList<String> messages = new ArrayList<String>();
        if (null == pluginList.getName()) {
            messages.add("'name' not found in metadata");
            state = PluginValidation.State.INVALID;
        }
        if (null == pluginList.getVersion()) {
            messages.add("'version' not found in metadata");
            state = PluginValidation.State.INVALID;
        }
        if (null == pluginList.getRundeckPluginVersion()) {
            messages.add("'rundeckPluginVersion' not found in metadata");
            state = PluginValidation.State.INVALID;
        } else if (!SUPPORTED_PLUGIN_VERSIONS.contains(pluginList.getRundeckPluginVersion())) {
            messages.add("'rundeckPluginVersion': \"" + pluginList.getRundeckPluginVersion() + "\" is not supported");
            state = PluginValidation.State.INVALID;
        }
        if (pluginList.getRundeckPluginVersion().equals(VERSION_2_0)) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            PluginValidation.State hostCompatState = PluginMetadataValidator.validateTargetHostCompatibility(validationErrors, pluginList.getTargetHostCompatibility());
            PluginValidation.State versCompatState = PluginMetadataValidator.validateRundeckCompatibility(validationErrors, pluginList.getRundeckCompatibilityVersion());
            messages.addAll(validationErrors);
            state = state.or(hostCompatState).or(versCompatState);
        }
        List<ProviderDef> pluginDefs = pluginList.getPluginDefs();
        for (ProviderDef pluginDef : pluginDefs) {
            try {
                ScriptPluginProviderLoader.validateProviderDef(pluginDef);
            }
            catch (PluginException e) {
                messages.add(e.getMessage());
                state = PluginValidation.State.INVALID;
            }
        }
        return PluginValidation.builder().state(state).messages(messages).build();
    }

    private File expandScriptPlugin(File file) throws IOException {
        File jardir;
        if (!this.cachedir.exists() && !this.cachedir.mkdirs()) {
            log.warn("Unable to create cache dir: " + this.cachedir.getAbsolutePath());
        }
        if (!(jardir = this.getFileCacheDir()).exists() && !jardir.mkdir()) {
            log.warn("Unable to create cache dir for plugin: " + jardir.getAbsolutePath());
        }
        String prefix = this.getFileBasename() + "/contents";
        ScriptPluginProviderLoader.debug("Expand zip " + file.getAbsolutePath() + " to dir: " + jardir + ", prefix: " + prefix);
        ZipUtil.extractZip(file.getAbsolutePath(), jardir, prefix, prefix + "/");
        return jardir;
    }

    private synchronized boolean removeScriptPluginCache() {
        if (null != this.fileExpandedDir && this.fileExpandedDir.exists()) {
            ScriptPluginProviderLoader.debug("removeScriptPluginCache: " + this.fileExpandedDir);
            return FileUtils.deleteDir(this.fileExpandedDir);
        }
        return true;
    }

    String getFileBasename() {
        return ScriptPluginProviderLoader.basename(this.file);
    }

    private static String basename(File file) {
        String name = file.getName();
        if (name.contains(".")) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    File getFileCacheDir() {
        return new File(this.cachedir, this.getFileBasename());
    }

    private static void validateProviderDef(ProviderDef pluginDef) throws PluginException {
        if (null == pluginDef.getPluginType() || "".equals(pluginDef.getPluginType())) {
            throw new PluginException("Script plugin missing plugin-type");
        }
        if ("script".equals(pluginDef.getPluginType())) {
            ScriptPluginProviderLoader.validateScriptProviderDef(pluginDef);
        } else if ("ui".equals(pluginDef.getPluginType())) {
            ScriptPluginProviderLoader.validateUIProviderDef(pluginDef);
        } else {
            throw new PluginException("Script plugin has invalid plugin-type: " + pluginDef.getPluginType());
        }
    }

    private static void validateScriptProviderDef(ProviderDef pluginDef) throws PluginException {
        if (null == pluginDef.getName() || "".equals(pluginDef.getName())) {
            throw new PluginException("Script plugin missing name");
        }
        if (null == pluginDef.getService() || "".equals(pluginDef.getService())) {
            throw new PluginException("Script plugin missing service");
        }
        if (null == pluginDef.getScriptFile() || "".equals(pluginDef.getScriptFile())) {
            throw new PluginException("Script plugin missing script-file");
        }
    }

    private static void validateUIProviderDef(ProviderDef pluginDef) throws PluginException {
        if (null == pluginDef.getName() || "".equals(pluginDef.getName())) {
            throw new PluginException("UI plugin missing name");
        }
        if (null == pluginDef.getService() || "".equals(pluginDef.getService())) {
            throw new PluginException("UI plugin missing service");
        }
        if (null == pluginDef.getPluginData() || null == pluginDef.getPluginData().get("ui")) {
            throw new PluginException("UI plugin missing ui: definition");
        }
    }

    private static void debug(String msg) {
        if (log.isDebugEnabled()) {
            log.debug(msg);
        }
    }

    @Override
    public void expire() {
        this.removeScriptPluginCache();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptPluginProviderLoader that = (ScriptPluginProviderLoader)o;
        if (this.cachedir != null ? !this.cachedir.equals(that.cachedir) : that.cachedir != null) {
            return false;
        }
        return !(this.file != null ? !this.file.equals(that.file) : that.file != null);
    }

    public int hashCode() {
        int result = this.file != null ? this.file.hashCode() : 0;
        result = 31 * result + (this.cachedir != null ? this.cachedir.hashCode() : 0);
        return result;
    }

    static String getVersionForFile(File file) {
        try {
            PluginMeta pluginMeta = ScriptPluginProviderLoader.loadMeta(file);
            return pluginMeta.getVersion();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean getDefaultMergeEnvVars(PluginMeta pluginMeta) {
        return !VERSION_1_0.equals(pluginMeta.getRundeckPluginVersion());
    }

    public static boolean supportsResources(PluginMeta pluginMeta) {
        return VersionCompare.forString(pluginMeta.getRundeckPluginVersion()).atLeast(SUPPORTS_RESOURCES_PLUGIN_VERSION);
    }

    public List<String> getPluginResourcesList() throws IOException {
        return this.getPluginMeta().getResourcesList();
    }

    public String getResourcesBasePath() throws IOException {
        return ScriptPluginProviderLoader.getResourcesBasePath(this.getPluginMeta());
    }

    public static String getResourcesBasePath(PluginMeta metadata) throws IOException {
        String resourcesDir = metadata.getResourcesDir();
        return null != resourcesDir ? resourcesDir : "resources";
    }

    @Override
    public String getFilename() {
        return this.file.getName();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getPluginArtifactName() {
        try {
            return this.getPluginMeta().getName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getPluginAuthor() {
        try {
            return this.getPluginMeta().getAuthor();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getPluginFileVersion() {
        try {
            return this.getPluginMeta().getVersion();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getPluginVersion() {
        try {
            return this.getPluginMeta().getRundeckPluginVersion();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getPluginUrl() {
        try {
            return this.getPluginMeta().getUrl();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Date getPluginDate() {
        try {
            String date = this.getPluginMeta().getDate();
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX").parse(date);
        }
        catch (IOException | NullPointerException | ParseException exception) {
            return null;
        }
    }

    @Override
    public Date getDateLoaded() {
        return this.dateLoaded;
    }

    @Override
    public String getPluginName() {
        try {
            return this.getPluginMeta().getName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getPluginDescription() {
        try {
            return this.getPluginMeta().getDescription();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getPluginId() {
        try {
            return this.getPluginMeta().getId();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getRundeckCompatibilityVersion() {
        try {
            return this.getPluginMeta().getRundeckCompatibilityVersion();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getTargetHostCompatibility() {
        try {
            return this.getPluginMeta().getTargetHostCompatibility();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public List<String> getTags() {
        try {
            return this.getPluginMeta().getTags();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getPluginLicense() {
        try {
            return this.getPluginMeta().getLicense();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getPluginThirdPartyDependencies() {
        try {
            return this.getPluginMeta().getThirdPartyDependencies();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getPluginSourceLink() {
        try {
            return this.getPluginMeta().getSourceLink();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getPluginDocsLink() {
        try {
            return this.getPluginMeta().getDocsLink();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getPluginType() {
        return "script";
    }
}

