/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.dispatcher;

import com.dtolabs.rundeck.core.data.ViewTraverse;

public final class ContextView
implements ViewTraverse<ContextView>,
Comparable<ContextView> {
    private final boolean global;
    private final Integer stepNumber;
    private final String nodeName;

    public ContextView(Integer step, String nodeName) {
        this.global = step == null && nodeName == null;
        this.stepNumber = step;
        this.nodeName = nodeName;
    }

    public static ContextView global() {
        return new ContextView(null, null);
    }

    public static ContextView step(Integer step) {
        return new ContextView(step, null);
    }

    public static ContextView nodeStep(Integer step, String nodeName) {
        return new ContextView(step, nodeName);
    }

    public static ContextView node(String nodeName) {
        return new ContextView(null, nodeName);
    }

    @Override
    public boolean isWidest() {
        return this.isGlobal();
    }

    public boolean isNodeStep() {
        return null != this.getNodeName() && null != this.getStepNumber();
    }

    public boolean isNodeOnly() {
        return null != this.getNodeName() && null == this.getStepNumber();
    }

    public boolean isStepOnly() {
        return null != this.getStepNumber() && null == this.getNodeName();
    }

    @Override
    public boolean globExpandTo(ContextView x) {
        return null == this.getStepNumber() && x.isNodeOnly() || x.isNodeStep() && x.getStepNumber().equals(this.getStepNumber());
    }

    @Override
    public ViewTraverse<ContextView> merge(ContextView source) {
        if (source.isWidest()) {
            return this;
        }
        if (null == this.getNodeName() && null != source.getNodeName()) {
            if (null != this.getStepNumber()) {
                return ContextView.nodeStep(this.getStepNumber(), source.getNodeName());
            }
            if (null != source.getStepNumber()) {
                return ContextView.nodeStep(source.getStepNumber(), source.getNodeName());
            }
            return ContextView.node(source.getNodeName());
        }
        return this;
    }

    @Override
    public boolean isWider(ContextView source) {
        if (source.isGlobal()) {
            return !this.isGlobal();
        }
        return this.isNodeStep() && !source.isNodeStep() || this.isStepOnly() && null == source.getStepNumber() || this.isNodeOnly() && source.isGlobal();
    }

    public ContextView widenView() {
        if (this.isGlobal()) {
            return this;
        }
        if (null != this.getNodeName() && null != this.getStepNumber()) {
            return ContextView.step(this.getStepNumber());
        }
        return ContextView.global();
    }

    @Override
    public ContextView getView() {
        return this;
    }

    @Override
    public int compareTo(ContextView o) {
        if (this.isGlobal()) {
            return o.isGlobal() ? 0 : -1;
        }
        if (o.isGlobal()) {
            return 1;
        }
        if (null != this.getStepNumber()) {
            if (null != o.getStepNumber()) {
                int compstep = this.getStepNumber().compareTo(o.getStepNumber());
                if (compstep != 0) {
                    return compstep;
                }
            } else {
                return -1;
            }
            return this.compareNodeName(o);
        }
        if (null != o.getStepNumber()) {
            return 1;
        }
        return this.compareNodeName(o);
    }

    public int compareNodeName(ContextView o) {
        if (null != this.getNodeName()) {
            if (null != o.getNodeName()) {
                return this.getNodeName().compareTo(o.getNodeName());
            }
            return 1;
        }
        if (null != o.getNodeName()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        Integer step = this.getStepNumber();
        return "ContextView(" + (this.isGlobal() ? "global" : (null != step ? "step:" + step : "") + (null != this.getNodeName() ? (null != step ? ", " : "") + "node:" + this.getNodeName() : "")) + ")";
    }

    public boolean isGlobal() {
        return this.global;
    }

    public Integer getStepNumber() {
        return this.stepNumber;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextView)) {
            return false;
        }
        ContextView other = (ContextView)o;
        if (this.isGlobal() != other.isGlobal()) {
            return false;
        }
        Integer this$stepNumber = this.getStepNumber();
        Integer other$stepNumber = other.getStepNumber();
        if (this$stepNumber == null ? other$stepNumber != null : !((Object)this$stepNumber).equals(other$stepNumber)) {
            return false;
        }
        String this$nodeName = this.getNodeName();
        String other$nodeName = other.getNodeName();
        return !(this$nodeName == null ? other$nodeName != null : !this$nodeName.equals(other$nodeName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGlobal() ? 79 : 97);
        Integer $stepNumber = this.getStepNumber();
        result = result * 59 + ($stepNumber == null ? 43 : ((Object)$stepNumber).hashCode());
        String $nodeName = this.getNodeName();
        result = result * 59 + ($nodeName == null ? 43 : $nodeName.hashCode());
        return result;
    }
}

