/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.plugins.DirPluginScanner;
import com.dtolabs.rundeck.core.plugins.PluginValidation;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProviderLoader;
import com.dtolabs.rundeck.core.plugins.metadata.PluginMeta;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptPluginScanner
extends DirPluginScanner {
    private static final Logger log = LoggerFactory.getLogger((String)ScriptPluginScanner.class.getName());
    public static final FileFilter FILENAME_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".zip");
        }
    };
    final File cachedir;

    public ScriptPluginScanner(File extdir, File cachedir, FileCache<ProviderLoader> filecache) {
        super(extdir, filecache);
        this.cachedir = cachedir;
    }

    @Override
    public ProviderLoader createLoader(File file) {
        if (log.isDebugEnabled()) {
            log.debug("create ScriptFileProviderLoader: " + file);
        }
        return new ScriptPluginProviderLoader(file, this.cachedir);
    }

    @Override
    public ProviderLoader createCacheItemForFile(File file) {
        return this.createLoader(file);
    }

    @Override
    public FileFilter getFileFilter() {
        return FILENAME_FILTER;
    }

    @Override
    public boolean isValidPluginFile(File file) {
        return ScriptPluginScanner.validatePluginFile(file);
    }

    public static boolean validatePluginFile(File file) {
        try {
            ZipInputStream zipinput = new ZipInputStream(new FileInputStream(file));
            PluginMeta metadata = ScriptPluginProviderLoader.loadMeta(file, zipinput);
            zipinput.close();
            PluginValidation validation = ScriptPluginProviderLoader.validatePluginMeta(metadata, file);
            if (validation.getState() == PluginValidation.State.INVALID) {
                log.error(String.format("Skipping plugin file: metadata was invalid: %s: %s", file.getAbsolutePath(), validation.getMessages()));
            } else if (validation.getState() == PluginValidation.State.INCOMPATIBLE) {
                log.info(String.format("Skipping plugin file: plugin is incompatible: %s: %s", file.getAbsolutePath(), validation.getMessages()));
            }
            return validation.getState().isValid();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected String getVersionForFile(File file) {
        return ScriptPluginProviderLoader.getVersionForFile(file);
    }
}

