/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.PluginControlService;
import com.dtolabs.rundeck.core.common.PluginDisabledException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PluginControlServiceImpl
implements PluginControlService {
    public static final String DISABLED_PLUGINS = "disabled.plugins";
    private HashSet<String> disabledPlugins;
    private final IFramework framework;
    private final String project;

    private PluginControlServiceImpl(IFramework framework, String project) {
        this.framework = framework;
        this.project = project;
    }

    public static PluginControlService forProject(IFramework framework, String project) {
        return new PluginControlServiceImpl(framework, project);
    }

    @Override
    public List<String> listDisabledPlugins() {
        return new ArrayList<String>(this.getDisabledPlugins());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getDisabledPlugins() {
        if (null == this.disabledPlugins) {
            PluginControlServiceImpl pluginControlServiceImpl = this;
            synchronized (pluginControlServiceImpl) {
                if (null == this.disabledPlugins) {
                    IRundeckProject frameworkProject = this.framework.getFrameworkProjectMgr().getFrameworkProject(this.project);
                    String config = frameworkProject.hasProperty(DISABLED_PLUGINS) ? frameworkProject.getProperty(DISABLED_PLUGINS) : null;
                    this.disabledPlugins = new HashSet<String>(PluginControlServiceImpl.parseConfig(config));
                }
            }
        }
        return this.disabledPlugins;
    }

    private static List<String> parseConfig(String pluginConfig) {
        if (pluginConfig != null && !pluginConfig.trim().isEmpty()) {
            return Arrays.asList(pluginConfig.split("\\s*,\\s*"));
        }
        return new ArrayList<String>();
    }

    @Override
    public List<Description> filterEnabledPlugins(List<Description> plugins, String serviceName) {
        Set<String> strings = this.getDisabledPlugins();
        return plugins.stream().filter(description -> !strings.contains(serviceName + ":" + description.getName())).collect(Collectors.toList());
    }

    @Override
    public Predicate<String> enabledPredicateForService(String serviceName) {
        Set<String> strings = this.getDisabledPlugins();
        return name -> !strings.contains(serviceName + ":" + name);
    }

    @Override
    public Predicate<String> disabledPredicateForService(String serviceName) {
        return this.enabledPredicateForService(serviceName).negate();
    }

    @Override
    public boolean isDisabledPlugin(String pluginName, String serviceName) {
        return this.getDisabledPlugins().contains(serviceName + ":" + pluginName);
    }

    @Override
    public void checkDisabledPlugin(String pluginName, String serviceName) throws PluginDisabledException {
        if (this.isDisabledPlugin(pluginName, serviceName)) {
            throw new PluginDisabledException(String.format("%s Plugin '%s' is disabled", serviceName, pluginName));
        }
    }
}

