/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.dispatch;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class INodeEntryComparator
implements Comparator<INodeEntry> {
    private final String rankProperty;

    public INodeEntryComparator(String rankProperty) {
        this.rankProperty = rankProperty;
    }

    public static List<INodeEntry> rankOrderedNodes(INodeSet nodes, String rankProperty, boolean rankAscending) {
        return INodeEntryComparator.rankOrderedNodes(nodes.getNodes(), rankProperty, rankAscending);
    }

    public static List<INodeEntry> rankOrderedNodes(Collection<INodeEntry> nodes, String rankProperty, boolean rankAscending) {
        ArrayList<INodeEntry> nodes1 = new ArrayList<INodeEntry>(nodes);
        INodeEntryComparator comparator = new INodeEntryComparator(rankProperty);
        Collections.sort(nodes1, rankAscending ? comparator : Collections.reverseOrder(comparator));
        return nodes1;
    }

    @Override
    public int compare(INodeEntry iNodeEntry, INodeEntry iNodeEntryB) {
        String valB;
        String valA;
        if (null != this.rankProperty) {
            valA = iNodeEntry.getAttributes().get(this.rankProperty);
            valB = iNodeEntryB.getAttributes().get(this.rankProperty);
        } else {
            valA = iNodeEntry.getNodename();
            valB = iNodeEntryB.getNodename();
        }
        if (null != valA && null != valB) {
            int i;
            Long numA = null;
            Long numB = null;
            try {
                numA = Long.parseLong(valA);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                numB = Long.parseLong(valB);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (null != numA && null != numB && 0 != (i = numA.compareTo(numB))) {
                return i;
            }
            i = valA.compareTo(valB);
            if (i != 0) {
                return i;
            }
        } else {
            if (null != valA) {
                return -1;
            }
            if (null != valB) {
                return 1;
            }
        }
        return iNodeEntry.getNodename().compareTo(iNodeEntryB.getNodename());
    }
}

