/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingResourceModelSourceCache
implements ResourceModelSourceCache {
    public static final Logger logger = LoggerFactory.getLogger(LoggingResourceModelSourceCache.class);
    ResourceModelSourceCache cache;
    String ident;

    public LoggingResourceModelSourceCache(ResourceModelSourceCache cache, String ident) {
        this.cache = cache;
        this.ident = ident;
    }

    @Override
    public void storeNodesInCache(INodeSet nodes) throws ResourceModelSourceException {
        logger.debug(this.ident + " Caching model data for (" + nodes.getNodes().size() + " nodes)");
        this.cache.storeNodesInCache(nodes);
    }

    @Override
    public INodeSet loadCachedNodes() throws ResourceModelSourceException {
        logger.warn(this.ident + " Returning cached model data");
        return this.cache.loadCachedNodes();
    }
}

