/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextUtils {
    public static String escape(String input, char echar, char[] special) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = special;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            sb.append(character);
        }
        sb.append(echar);
        String s = Matcher.quoteReplacement(new String(new char[]{echar}));
        return input.replaceAll("[" + Pattern.quote(sb.toString()) + "]", s + "$0");
    }

    public static String unescape(String input, char echar, char[] allowEscaped) {
        return TextUtils.unescape(input, echar, allowEscaped, new char[0]).unescaped;
    }

    public static Partial unescape(String input, char echar, char[] allowEscaped, char[] delimiter) {
        int i;
        StringBuilder component = new StringBuilder();
        boolean escaped = false;
        Character doneDelimiter = null;
        boolean done = false;
        String allowed = String.valueOf(allowEscaped != null ? allowEscaped : new char[]{}) + echar + String.valueOf(delimiter != null ? delimiter : new char[]{});
        char[] array = input.toCharArray();
        for (i = 0; i < array.length && !done; ++i) {
            char c = array[i];
            if (c == echar) {
                if (escaped) {
                    component.append(echar);
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (allowed.indexOf(c) >= 0) {
                if (escaped) {
                    component.append(c);
                    escaped = false;
                    continue;
                }
                boolean delimFound = false;
                if (null != delimiter) {
                    for (char aDelimiter : delimiter) {
                        if (c != aDelimiter) continue;
                        delimFound = true;
                        doneDelimiter = Character.valueOf(aDelimiter);
                        done = true;
                        break;
                    }
                }
                if (delimFound) continue;
                component.append(c);
                continue;
            }
            if (escaped) {
                component.append(echar);
                escaped = false;
            }
            component.append(c);
        }
        String rest = i <= array.length - 1 ? new String(array, i, array.length - i) : null;
        return new Partial(component.toString(), doneDelimiter, rest);
    }

    public static String join(String[] input, char separator) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String s : input) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(s);
        }
        return stringBuilder.toString();
    }

    public static String joinEscaped(String[] input, char separator, char echar, char[] special) {
        StringBuilder sb = new StringBuilder();
        char[] schars = new char[(special != null ? special.length : 0) + 1];
        if (special != null && special.length > 0) {
            System.arraycopy(special, 0, schars, 1, special.length);
        }
        schars[0] = separator;
        for (String s : input) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(TextUtils.escape(s, echar, schars));
        }
        return sb.toString();
    }

    public static String[] splitUnescape(String input, char separator, char echar, char[] special) {
        return TextUtils.splitUnescape(input, new char[]{separator}, echar, special);
    }

    public static String[] splitUnescape(String input, char[] separators, char echar, char[] special) {
        ArrayList<String> components = new ArrayList<String>();
        boolean done = false;
        String remaining = input;
        while (!done) {
            Partial result = TextUtils.unescape(remaining, echar, special, separators);
            if (result.getUnescaped() != null) {
                components.add(result.unescaped);
            }
            if (result.getRemaining() != null) {
                remaining = result.getRemaining();
                continue;
            }
            done = true;
        }
        return components.toArray(new String[components.size()]);
    }

    public static class Partial {
        private String unescaped;
        private Character delimited;
        private String remaining;

        public Partial(String unescaped, Character delimited, String remaining) {
            this.unescaped = unescaped;
            this.delimited = delimited;
            this.remaining = remaining;
        }

        public String getUnescaped() {
            return this.unescaped;
        }

        public Character getDelimited() {
            return this.delimited;
        }

        public String getRemaining() {
            return this.remaining;
        }
    }
}

