/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.plugins.scm;

import com.dtolabs.rundeck.core.authorization.UserAndRolesAuthContext;
import com.dtolabs.rundeck.core.storage.StorageTree;
import com.dtolabs.rundeck.plugins.scm.ScmOperationContext;
import com.dtolabs.rundeck.plugins.scm.ScmUserInfo;

public class ScmOperationContextBuilder {
    private ScmOperationContextImpl impl = new ScmOperationContextImpl();

    private ScmOperationContextBuilder() {
    }

    public static ScmOperationContextBuilder builder() {
        return new ScmOperationContextBuilder();
    }

    public static ScmOperationContextBuilder builder(ScmOperationContext context) {
        ScmOperationContextBuilder builder = new ScmOperationContextBuilder();
        builder.impl = new ScmOperationContextImpl(context);
        return builder;
    }

    public ScmOperationContextBuilder frameworkProject(String frameworkProject) {
        this.impl.frameworkProject = frameworkProject;
        return this;
    }

    public ScmOperationContextBuilder jobId(String jobId) {
        this.impl.jobId = jobId;
        return this;
    }

    public ScmOperationContextBuilder authContext(UserAndRolesAuthContext authContext) {
        this.impl.authContext = authContext;
        return this;
    }

    public ScmOperationContextBuilder storageTree(StorageTree storageTree) {
        this.impl.storageTree = storageTree;
        return this;
    }

    public ScmOperationContextBuilder userInfo(ScmUserInfo userInfo) {
        this.impl.userInfo = userInfo;
        return this;
    }

    public ScmOperationContext build() {
        return new ScmOperationContextImpl(this.impl);
    }

    static class ScmOperationContextImpl
    implements ScmOperationContext {
        private String frameworkProject;
        private UserAndRolesAuthContext authContext;
        private StorageTree storageTree;
        private ScmUserInfo userInfo;
        private String jobId;

        public ScmOperationContextImpl() {
        }

        public ScmOperationContextImpl(ScmOperationContext context) {
            this.frameworkProject = context.getFrameworkProject();
            this.authContext = context.getAuthContext();
            this.storageTree = context.getStorageTree();
            this.userInfo = context.getUserInfo();
            this.jobId = context.getJobId();
        }

        @Override
        public String getFrameworkProject() {
            return this.frameworkProject;
        }

        @Override
        public UserAndRolesAuthContext getAuthContext() {
            return this.authContext;
        }

        @Override
        public StorageTree getStorageTree() {
            return this.storageTree;
        }

        @Override
        public ScmUserInfo getUserInfo() {
            return this.userInfo;
        }

        @Override
        public String getJobId() {
            return this.jobId;
        }
    }
}

