/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.plugins.util;

import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyUtil;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class DescriptionBuilder {
    private ArrayList<Property> properties;
    private HashMap<String, String> mapping;
    private HashMap<String, String> fwkmapping;
    private String name;
    private String title;
    private String description;
    private Map<String, String> metadata;

    private DescriptionBuilder() {
        this.properties = new ArrayList();
        this.mapping = new HashMap();
        this.fwkmapping = new HashMap();
        this.metadata = new HashMap<String, String>();
    }

    private DescriptionBuilder(Description original) {
        this.properties = new ArrayList<Property>(original.getProperties());
        this.mapping = new HashMap<String, String>(original.getPropertiesMapping());
        this.fwkmapping = new HashMap<String, String>(original.getFwkPropertiesMapping());
        this.metadata = new HashMap<String, String>();
        if (original.getMetadata() != null) {
            this.metadata.putAll(original.getMetadata());
        }
        this.name = original.getName();
        this.title = original.getTitle();
        this.description = original.getDescription();
    }

    public static DescriptionBuilder builder() {
        return new DescriptionBuilder();
    }

    public static Description buildDescriptionWith(Consumer<DescriptionBuilder> builder) {
        DescriptionBuilder builder1 = DescriptionBuilder.builder();
        builder.accept(builder1);
        return builder1.build();
    }

    public static DescriptionBuilder builder(Description original) {
        return new DescriptionBuilder(original);
    }

    public DescriptionBuilder name(String name) {
        this.name = name;
        return this;
    }

    public DescriptionBuilder title(String title) {
        this.title = title;
        return this;
    }

    public DescriptionBuilder description(String description) {
        this.description = description;
        return this;
    }

    public DescriptionBuilder mapping(String key, String name) {
        this.mapping.put(key, name);
        return this;
    }

    public DescriptionBuilder frameworkMapping(String key, String name) {
        this.fwkmapping.put(key, name);
        return this;
    }

    public DescriptionBuilder mapping(Map<String, String> mapping) {
        this.mapping.putAll(mapping);
        return this;
    }

    public DescriptionBuilder frameworkMapping(Map<String, String> mapping) {
        this.fwkmapping.putAll(mapping);
        return this;
    }

    public DescriptionBuilder stringProperty(String name, String defaultValue, boolean required, String propTitle, String propDescription) {
        this.properties.add(PropertyUtil.string(name, propTitle, propDescription, required, defaultValue));
        return this;
    }

    public DescriptionBuilder booleanProperty(String name, String defaultValue, boolean required, String propTitle, String propDescription) {
        this.properties.add(PropertyUtil.bool(name, propTitle, propDescription, required, defaultValue));
        return this;
    }

    public DescriptionBuilder integerProperty(String name, String defaultValue, boolean required, String propTitle, String propDescription) {
        this.properties.add(PropertyUtil.integer(name, propTitle, propDescription, required, defaultValue));
        return this;
    }

    public DescriptionBuilder selectProperty(String name, String defaultValue, boolean required, String propTitle, String propDescription, List<String> selectValues) {
        this.properties.add(PropertyUtil.select(name, propTitle, propDescription, required, defaultValue, selectValues));
        return this;
    }

    public DescriptionBuilder freeSelectProperty(String name, String defaultValue, boolean required, String propTitle, String propDescription, List<String> selectValues) {
        this.properties.add(PropertyUtil.freeSelect(name, propTitle, propDescription, required, defaultValue, selectValues));
        return this;
    }

    public DescriptionBuilder property(PropertyBuilder property) {
        this.replaceOrAddProperty(property.build());
        return this;
    }

    public DescriptionBuilder property(Property property) {
        this.replaceOrAddProperty(property);
        return this;
    }

    public DescriptionBuilder property(Consumer<PropertyBuilder> builder) {
        PropertyBuilder propertyBuilder = PropertyBuilder.builder();
        builder.accept(propertyBuilder);
        this.replaceOrAddProperty(propertyBuilder.build());
        return this;
    }

    public DescriptionBuilder removeProperty(String name) {
        Property found = this.findProperty(name);
        if (null != found) {
            this.properties.remove(found);
        }
        return this;
    }

    private Property findProperty(String name) {
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    private void replaceOrAddProperty(Property p) {
        for (Property property : this.properties) {
            if (!property.getName().equals(p.getName())) continue;
            this.properties.set(this.properties.indexOf(property), p);
            return;
        }
        this.properties.add(p);
    }

    public PropertyBuilder property(String name) {
        Property found = this.findProperty(name);
        if (null != found) {
            return PropertyBuilder.builder(found);
        }
        return PropertyBuilder.builder().name(name);
    }

    public DescriptionBuilder metadata(String key, String value) {
        this.metadata.put(key, value);
        return this;
    }

    public DescriptionBuilder metadata(Map<String, String> values) {
        this.metadata.putAll(values);
        return this;
    }

    public Description build() {
        if (null == this.name) {
            throw new IllegalStateException("name is not set");
        }
        final String title1 = null != this.title ? this.title : this.name;
        final List<Property> properties1 = this.buildProperties();
        final Map<String, String> mapping1 = Collections.unmodifiableMap(this.mapping);
        final Map<String, String> mapping2 = Collections.unmodifiableMap(this.fwkmapping);
        final Map<String, String> metadata2 = Collections.unmodifiableMap(this.metadata);
        return new Description(){

            @Override
            public String getName() {
                return DescriptionBuilder.this.name;
            }

            @Override
            public String getTitle() {
                return title1;
            }

            @Override
            public String getDescription() {
                return DescriptionBuilder.this.description;
            }

            @Override
            public List<Property> getProperties() {
                return properties1;
            }

            @Override
            public Map<String, String> getPropertiesMapping() {
                return mapping1;
            }

            @Override
            public Map<String, String> getFwkPropertiesMapping() {
                return mapping2;
            }

            @Override
            public Map<String, String> getMetadata() {
                return metadata2;
            }

            public String toString() {
                return "PropertyDescription{name = " + this.getName() + ", title = " + this.getTitle() + ", description = " + this.getDescription() + ", properties = " + this.getProperties() + ", mapping = " + this.getPropertiesMapping() + "frameworkMapping = " + this.getFwkPropertiesMapping() + "metadata = " + metadata2 + "}";
            }
        };
    }

    public List<Property> buildProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public DescriptionBuilder collaborate(Collaborator colab) {
        colab.buildWith(this);
        return this;
    }

    public DescriptionBuilder collaborate(Object colab) {
        if (colab instanceof Collaborator) {
            return this.collaborate((Collaborator)colab);
        }
        return this;
    }

    public static interface Collaborator {
        public void buildWith(DescriptionBuilder var1);
    }
}

