/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.storage;

import com.dtolabs.rundeck.core.storage.BaseResource;
import com.dtolabs.rundeck.core.storage.BaseStreamResource;
import com.dtolabs.rundeck.core.storage.ExtTree;
import com.dtolabs.rundeck.core.storage.ResolvedExtTree;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.storage.ResourceMetaBuilder;
import com.dtolabs.rundeck.core.storage.StorageTree;
import com.dtolabs.rundeck.core.storage.StorageTreeImpl;
import com.dtolabs.utils.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.rundeck.storage.api.ContentFactory;
import org.rundeck.storage.api.HasInputStream;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.api.Tree;

public class StorageUtil {
    public static final String RES_META_RUNDECK_CONTENT_TYPE = "Rundeck-content-type";
    public static final String RES_META_RUNDECK_CONTENT_LENGTH = "Rundeck-content-size";
    public static final String RES_META_RUNDECK_CONTENT_CREATION_TIME = "Rundeck-content-creation-time";
    public static final String RES_META_RUNDECK_CONTENT_MODIFY_TIME = "Rundeck-content-modify-time";
    public static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final ThreadLocal<DateFormat> w3cDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat fmt = new SimpleDateFormat(StorageUtil.ISO_8601_FORMAT, Locale.US);
            fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            return fmt;
        }
    };

    public static ContentFactory<ResourceMeta> factory() {
        return StorageUtil::withStream;
    }

    public static ResourceMetaBuilder create() {
        return StorageUtil.create(null);
    }

    public static ResourceMetaBuilder create(Map<String, String> meta) {
        ResourceMetaBuilder mutableRundeckResourceMeta = new ResourceMetaBuilder(meta);
        return mutableRundeckResourceMeta;
    }

    public static ResourceMeta withStream(HasInputStream stream, Map<String, String> meta) {
        return new BaseStreamResource(meta, stream);
    }

    public static ResourceMeta withStream(final InputStream stream, Map<String, String> meta) {
        return new BaseResource(meta){

            public long writeContent(OutputStream out) throws IOException {
                return Streams.copyStream(stream, out);
            }

            public InputStream getInputStream() throws IOException {
                return stream;
            }
        };
    }

    public static boolean deletePathRecursive(Tree<ResourceMeta> tree, Path path) {
        if (tree.hasResource(path)) {
            return tree.deleteResource(path);
        }
        if (tree.hasDirectory(path)) {
            Set resources = tree.listDirectory(path);
            boolean failed = false;
            for (Resource resource : resources) {
                if (resource.isDirectory()) {
                    if (StorageUtil.deletePathRecursive(tree, resource.getPath())) continue;
                    failed = true;
                    continue;
                }
                if (tree.deleteResource(resource.getPath())) continue;
                failed = true;
            }
            return !failed;
        }
        return true;
    }

    public static StorageTree asStorageTree(Tree<ResourceMeta> impl) {
        return new StorageTreeImpl(impl);
    }

    static long parseLong(String s, long defval) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            return defval;
        }
    }

    static Date parseDate(String s, Date defval) {
        if (null != s) {
            try {
                return w3cDateFormat.get().parse(s);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return defval;
    }

    public static String formatDate(Date time) {
        return w3cDateFormat.get().format(time);
    }

    public static <S> StorageTree resolvedTree(S context, ExtTree<S, ResourceMeta> authStorage) {
        return ResolvedExtTree.with(context, authStorage);
    }
}

