/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.tasks.net;

import com.dtolabs.rundeck.core.execution.BaseLogger;
import com.dtolabs.rundeck.plugins.PluginLogger;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;

public class ThreadBoundJschLogger
implements Logger {
    private InheritableThreadLocal<BaseLogger> baseLogger = new InheritableThreadLocal();
    private InheritableThreadLocal<PluginLogger> pluginLogger = new InheritableThreadLocal();
    private InheritableThreadLocal<Integer> logLevel = new InheritableThreadLocal();
    private static ThreadBoundJschLogger instance;

    private ThreadBoundJschLogger() {
    }

    public static ThreadBoundJschLogger getInstance(BaseLogger logger, int loggingLevel) {
        ThreadBoundJschLogger.getInstance();
        instance.setThreadLogger(logger, loggingLevel);
        return instance;
    }

    public static ThreadBoundJschLogger getInstance(PluginLogger logger, int loggingLevel) {
        ThreadBoundJschLogger.getInstance();
        instance.setThreadLogger(logger, loggingLevel);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getInstance() {
        Class<ThreadBoundJschLogger> clazz = ThreadBoundJschLogger.class;
        synchronized (ThreadBoundJschLogger.class) {
            if (null == instance) {
                instance = new ThreadBoundJschLogger();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void setThreadLogger(BaseLogger logger, int loggingLevel) {
        this.baseLogger.set(logger);
        this.logLevel.set(loggingLevel);
        JSch.setLogger((Logger)this);
    }

    private void setThreadLogger(PluginLogger logger, int loggingLevel) {
        this.pluginLogger.set(logger);
        this.logLevel.set(loggingLevel);
        JSch.setLogger((Logger)this);
    }

    public boolean isEnabled(int level) {
        Integer integer = (Integer)this.logLevel.get();
        return null != integer && integer <= level;
    }

    public void log(int level, String message) {
        BaseLogger baseLogger1 = (BaseLogger)this.baseLogger.get();
        PluginLogger pluginLogger1 = (PluginLogger)this.pluginLogger.get();
        if (null != baseLogger1) {
            switch (level) {
                case 3: 
                case 4: {
                    baseLogger1.error(message);
                    break;
                }
                case 2: {
                    baseLogger1.warn(message);
                    break;
                }
                case 0: {
                    baseLogger1.debug(message);
                    break;
                }
                default: {
                    baseLogger1.log(message);
                }
            }
        }
        if (null != pluginLogger1) {
            switch (level) {
                case 3: 
                case 4: {
                    pluginLogger1.log(0, message);
                    break;
                }
                case 2: {
                    pluginLogger1.log(1, message);
                    break;
                }
                case 0: {
                    pluginLogger1.log(5, message);
                    break;
                }
                default: {
                    pluginLogger1.log(5, message);
                }
            }
        }
    }
}

