/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.logstorage;

import com.dtolabs.rundeck.core.logging.LogFileState;

public enum ExecutionFileState {
    NOT_FOUND,
    AVAILABLE,
    AVAILABLE_PARTIAL,
    WAITING,
    AVAILABLE_REMOTE,
    AVAILABLE_REMOTE_PARTIAL,
    PENDING_REMOTE,
    PENDING_LOCAL,
    ERROR;


    public boolean isAvailableOrPartial() {
        return this == AVAILABLE || this == AVAILABLE_PARTIAL;
    }

    public static ExecutionFileState forFileStates(LogFileState local, LogFileState remote) {
        return ExecutionFileState.forFileStates(local, remote, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ExecutionFileState forFileStates(LogFileState local, LogFileState remote, ExecutionFileState notFoundState) {
        switch (local) {
            case AVAILABLE: {
                return AVAILABLE;
            }
            case AVAILABLE_PARTIAL: {
                return AVAILABLE_PARTIAL;
            }
            case PENDING: {
                return PENDING_LOCAL;
            }
            case NOT_FOUND: {
                switch (remote) {
                    case ERROR: {
                        return ERROR;
                    }
                    case AVAILABLE: {
                        return AVAILABLE_REMOTE;
                    }
                    case AVAILABLE_PARTIAL: {
                        return AVAILABLE_REMOTE_PARTIAL;
                    }
                    case PENDING: {
                        return PENDING_REMOTE;
                    }
                    case NOT_FOUND: {
                        if (null == notFoundState) return NOT_FOUND;
                        return notFoundState;
                    }
                }
                return NOT_FOUND;
            }
        }
        return NOT_FOUND;
    }
}

