/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.jsch;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.utils.PasswordSource;
import com.dtolabs.rundeck.core.execution.utils.ResolverUtil;
import com.dtolabs.rundeck.core.execution.utils.Responder;
import java.util.regex.Pattern;

class SudoResponder
implements Responder {
    public static final String DEFAULT_DESCRIPTION = "Sudo execution password response";
    private String sudoCommandPattern;
    private String inputSuccessPattern;
    private String inputFailurePattern;
    private String responseSuccessPattern;
    private String responseFailurePattern;
    private int inputMaxLines = -1;
    private long inputMaxTimeout = -1L;
    private boolean failOnInputLinesThreshold = false;
    private boolean failOnInputTimeoutThreshold = true;
    private boolean successOnInputThreshold = true;
    private int responseMaxLines = -1;
    private long responseMaxTimeout = -1L;
    private boolean failOnResponseThreshold = false;
    private byte[] inputBytes;
    private String configPrefix = "sudo-";
    private String description = "Sudo execution password response";
    private PasswordSource passwordSource;
    private String defaultSudoCommandPattern = "^sudo$";
    private boolean sudoEnabled = false;

    private SudoResponder() {
    }

    private SudoResponder(String configPrefix, PasswordSource passwordSource, String defaultSudoCommandPattern) {
        this();
        if (null != configPrefix) {
            this.configPrefix = configPrefix;
        }
        if (null != passwordSource) {
            this.passwordSource = passwordSource;
        }
        if (null != defaultSudoCommandPattern) {
            this.defaultSudoCommandPattern = defaultSudoCommandPattern;
        }
    }

    static SudoResponder create(INodeEntry node, Framework framework, ExecutionContext context, String configPrefix, PasswordSource passwordSource, String defaultSudoCommandPattern) {
        SudoResponder sudoResponder = new SudoResponder(configPrefix, passwordSource, defaultSudoCommandPattern);
        sudoResponder.init(node, framework.getFrameworkProjectMgr().getFrameworkProject(context.getFrameworkProject()), framework);
        return sudoResponder;
    }

    public boolean matchesCommandPattern(String command) {
        String sudoCommandPattern1 = this.getSudoCommandPattern();
        if (null != sudoCommandPattern1) {
            return Pattern.compile(sudoCommandPattern1).matcher(command).matches();
        }
        return false;
    }

    private void init(INodeEntry node, IRundeckProject frameworkProject, Framework framework) {
        this.sudoEnabled = ResolverUtil.resolveBooleanProperty(this.configPrefix + "command-enabled", false, node, frameworkProject, framework);
        if (this.sudoEnabled) {
            byte[] sudoPassword = this.passwordSource.getPassword();
            this.inputBytes = null != sudoPassword ? this.appendBytes(sudoPassword, "\n".getBytes()) : new byte[]{};
            this.passwordSource.clear();
            this.sudoCommandPattern = ResolverUtil.resolveProperty(this.configPrefix + "command-pattern", this.defaultSudoCommandPattern, node, frameworkProject, framework);
            this.inputSuccessPattern = ResolverUtil.resolveProperty(this.configPrefix + "prompt-pattern", "^\\[sudo\\] password for .+: .*", node, frameworkProject, framework);
            this.inputFailurePattern = null;
            this.responseFailurePattern = ResolverUtil.resolveProperty(this.configPrefix + "failure-pattern", "^.*try again.*", node, frameworkProject, framework);
            this.responseSuccessPattern = null;
            this.inputMaxLines = ResolverUtil.resolveIntProperty(this.configPrefix + "prompt-max-lines", 12, node, frameworkProject, framework);
            this.inputMaxTimeout = ResolverUtil.resolveLongProperty(this.configPrefix + "prompt-max-timeout", 5000L, node, frameworkProject, framework);
            this.responseMaxLines = ResolverUtil.resolveIntProperty(this.configPrefix + "response-max-lines", 2, node, frameworkProject, framework);
            this.responseMaxTimeout = ResolverUtil.resolveLongProperty(this.configPrefix + "response-max-timeout", 5000L, node, frameworkProject, framework);
            this.failOnInputLinesThreshold = ResolverUtil.resolveBooleanProperty(this.configPrefix + "fail-on-prompt-max-lines", false, node, frameworkProject, framework);
            this.failOnInputTimeoutThreshold = ResolverUtil.resolveBooleanProperty(this.configPrefix + "fail-on-prompt-timeout", true, node, frameworkProject, framework);
            this.failOnResponseThreshold = ResolverUtil.resolveBooleanProperty(this.configPrefix + "fail-on-response-timeout", false, node, frameworkProject, framework);
            this.successOnInputThreshold = ResolverUtil.resolveBooleanProperty(this.configPrefix + "success-on-prompt-threshold", true, node, frameworkProject, framework);
        }
    }

    private byte[] appendBytes(byte[] first, byte[] second) {
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public boolean isSudoEnabled() {
        return this.sudoEnabled;
    }

    @Override
    public byte[] getInputBytes() {
        return this.inputBytes;
    }

    @Override
    public boolean isFailOnInputLinesThreshold() {
        return this.failOnInputLinesThreshold;
    }

    @Override
    public boolean isFailOnInputTimeoutThreshold() {
        return this.failOnInputTimeoutThreshold;
    }

    @Override
    public boolean isFailOnResponseThreshold() {
        return this.failOnResponseThreshold;
    }

    @Override
    public boolean isSuccessOnInputThreshold() {
        return this.successOnInputThreshold;
    }

    public String getSudoCommandPattern() {
        return this.sudoCommandPattern;
    }

    @Override
    public String getInputFailurePattern() {
        return this.inputFailurePattern;
    }

    @Override
    public String getInputSuccessPattern() {
        return this.inputSuccessPattern;
    }

    @Override
    public String getResponseSuccessPattern() {
        return this.responseSuccessPattern;
    }

    @Override
    public String getResponseFailurePattern() {
        return this.responseFailurePattern;
    }

    @Override
    public int getInputMaxLines() {
        return this.inputMaxLines;
    }

    @Override
    public long getInputMaxTimeout() {
        return this.inputMaxTimeout;
    }

    @Override
    public int getResponseMaxLines() {
        return this.responseMaxLines;
    }

    @Override
    public long getResponseMaxTimeout() {
        return this.responseMaxTimeout;
    }

    public String toString() {
        return this.description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

