/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.storage;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.authorization.AuthorizationUtil;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.authorization.NamedAuthContext;
import com.dtolabs.rundeck.core.storage.AuthStorageTree;
import com.dtolabs.rundeck.core.storage.AuthStorageUsernameMeta;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.storage.ResourceMetaBuilder;
import com.dtolabs.rundeck.core.storage.StorageAuthorizationException;
import com.dtolabs.rundeck.core.storage.StorageTree;
import com.dtolabs.rundeck.core.storage.StorageUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.rundeck.storage.api.HasInputStream;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.api.StorageException;

public class AuthRundeckStorageTree
implements AuthStorageTree {
    public static final String READ = "read";
    public static final String DELETE = "delete";
    public static final String CREATE = "create";
    public static final String UPDATE = "update";
    public static final String STORAGE_PATH_AUTH_RES_TYPE = "storage";
    public static final String PATH_RES_KEY = "path";
    public static final String NAME_RES_KEY = "name";
    public static final String PROJECT_PATH_COMPONENT = "project";
    private StorageTree storageTree;

    public AuthRundeckStorageTree(StorageTree storageTree) {
        this.storageTree = storageTree;
    }

    private boolean authorizedPath(AuthContext context, Path path, String action) {
        Decision evaluate = context.evaluate(this.resourceForPath(path), action, this.environmentForPath(path));
        return evaluate.isAuthorized();
    }

    private Map<String, String> resourceForPath(Path path) {
        return AuthorizationUtil.resource((String)STORAGE_PATH_AUTH_RES_TYPE, this.authResForPath(path));
    }

    private Map<String, String> authResForPath(Path path) {
        HashMap<String, String> authResource = new HashMap<String, String>();
        authResource.put(PATH_RES_KEY, path.getPath());
        authResource.put(NAME_RES_KEY, path.getName());
        return authResource;
    }

    Set<Attribute> environmentForPath(Path path) {
        String[] paths = path.getPath().split("/");
        if (paths != null && paths.length > 2 && paths[0].equals(PROJECT_PATH_COMPONENT)) {
            return AuthorizationUtil.projectContext((String)paths[1]);
        }
        return AuthorizationUtil.RUNDECK_APP_ENV;
    }

    @Override
    public boolean hasPath(AuthContext auth, Path path) {
        return this.authorizedPath(auth, path, READ) && this.storageTree.hasPath(path);
    }

    @Override
    public boolean hasResource(AuthContext auth, Path path) {
        return this.authorizedPath(auth, path, READ) && this.storageTree.hasResource(path);
    }

    @Override
    public boolean hasDirectory(AuthContext auth, Path path) {
        return this.authorizedPath(auth, path, READ) && this.storageTree.hasDirectory(path);
    }

    @Override
    public Resource<ResourceMeta> getPath(AuthContext auth, Path path) {
        if (!this.authorizedPath(auth, path, READ)) {
            throw new StorageAuthorizationException("Unauthorized access", StorageException.Event.READ, path);
        }
        Resource resource = this.storageTree.getPath(path);
        if (resource.isDirectory()) {
            return resource;
        }
        return resource;
    }

    @Override
    public Resource<ResourceMeta> getResource(AuthContext auth, Path path) {
        if (!this.authorizedPath(auth, path, READ)) {
            throw new StorageAuthorizationException("Unauthorized access", StorageException.Event.READ, path);
        }
        Resource resource = this.storageTree.getResource(path);
        return resource;
    }

    @Override
    public Set<Resource<ResourceMeta>> listDirectoryResources(AuthContext auth, Path path) {
        if (!this.authorizedPath(auth, path, READ)) {
            throw new StorageAuthorizationException("Unauthorized access", StorageException.Event.LIST, path);
        }
        Set resources = this.storageTree.listDirectoryResources(path);
        return this.filteredResources(auth, resources, READ);
    }

    private Set<Resource<ResourceMeta>> filteredResources(AuthContext auth, Set<Resource<ResourceMeta>> resources, String action) {
        HashSet<Resource<ResourceMeta>> resources1 = new HashSet<Resource<ResourceMeta>>();
        for (Resource<ResourceMeta> resource : resources) {
            if (!this.authorizedPath(auth, resource.getPath(), action)) continue;
            resources1.add(resource);
        }
        return resources1;
    }

    @Override
    public Set<Resource<ResourceMeta>> listDirectory(AuthContext auth, Path path) {
        if (!this.authorizedPath(auth, path, READ)) {
            throw new StorageAuthorizationException("Unauthorized access", StorageException.Event.LIST, path);
        }
        Set resources = this.storageTree.listDirectory(path);
        return this.filteredResources(auth, resources, READ);
    }

    @Override
    public Set<Resource<ResourceMeta>> listDirectorySubdirs(AuthContext auth, Path path) {
        if (!this.authorizedPath(auth, path, READ)) {
            throw new StorageAuthorizationException("Unauthorized access", StorageException.Event.READ, path);
        }
        Set resources = this.storageTree.listDirectorySubdirs(path);
        return this.filteredResources(auth, resources, READ);
    }

    @Override
    public boolean deleteResource(AuthContext auth, Path path) {
        if (!this.authorizedPath(auth, path, DELETE)) {
            throw new StorageAuthorizationException("Unauthorized access", StorageException.Event.DELETE, path);
        }
        return this.storageTree.deleteResource(path);
    }

    @Override
    public Resource<ResourceMeta> createResource(AuthContext auth, Path path, ResourceMeta content) {
        if (!this.authorizedPath(auth, path, CREATE)) {
            throw new StorageAuthorizationException("Unauthorized access", StorageException.Event.CREATE, path);
        }
        return this.storageTree.createResource(path, this.withUsername(auth, content, true));
    }

    private ResourceMeta withUsername(AuthContext auth, ResourceMeta content, boolean create) {
        if (auth instanceof NamedAuthContext) {
            NamedAuthContext byUser = (NamedAuthContext)auth;
            ResourceMetaBuilder resourceMetaBuilder = StorageUtil.create(new HashMap<String, String>(content.getMeta()));
            if (create) {
                AuthStorageUsernameMeta.createResource(byUser, resourceMetaBuilder);
            } else {
                AuthStorageUsernameMeta.updateResource(byUser, resourceMetaBuilder);
            }
            return StorageUtil.withStream((HasInputStream)content, resourceMetaBuilder.getResourceMeta());
        }
        return content;
    }

    @Override
    public Resource<ResourceMeta> updateResource(AuthContext auth, Path path, ResourceMeta content) {
        if (!this.authorizedPath(auth, path, UPDATE)) {
            throw new StorageAuthorizationException("Unauthorized access", StorageException.Event.UPDATE, path);
        }
        return this.storageTree.updateResource(path, this.withUsername(auth, content, false));
    }
}

