/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authentication.Group;
import com.dtolabs.rundeck.core.authentication.Urn;
import com.dtolabs.rundeck.core.authentication.Username;
import com.dtolabs.rundeck.core.authorization.UserAndRoles;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

public class SubjectUserAndRoles
implements UserAndRoles {
    private final Subject subject;

    public SubjectUserAndRoles(Subject subject) {
        this.subject = subject;
    }

    public String getUsername() {
        Set<Username> principals = this.subject.getPrincipals(Username.class);
        if (principals.size() > 0) {
            return principals.iterator().next().getName();
        }
        return null;
    }

    public Set<String> getRoles() {
        Set<Group> principals = this.subject.getPrincipals(Group.class);
        HashSet<String> roles = new HashSet<String>();
        if (principals.size() > 0) {
            for (Group principal : principals) {
                roles.add(principal.getName());
            }
        }
        return roles;
    }

    public String getUrn() {
        Set<Urn> principals = this.subject.getPrincipals(Urn.class);
        if (principals.size() > 0) {
            return principals.iterator().next().getName();
        }
        return null;
    }

    protected Subject getSubject() {
        return this.subject;
    }
}

