/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution;

import com.dtolabs.rundeck.core.cli.CLIUtils;
import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.data.MultiDataContext;
import com.dtolabs.rundeck.core.data.SharedDataContextUtils;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecArg;
import com.dtolabs.rundeck.core.utils.Converter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class ExecArgList {
    List<ExecArg> args = new ArrayList<ExecArg>();

    private ExecArgList() {
    }

    private void addArg(ExecArg arg) {
        this.args.add(arg);
    }

    private void addArg(String arg, boolean quoted) {
        this.args.add(ExecArg.fromString(arg, quoted));
    }

    private void addArgs(List<String> arg, boolean quoted) {
        for (String s : arg) {
            this.addArg(s, quoted);
        }
    }

    public static ExecArgList fromStrings(boolean quoted, String ... args) {
        return ExecArgList.fromStrings(Arrays.asList(args), quoted);
    }

    public static ExecArgList fromStrings(Predicate quoteDetect, String ... args) {
        return ExecArgList.builder().args(args, quoteDetect).build();
    }

    public static ExecArgList fromStrings(List<String> strings, boolean quoted) {
        return ExecArgList.builder().args(strings, quoted).build();
    }

    public List<ExecArg> getList() {
        return this.args;
    }

    public String[] asFlatStringArray() {
        ArrayList<String> strings = this.asFlatStringList();
        return strings.toArray(new String[strings.size()]);
    }

    public ArrayList<String> asFlatStringList() {
        final ArrayList<String> strings = new ArrayList<String>();
        for (ExecArg arg : this.getList()) {
            arg.accept(new ExecArg.Visitor(){

                @Override
                public void visit(ExecArg arg) {
                    if (arg.isList()) {
                        for (ExecArg execArg : arg.getList()) {
                            execArg.accept(this);
                        }
                    } else {
                        strings.add(arg.getString());
                    }
                }
            });
        }
        return strings;
    }

    public static String joinAndQuote(List<String> commandList1, Converter<String, String> quote) {
        String join = DataContextUtils.join(commandList1, " ");
        if (null != quote) {
            join = quote.convert(join);
        }
        return join;
    }

    @Deprecated
    public ArrayList<String> buildCommandForNode(Map<String, Map<String, String>> dataContext, String osFamily) {
        return ExecArgList.buildCommandForNode(this, dataContext, osFamily);
    }

    private static ArrayList<String> buildCommandForNode(ExecArgList command, Map<String, Map<String, String>> dataContext, String osFamily) {
        Converter<String, String> quote = CLIUtils.argumentQuoteForOperatingSystem(osFamily);
        Converter<String, String> expand = DataContextUtils.replaceDataReferencesConverter(dataContext, DataContextUtils.replaceMissingOptionsWithBlank, false);
        ArrayList<String> commandList = new ArrayList<String>();
        CommandVisitor visiter = new CommandVisitor(commandList, quote, expand);
        command.visitWith(visiter);
        return commandList;
    }

    public ArrayList<String> buildCommandForNode(MultiDataContext<ContextView, DataContext> sharedContext, String nodeName, String osFamily) {
        return ExecArgList.buildCommandForNode(this, sharedContext, nodeName, osFamily);
    }

    private static ArrayList<String> buildCommandForNode(ExecArgList command, MultiDataContext<ContextView, DataContext> sharedContext, String nodeName, String osFamily) {
        ArrayList<String> commandList = new ArrayList<String>();
        CommandVisitor visiter = new CommandVisitor(commandList, CLIUtils.argumentQuoteForOperatingSystem(osFamily), str -> SharedDataContextUtils.replaceDataReferences(str, sharedContext, ContextView.node(nodeName), ContextView::nodeStep, DataContextUtils.replaceMissingOptionsWithBlank, false, false));
        command.visitWith(visiter);
        return commandList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void visitWith(ExecArg.Visitor visitor) {
        for (ExecArg arg : this.getList()) {
            arg.accept(visitor);
        }
    }

    public String toString() {
        return this.asFlatStringList().toString();
    }

    public static class Builder {
        private ExecArgList argList = new ExecArgList();
        private Builder parent;

        public Builder arg(String arg, boolean quoted) {
            this.argList.addArg(arg, quoted);
            return this;
        }

        public Builder args(List<String> args, boolean quoted) {
            this.argList.addArgs(args, quoted);
            return this;
        }

        public Builder args(List<String> args, Predicate quoted) {
            for (String arg : args) {
                this.argList.addArg(arg, quoted.test(arg));
            }
            return this;
        }

        public Builder args(String[] args, Predicate quoted) {
            return this.args(Arrays.asList(args), quoted);
        }

        public Builder args(String[] args, boolean quoted) {
            this.argList.addArgs(Arrays.asList(args), quoted);
            return this;
        }

        public Builder subList(boolean quoted) {
            Builder subbuild = new Builder();
            ArgListBuilder arg = new ArgListBuilder(subbuild);
            arg.setQuoted(quoted);
            this.argList.addArg(arg);
            subbuild.parent = this;
            return subbuild;
        }

        public Builder parent() {
            if (null != this.parent) {
                return this.parent;
            }
            throw new IllegalStateException("no parent builder");
        }

        public ExecArgList build() {
            return this.argList;
        }
    }

    private static class ArgListBuilder
    extends ExecArg.ListArg {
        private Builder builder;
        boolean built = false;

        private ArgListBuilder(Builder builder) {
            this.builder = builder;
        }

        private void finishBuild() {
            if (!this.built) {
                this.setArgs(this.builder.build());
                this.built = true;
            }
        }

        @Override
        protected ExecArgList getArgs() {
            this.finishBuild();
            return super.getArgs();
        }
    }

    private static class CommandVisitor
    implements ExecArg.Visitor {
        private final ArrayList<String> commandList;
        final Converter<String, String> quote;
        final Converter<String, String> expand;

        private CommandVisitor(ArrayList<String> commandList, Converter<String, String> quote, Converter<String, String> expand) {
            this.commandList = commandList;
            this.quote = quote;
            this.expand = expand;
        }

        public String convertAndQuote(String s, boolean quoted) {
            String replaced = this.expand.convert(s);
            if (this.quote != null && quoted) {
                replaced = this.quote.convert(replaced);
            }
            return replaced;
        }

        @Override
        public void visit(ExecArg arg) {
            if (arg.isList()) {
                CommandVisitor commandVisitor = new CommandVisitor(new ArrayList<String>(), this.quote, this.expand);
                for (ExecArg execArg : arg.getList()) {
                    execArg.accept(commandVisitor);
                }
                String join = ExecArgList.joinAndQuote(commandVisitor.getCommandList(), arg.isQuoted() ? this.quote : null);
                this.getCommandList().add(join);
            } else {
                this.getCommandList().add(this.convertAndQuote(arg.getString(), arg.isQuoted()));
            }
        }

        public ArrayList<String> getCommandList() {
            return this.commandList;
        }
    }
}

