/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.data;

import com.dtolabs.rundeck.core.data.ArgumentVarExpander;
import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.data.MultiDataContext;
import com.dtolabs.rundeck.core.data.ScriptVarExpander;
import com.dtolabs.rundeck.core.data.ViewTraverse;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.dispatcher.ReplaceTokenReader;
import com.dtolabs.rundeck.core.execution.script.ScriptfileUtils;
import com.dtolabs.rundeck.core.execution.workflow.DataOutput;
import com.dtolabs.rundeck.core.execution.workflow.ReadableSharedContext;
import com.dtolabs.rundeck.core.execution.workflow.WFSharedContext;
import com.dtolabs.rundeck.core.utils.Converter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SharedDataContextUtils {
    public static final String PROPERTY_REF_REGEX = "\\$\\{([^\\s.]+)\\.([^\\s}]+)\\}";
    public static final String PROPERTY_VIEW_REF_REGEX = "\\$\\{([^\\s}]+)\\}";
    public static final Pattern PROPERTY_REF_PATTERN = Pattern.compile("\\$\\{([^\\s.]+)\\.([^\\s}]+)\\}");
    private static final Pattern PROPERTY_VIEW_REF_PATTERN = Pattern.compile("\\$\\{([^\\s}]+)\\}");
    public static final String UNQUOTEDPROPERTY_PREFIX = "unquoted";
    private static final String UNQUOTEDPROPERTY_REF_REGEX = "\\$\\{(unquoted[^\\s.]+)\\.([^\\s}]+)\\}";
    public static final Pattern UNQUOTEDPROPERTY_REF_PATTERN = Pattern.compile("\\$\\{(unquoted[^\\s.]+)\\.([^\\s}]+)\\}");

    public static ReadableSharedContext outputContext(ContextView defaultView) {
        return new DataOutput(defaultView);
    }

    public static WFSharedContext sharedContext() {
        return new WFSharedContext();
    }

    public static <T extends ViewTraverse<T>> String[] replaceDataReferences(String[] args, MultiDataContext<T, DataContext> data, T currentContext, BiFunction<Integer, String, T> viewMap, Converter<String, String> converter, boolean failIfUnexpanded, boolean blankIfUnexpanded) {
        if (null == data) {
            return args;
        }
        if (null == args || args.length < 1) {
            return args;
        }
        String[] newargs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            newargs[i] = SharedDataContextUtils.replaceDataReferences(arg, data, currentContext, viewMap, converter, failIfUnexpanded, blankIfUnexpanded);
        }
        return newargs;
    }

    public static <T extends ViewTraverse<T>> String replaceDataReferences(String input, MultiDataContext<T, DataContext> data, T currentContext, BiFunction<Integer, String, T> viewMap, Converter<String, String> converter, boolean failOnUnexpanded, boolean blankIfUnexpanded) {
        if (null == data || null == input) {
            return input;
        }
        Matcher m = PROPERTY_VIEW_REF_PATTERN.matcher(input);
        StringBuffer sb = new StringBuffer();
        ArgumentVarExpander argExpander = new ArgumentVarExpander();
        while (m.find()) {
            String value;
            String variableRef = m.group(1);
            if (m.group(1).startsWith(UNQUOTEDPROPERTY_PREFIX)) {
                variableRef = m.group(1).replace(UNQUOTEDPROPERTY_PREFIX, "");
            }
            if (null != (value = argExpander.expandVariable(data, currentContext, viewMap, variableRef))) {
                if (null != converter) {
                    value = converter.convert(value);
                }
                m.appendReplacement(sb, Matcher.quoteReplacement(value));
                continue;
            }
            if (failOnUnexpanded) {
                throw new DataContextUtils.UnresolvedDataReferenceException(input, m.group());
            }
            if (blankIfUnexpanded) {
                m.appendReplacement(sb, "");
                continue;
            }
            value = m.group(0);
            if (null != converter) {
                value = converter.convert(value);
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String escapeShell(String s) {
        if (null == s) {
            return s;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return s;
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.replaceAll("([\\\\`])", "\\\\$1");
        }
        return s.replaceAll("([&><|;\\\\`])", "\\\\$1");
    }

    public static String escapeWindowsShell(String s) {
        if (null == s) {
            return s;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return s;
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.replaceAll("([`^])", "^$1");
        }
        return s.replaceAll("([&><|;^`])", "^$1");
    }

    public static void replaceTokensInScript(String script, MultiDataContext<ContextView, DataContext> dataContext, ScriptfileUtils.LineEndingStyle style, File destination, String nodeName, boolean addBom) throws IOException {
        SharedDataContextUtils.replaceTokensInScript(script, dataContext, style, destination, nodeName, true, addBom);
    }

    public static void replaceTokensInScript(String script, MultiDataContext<ContextView, DataContext> dataContext, ScriptfileUtils.LineEndingStyle style, File destination, String nodeName, boolean blankIfMissing, boolean addBom) throws IOException {
        if (null == script) {
            throw new NullPointerException("script cannot be null");
        }
        SharedDataContextUtils.replaceTokensInReader(new StringReader(script), dataContext, style, destination, nodeName, blankIfMissing, addBom);
    }

    public static void replaceTokensInStream(InputStream stream, MultiDataContext<ContextView, DataContext> dataContext, ScriptfileUtils.LineEndingStyle style, File destination, String nodeName, boolean addBom) throws IOException {
        if (null == stream) {
            throw new NullPointerException("stream cannot be null");
        }
        SharedDataContextUtils.replaceTokensInReader(new InputStreamReader(stream), dataContext, style, destination, nodeName, true, addBom);
    }

    public static void replaceTokensInReader(Reader reader, MultiDataContext<ContextView, DataContext> dataContext, ScriptfileUtils.LineEndingStyle style, File destination, String nodeName) throws IOException {
        SharedDataContextUtils.replaceTokensInReader(reader, dataContext, style, destination, nodeName, true, false);
    }

    public static void replaceTokensInReader(Reader reader, MultiDataContext<ContextView, DataContext> dataContext, ScriptfileUtils.LineEndingStyle style, File destination, String nodeName, boolean blankIfMissing, boolean addBom) throws IOException {
        ScriptVarExpander scriptVarExpander = new ScriptVarExpander();
        ReplaceTokenReader replaceTokens = new ReplaceTokenReader(reader, variable -> scriptVarExpander.expandVariable(dataContext, ContextView.node(nodeName), ContextView::nodeStep, (String)variable), blankIfMissing, '@', '@');
        ScriptfileUtils.writeScriptFile(null, null, replaceTokens, style, destination, addBom);
    }

    public static <T extends ViewTraverse<T>> Map<String, Object> replaceDataReferences(Map<String, Object> input, T currentContext, BiFunction<Integer, String, T> viewMap, Converter<String, String> converter, MultiDataContext<T, DataContext> data) {
        return SharedDataContextUtils.replaceDataReferences(input, currentContext, viewMap, converter, data, false, false);
    }

    public static <T extends ViewTraverse<T>> Map<String, Object> replaceDataReferences(Map<String, Object> input, T currentContext, BiFunction<Integer, String, T> viewMap, Converter<String, String> converter, MultiDataContext<T, DataContext> data, boolean failOnUnexpanded, boolean blankIfUnexpanded) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        for (String s : input.keySet()) {
            Object o = input.get(s);
            output.put(s, SharedDataContextUtils.replaceDataReferencesInObject(o, currentContext, viewMap, converter, data, failOnUnexpanded, blankIfUnexpanded));
        }
        return output;
    }

    public static <T extends ViewTraverse<T>> Map<String, Object> replaceDataReferences(Map<String, Object> input, T currentContext, BiFunction<Integer, String, T> viewMap, Converter<String, String> converter, MultiDataContext<T, DataContext> data, boolean failOnUnexpanded, Map<String, Boolean> blankIfUnexpandedFieldMap) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        for (String s : input.keySet()) {
            Boolean blankIfUnexpanded = blankIfUnexpandedFieldMap.getOrDefault(s, true);
            Object o = input.get(s);
            output.put(s, SharedDataContextUtils.replaceDataReferencesInObject(o, currentContext, viewMap, converter, data, failOnUnexpanded, blankIfUnexpanded));
        }
        return output;
    }

    public static <T extends ViewTraverse<T>> Object replaceDataReferencesInObject(Object o, T currentContext, BiFunction<Integer, String, T> viewMap, Converter<String, String> converter, MultiDataContext<T, DataContext> data) {
        return SharedDataContextUtils.replaceDataReferencesInObject(o, currentContext, viewMap, converter, data, false, false);
    }

    public static <T extends ViewTraverse<T>> Object replaceDataReferencesInObject(Object o, T currentContext, BiFunction<Integer, String, T> viewMap, Converter<String, String> converter, MultiDataContext<T, DataContext> data, boolean failOnUnexpanded, boolean blankIfUnexpanded) {
        if (o instanceof String) {
            return SharedDataContextUtils.replaceDataReferences((String)o, data, currentContext, viewMap, converter, failOnUnexpanded, blankIfUnexpanded);
        }
        if (o instanceof Map) {
            Map sub = (Map)o;
            return SharedDataContextUtils.replaceDataReferences((Map<String, Object>)sub, currentContext, viewMap, converter, data, failOnUnexpanded, blankIfUnexpanded);
        }
        if (o instanceof Collection) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o1 : (Collection)o) {
                result.add(SharedDataContextUtils.replaceDataReferencesInObject(o1, currentContext, viewMap, converter, data, failOnUnexpanded, blankIfUnexpanded));
            }
            return result;
        }
        return o;
    }
}

