/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.dispatch;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.plugins.orchestrator.Orchestrator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class OrchestratorNodeProcessor {
    private final int threadCount;
    private final boolean keepgoing;
    private final Orchestrator orchestrator;
    private final Map<INodeEntry, Callable<NodeStepResult>> executions;
    private final ExecutorService threadPool;
    private final Set<INodeEntry> processedNodes;
    private final BlockingQueue<Result> resultqueue;
    private final BlockingQueue<Entry> taskqueue;
    private final boolean cancelOnInterrupt;
    private volatile boolean runnableStopped;
    private volatile boolean shouldStop;
    private boolean interrupted;
    private Map<String, String> exceptionMessages;
    private Throwable lastThrown;

    private OrchestratorNodeProcessor(int threadCount, boolean keepgoing, Orchestrator orchestrator, Map<INodeEntry, Callable<NodeStepResult>> executions, boolean cancelOnInterrupt) {
        if (threadCount < 1) {
            throw new IllegalArgumentException("threadCount must be greater than 0: " + threadCount);
        }
        this.runnableStopped = false;
        this.interrupted = false;
        this.threadCount = threadCount;
        this.resultqueue = new LinkedBlockingQueue<Result>();
        this.taskqueue = new LinkedBlockingQueue<Entry>(threadCount);
        this.keepgoing = keepgoing;
        this.orchestrator = orchestrator;
        this.executions = executions;
        this.threadPool = Executors.newFixedThreadPool(this.threadCount);
        this.processedNodes = Collections.newSetFromMap(new ConcurrentHashMap());
        this.cancelOnInterrupt = cancelOnInterrupt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws NodeProcessorException {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int i = 0; i < this.threadCount; ++i) {
            futures.add(this.threadPool.submit(new OrchestratorRunnable()));
        }
        boolean success = true;
        this.exceptionMessages = new HashMap<String, String>();
        try {
            int completedNodes = 0;
            while (completedNodes < this.executions.size() && !this.runnableStopped && !this.shouldStop) {
                try {
                    Entry callable = this.getCallable();
                    if (null != callable) {
                        this.taskqueue.put(callable);
                        continue;
                    }
                    if (completedNodes < this.processedNodes.size()) {
                        Result result = this.resultqueue.take();
                        if (!result.success) {
                            success = false;
                        }
                        if (result.node != null) {
                            this.orchestrator.returnNode(result.node, result.success, result.result);
                        }
                        if (result.error != null) {
                            if (result.node != null) {
                                this.exceptionMessages.put(result.node.getNodename(), result.error.getMessage());
                            } else {
                                this.exceptionMessages.put("?", result.error.getMessage());
                            }
                            this.lastThrown = result.error;
                        }
                        ++completedNodes;
                        continue;
                    }
                    if (!this.orchestrator.isComplete()) {
                        try {
                            Thread.sleep(2000L);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            e2.printStackTrace();
                            this.interrupted = true;
                            if (!this.cancelOnInterrupt) continue;
                        }
                    }
                    break;
                }
                catch (DispatcherException e3) {
                    e3.printStackTrace();
                }
            }
        }
        catch (InterruptedException e4) {
            this.interrupted = true;
        }
        finally {
            this.shouldStop = true;
            for (int x = this.threadCount; x > 0 && this.taskqueue.offer(new Entry(true)); --x) {
            }
            if (this.isInterrupted() && this.cancelOnInterrupt) {
                futures.forEach(e -> e.cancel(true));
            }
            this.threadPool.shutdown();
        }
        try {
            this.threadPool.awaitTermination(this.isInterrupted() && this.cancelOnInterrupt ? 2L : 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.threadPool.shutdownNow();
        }
        if (this.exceptionMessages.size() == 1 && null != this.lastThrown) {
            throw new NodeProcessorException(String.format("1 Node had errors: %s", this.lastThrown.getMessage()), this.lastThrown);
        }
        if (this.exceptionMessages.size() > 0) {
            throw new NodeProcessorException(String.format("%d Nodes had errors: %s", this.exceptionMessages.size(), this.generateMessages()));
        }
        return !this.runnableStopped && !this.interrupted && success;
    }

    private String generateMessages() {
        StringBuffer buffer = new StringBuffer();
        for (String node : this.exceptionMessages.keySet()) {
            if (buffer.length() > 0) {
                buffer.append(System.getProperty("line.separator"));
            }
            buffer.append(node).append(": ");
            buffer.append(this.exceptionMessages.get(node));
        }
        return buffer.toString();
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void runnableFailed() {
        this.runnableStopped = true;
    }

    public Entry getCallable() throws DispatcherException {
        INodeEntry node = this.orchestrator.nextNode();
        if (node == null) {
            return null;
        }
        if (!this.processedNodes.add(node)) {
            throw new DispatcherException("Can not process the same node twice " + node);
        }
        Callable<NodeStepResult> callable = this.executions.get(node);
        if (null == callable) {
            throw new DispatcherException("Can not process the a node that is not from the target list: " + node);
        }
        return new Entry(node, callable);
    }

    public static OrchestratorNodeProcessorBuilder builder() {
        return new OrchestratorNodeProcessorBuilder();
    }

    public static class OrchestratorNodeProcessorBuilder {
        private int threadCount;
        private boolean keepgoing;
        private Orchestrator orchestrator;
        private Map<INodeEntry, Callable<NodeStepResult>> executions;
        private boolean cancelOnInterrupt;

        OrchestratorNodeProcessorBuilder() {
        }

        public OrchestratorNodeProcessorBuilder threadCount(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public OrchestratorNodeProcessorBuilder keepgoing(boolean keepgoing) {
            this.keepgoing = keepgoing;
            return this;
        }

        public OrchestratorNodeProcessorBuilder orchestrator(Orchestrator orchestrator) {
            this.orchestrator = orchestrator;
            return this;
        }

        public OrchestratorNodeProcessorBuilder executions(Map<INodeEntry, Callable<NodeStepResult>> executions) {
            this.executions = executions;
            return this;
        }

        public OrchestratorNodeProcessorBuilder cancelOnInterrupt(boolean cancelOnInterrupt) {
            this.cancelOnInterrupt = cancelOnInterrupt;
            return this;
        }

        public OrchestratorNodeProcessor build() {
            return new OrchestratorNodeProcessor(this.threadCount, this.keepgoing, this.orchestrator, this.executions, this.cancelOnInterrupt);
        }

        public String toString() {
            return "OrchestratorNodeProcessor.OrchestratorNodeProcessorBuilder(threadCount=" + this.threadCount + ", keepgoing=" + this.keepgoing + ", orchestrator=" + this.orchestrator + ", executions=" + this.executions + ", cancelOnInterrupt=" + this.cancelOnInterrupt + ")";
        }
    }

    public static class Entry {
        private boolean finish;
        private final INodeEntry node;
        private final Callable<NodeStepResult> callable;

        public Entry(boolean finish) {
            this.finish = finish;
            this.node = null;
            this.callable = null;
        }

        public Entry(INodeEntry node, Callable<NodeStepResult> callable) {
            this.node = node;
            this.callable = callable;
            this.finish = false;
        }
    }

    public static class Result {
        private final INodeEntry node;
        private final boolean success;
        private final NodeStepResult result;
        private final Throwable error;

        public Result(INodeEntry node, boolean success, NodeStepResult result, Throwable error) {
            this.node = node;
            this.success = success;
            this.result = result;
            this.error = error;
        }
    }

    public class OrchestratorRunnable
    implements Callable<Boolean> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            String originalname = Thread.currentThread().getName();
            while (!OrchestratorNodeProcessor.this.runnableStopped && !OrchestratorNodeProcessor.this.shouldStop) {
                Throwable error;
                NodeStepResult result;
                Entry task;
                boolean success;
                block7: {
                    block6: {
                        success = false;
                        task = null;
                        result = null;
                        Thread.currentThread().setName("OrchestratorNodeProcessor[take]");
                        error = null;
                        task = (Entry)OrchestratorNodeProcessor.this.taskqueue.take();
                        if (task != null && !task.finish) break block6;
                        OrchestratorNodeProcessor.this.resultqueue.put(new Result(task != null ? task.node : null, success, result, error));
                        Thread.currentThread().setName(originalname);
                        break;
                    }
                    try {
                        Thread.currentThread().setName("OrchestratorNodeProcessor[running](node=" + task.node.getNodename() + ")");
                        result = (NodeStepResult)task.callable.call();
                        success = result.isSuccess();
                        if (success || OrchestratorNodeProcessor.this.keepgoing) break block7;
                        OrchestratorNodeProcessor.this.runnableFailed();
                    }
                    catch (Throwable e) {
                        block8: {
                            try {
                                error = e;
                                if (OrchestratorNodeProcessor.this.keepgoing) break block8;
                                OrchestratorNodeProcessor.this.runnableFailed();
                                throw e;
                            }
                            catch (Throwable throwable) {
                                OrchestratorNodeProcessor.this.resultqueue.put(new Result(task != null ? task.node : null, success, result, error));
                                Thread.currentThread().setName(originalname);
                                throw throwable;
                            }
                        }
                        OrchestratorNodeProcessor.this.resultqueue.put(new Result(task != null ? task.node : null, success, result, error));
                        Thread.currentThread().setName(originalname);
                        continue;
                    }
                    OrchestratorNodeProcessor.this.resultqueue.put(new Result(task != null ? task.node : null, success, result, error));
                    Thread.currentThread().setName(originalname);
                    break;
                }
                OrchestratorNodeProcessor.this.resultqueue.put(new Result(task != null ? task.node : null, success, result, error));
                Thread.currentThread().setName(originalname);
            }
            return true;
        }
    }

    static class NodeProcessorException
    extends Exception {
        public NodeProcessorException(String message) {
            super(message);
        }

        public NodeProcessorException(String message, Throwable cause) {
            super(message, cause);
        }

        public NodeProcessorException(Throwable cause) {
            super(cause);
        }
    }
}

