/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.jsch;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.impl.jsch.NodeSSHConnectionInfo;
import com.dtolabs.rundeck.core.execution.proxy.DefaultSecretBundle;
import com.dtolabs.rundeck.core.execution.proxy.SecretBundle;
import com.dtolabs.utils.Streams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class JschSecretBundleUtil {
    public static SecretBundle createBundle(ExecutionContext context, INodeEntry node) {
        try {
            DefaultSecretBundle secretBundle = new DefaultSecretBundle();
            NodeSSHConnectionInfo nodeAuthentication = new NodeSSHConnectionInfo(node, context.getFramework(), context);
            if (nodeAuthentication.getPasswordStoragePath() != null) {
                secretBundle.addSecret(nodeAuthentication.getPasswordStoragePath(), nodeAuthentication.getPasswordStorageData());
            }
            if (nodeAuthentication.getPrivateKeyPassphraseStoragePath() != null) {
                secretBundle.addSecret(nodeAuthentication.getPrivateKeyPassphraseStoragePath(), nodeAuthentication.getPrivateKeyPassphraseStorageData());
            }
            if (nodeAuthentication.getPrivateKeyStoragePath() != null) {
                ByteArrayOutputStream pkData = new ByteArrayOutputStream();
                Streams.copyStream(nodeAuthentication.getPrivateKeyStorageData(), pkData);
                secretBundle.addSecret(nodeAuthentication.getPrivateKeyStoragePath(), pkData.toByteArray());
            }
            if (nodeAuthentication.getSudoPasswordStoragePath("sudo-") != null) {
                secretBundle.addSecret(nodeAuthentication.getSudoPasswordStoragePath("sudo-"), nodeAuthentication.getSudoPasswordStorageData("sudo-"));
            }
            if (nodeAuthentication.getSudoPasswordStoragePath("sudo2-") != null) {
                secretBundle.addSecret(nodeAuthentication.getSudoPasswordStoragePath("sudo2-"), nodeAuthentication.getSudoPasswordStorageData("sudo2-"));
            }
            return secretBundle;
        }
        catch (IOException iex) {
            throw new RuntimeException("Unable to prepare secret bundle", iex);
        }
    }
}

