/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtil {
    public static void extractZip(String path, File dest) throws IOException {
        ZipUtil.extractZip(path, dest, null);
    }

    public static void extractZip(String path, File dest, String prefix) throws IOException {
        ZipUtil.extractZip(path, dest, prefix, null);
    }

    public static void extractZipFile(String path, File dest, final String fileName) throws IOException {
        FilenameFilter filter = null;
        if (null != fileName) {
            filter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String name) {
                    return fileName.equals(name) || fileName.startsWith(name);
                }
            };
        }
        ZipUtil.extractZip(path, dest, filter, null, null);
    }

    public static void extractZip(String path, File dest, String prefix, String stripPrefix) throws IOException {
        ZipUtil.extractZip(path, dest, prefix, stripPrefix, null);
    }

    public static void extractZip(String path, File dest, String prefix, String stripPrefix, streamCopier copier) throws IOException {
        ZipUtil.extractZip(path, dest, prefix, (renamer)new PrefixStripper(stripPrefix), copier);
    }

    public static void extractZip(String path, File dest, final String prefix, renamer rename, streamCopier copier) throws IOException {
        FilenameFilter filter = null;
        if (null != prefix) {
            filter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String name) {
                    return name.startsWith(prefix);
                }
            };
        }
        ZipUtil.extractZip(path, dest, filter, rename, copier);
    }

    public static void extractZip(String zipFilePath, File destDir, FilenameFilter filter, renamer rename, streamCopier copier) throws IOException {
        try (ZipFile jar = new ZipFile(zipFilePath);){
            ZipUtil.extractZip(jar.entries(), jar::getInputStream, destDir, filter, rename, copier);
        }
    }

    public static void extractZip(Enumeration<? extends ZipEntry> enumeration, GetStream streamSource, File dest, FilenameFilter filter, renamer rename, streamCopier copier) throws IOException {
        while (enumeration.hasMoreElements()) {
            File destFile;
            ZipEntry entry = enumeration.nextElement();
            if (null != filter && !filter.accept(dest, entry.getName())) continue;
            String name = entry.getName();
            if (null != rename) {
                name = rename.rename(name);
            }
            if (!(destFile = new File(dest, name)).toPath().normalize().startsWith(dest.toPath().normalize())) {
                throw new IOException(String.format("Path is outside of destination directory: %s", destFile));
            }
            if (entry.isDirectory() && !destFile.isDirectory()) {
                if (destFile.mkdirs()) continue;
                throw new IOException("Unable to make directory: " + destFile);
            }
            if (entry.isDirectory()) continue;
            if (!destFile.exists()) {
                File parent = destFile.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IOException("Unable to create parent dir for file: " + destFile.getAbsolutePath());
                }
                if (!destFile.createNewFile()) {
                    throw new IOException("Unable to create file: " + destFile.getAbsolutePath());
                }
            }
            InputStream entryStream = streamSource.getInputStream(entry);
            Throwable throwable = null;
            try {
                FileOutputStream fileOut = new FileOutputStream(destFile);
                Throwable throwable2 = null;
                try {
                    if (null != copier) {
                        copier.copyStream(entryStream, fileOut);
                        continue;
                    }
                    ZipUtil.copyStream(entryStream, fileOut);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fileOut == null) continue;
                    if (throwable2 != null) {
                        try {
                            fileOut.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    fileOut.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (entryStream == null) continue;
                if (throwable != null) {
                    try {
                        entryStream.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                entryStream.close();
            }
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int c;
        byte[] buffer = new byte[4096];
        while (-1 != (c = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, c);
        }
    }

    public static class CopyStreamCopier
    implements streamCopier {
        @Override
        public void copyStream(InputStream in, OutputStream out) throws IOException {
            ZipUtil.copyStream(in, out);
        }
    }

    public static interface streamCopier {
        public void copyStream(InputStream var1, OutputStream var2) throws IOException;
    }

    public static class PrefixStripper
    implements renamer {
        String prefix;

        public PrefixStripper(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String rename(String name) {
            if (null != this.prefix && name.startsWith(this.prefix)) {
                return name.substring(this.prefix.length());
            }
            return name;
        }
    }

    public static interface GetStream {
        public InputStream getInputStream(ZipEntry var1) throws IOException;
    }

    public static interface renamer {
        public String rename(String var1);
    }
}

