/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.data;

import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.data.MultiDataContext;
import com.dtolabs.rundeck.core.data.VarExpander;
import com.dtolabs.rundeck.core.data.ViewTraverse;
import java.util.List;
import java.util.function.BiFunction;

public abstract class BaseVarExpander
implements VarExpander {
    @Override
    public <T extends ViewTraverse<T>> String expandVariable(MultiDataContext<T, DataContext> data, T currentContext, BiFunction<Integer, String, T> viewMap, String variableref) {
        VariableRef variableRef = this.parseVariable(variableref);
        if (null == variableRef) {
            return null;
        }
        String step = variableRef.getStep();
        String group = variableRef.getGroup();
        String key = variableRef.getKey();
        String qual = variableRef.getNode();
        Boolean glob = variableRef.getNodeglob();
        String format = variableRef.getFormat();
        if (glob.booleanValue()) {
            List<String> strings = BaseVarExpander.expandAllNodesVariable(data, currentContext, viewMap, step, group, key);
            if (strings == null) {
                return null;
            }
            String delimiter = ",";
            if (format != null && format.length() == 1) {
                delimiter = format;
            }
            return String.join((CharSequence)delimiter, strings);
        }
        return BaseVarExpander.expandVariable(data, currentContext, viewMap, step, group, key, qual);
    }

    public static <T extends ViewTraverse<T>> String expandVariable(MultiDataContext<T, DataContext> data, T currentContext, BiFunction<Integer, String, T> viewMap, String step, String group, String key, String node) {
        Integer t = null;
        if (null != step) {
            try {
                t = Integer.parseInt(step);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        ViewTraverse view = (ViewTraverse)viewMap.apply(t, node);
        T mergedview = view.merge(currentContext).getView();
        return data.resolve(mergedview, view, group, key, null);
    }

    public static <T extends ViewTraverse<T>> List<String> expandAllNodesVariable(MultiDataContext<T, DataContext> data, T currentContext, BiFunction<Integer, String, T> viewMap, String step, String group, String key) {
        Integer t;
        if (null != step) {
            try {
                t = Integer.parseInt(step);
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            t = null;
        }
        ViewTraverse containerView = (ViewTraverse)viewMap.apply(t, null);
        T mergedview = containerView.merge(currentContext).getView();
        return data.collect(containerView::globExpandTo, group, key);
    }

    protected abstract VariableRef parseVariable(String var1);

    static class VariableRef {
        private final String variableref;
        private final String step;
        private final String group;
        private final String key;
        private final String node;
        private final Boolean nodeglob;
        private final String format;

        public VariableRef(String variableref, String step, String group, String key, String node, Boolean nodeglob, String format) {
            this.variableref = variableref;
            this.step = step;
            this.group = group;
            this.key = key;
            this.node = node;
            this.nodeglob = nodeglob;
            this.format = format;
        }

        public String getVariableref() {
            return this.variableref;
        }

        public String getStep() {
            return this.step;
        }

        public String getGroup() {
            return this.group;
        }

        public String getKey() {
            return this.key;
        }

        public String getNode() {
            return this.node;
        }

        public Boolean getNodeglob() {
            return this.nodeglob;
        }

        public String getFormat() {
            return this.format;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableRef)) {
                return false;
            }
            VariableRef other = (VariableRef)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$nodeglob = this.getNodeglob();
            Boolean other$nodeglob = other.getNodeglob();
            if (this$nodeglob == null ? other$nodeglob != null : !((Object)this$nodeglob).equals(other$nodeglob)) {
                return false;
            }
            String this$variableref = this.getVariableref();
            String other$variableref = other.getVariableref();
            if (this$variableref == null ? other$variableref != null : !this$variableref.equals(other$variableref)) {
                return false;
            }
            String this$step = this.getStep();
            String other$step = other.getStep();
            if (this$step == null ? other$step != null : !this$step.equals(other$step)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$node = this.getNode();
            String other$node = other.getNode();
            if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            return !(this$format == null ? other$format != null : !this$format.equals(other$format));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VariableRef;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $nodeglob = this.getNodeglob();
            result = result * 59 + ($nodeglob == null ? 43 : ((Object)$nodeglob).hashCode());
            String $variableref = this.getVariableref();
            result = result * 59 + ($variableref == null ? 43 : $variableref.hashCode());
            String $step = this.getStep();
            result = result * 59 + ($step == null ? 43 : $step.hashCode());
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $node = this.getNode();
            result = result * 59 + ($node == null ? 43 : $node.hashCode());
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            return result;
        }

        public String toString() {
            return "BaseVarExpander.VariableRef(variableref=" + this.getVariableref() + ", step=" + this.getStep() + ", group=" + this.getGroup() + ", key=" + this.getKey() + ", node=" + this.getNode() + ", nodeglob=" + this.getNodeglob() + ", format=" + this.getFormat() + ")";
        }
    }
}

