/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.VersionConstants;
import com.dtolabs.rundeck.core.plugins.PluginValidation;
import com.dtolabs.rundeck.core.plugins.VersionCompare;
import java.util.Arrays;
import java.util.List;

public class PluginMetadataValidator {
    private static List<String> HOST_TYPES = Arrays.asList("all", "unix", "windows");
    private static final String INCOMPATIBLE_PLUGIN_VER_MSG = "Plugin is not compatible with this version of Rundeck. (Current: %s, Plugin Compatibility: %s)";
    public static final String OS_TYPE = System.getProperty("os.name").toLowerCase();

    public static PluginValidation.State validateTargetHostCompatibility(List<String> errors, String targetHostCompatibility) {
        if (targetHostCompatibility == null) {
            errors.add("No targetHostCompatibility property specified in metadata");
            return PluginValidation.State.INVALID;
        }
        if (targetHostCompatibility.equals("all")) {
            return PluginValidation.State.VALID;
        }
        if (!HOST_TYPES.contains(targetHostCompatibility)) {
            errors.add("Unknown target host type specified: " + targetHostCompatibility + ". Allowed types: " + Arrays.toString(HOST_TYPES.toArray()));
            return PluginValidation.State.INVALID;
        }
        if (targetHostCompatibility.equals("unix") && OS_TYPE.startsWith("windows") || targetHostCompatibility.equals("windows") && !OS_TYPE.startsWith("windows")) {
            errors.add("Plugin target host(" + targetHostCompatibility + ") is incompatible with this Rundeck instance: " + OS_TYPE);
            return PluginValidation.State.INCOMPATIBLE;
        }
        return PluginValidation.State.VALID;
    }

    public static PluginValidation.State validateRundeckCompatibility(List<String> errors, String rundeckCompatibilityVersion) {
        return PluginMetadataValidator.validateRundeckCompatibility(errors, VersionConstants.VERSION, rundeckCompatibilityVersion);
    }

    public static PluginValidation.State validateRundeckCompatibility(List<String> errors, String rundeckVersion, String rundeckCompatibilityVersion) {
        if (rundeckCompatibilityVersion == null) {
            errors.add("rundeckCompatibilityVersion cannot be null in metadata");
            return PluginValidation.State.INVALID;
        }
        VersionCompare rundeckVer = VersionCompare.forString(rundeckVersion);
        VersionCompare compatVer = VersionCompare.forString(rundeckCompatibilityVersion);
        String majString = compatVer.majString + "+";
        if (!PluginMetadataValidator.checkVer(rundeckVer.maj, majString)) {
            errors.add(String.format(INCOMPATIBLE_PLUGIN_VER_MSG, rundeckVersion, rundeckCompatibilityVersion));
            return PluginValidation.State.INCOMPATIBLE;
        }
        Integer cmaj = new Integer(compatVer.majString.replaceAll("\\+", ""));
        if (rundeckVer.maj > cmaj) {
            return PluginValidation.State.VALID;
        }
        if (compatVer.minString.equals("x")) {
            return PluginValidation.State.VALID;
        }
        Integer cmin = new Integer(compatVer.minString.replaceAll("\\+", ""));
        if (rundeckVer.min > cmin) {
            return PluginValidation.State.VALID;
        }
        if (!PluginMetadataValidator.checkVer(rundeckVer.min, compatVer.minString)) {
            errors.add(String.format(INCOMPATIBLE_PLUGIN_VER_MSG, rundeckVersion, rundeckCompatibilityVersion));
            return PluginValidation.State.INCOMPATIBLE;
        }
        if (compatVer.patchString == null) {
            return PluginValidation.State.VALID;
        }
        if (!PluginMetadataValidator.checkVer(rundeckVer.patch, compatVer.patchString)) {
            errors.add(String.format(INCOMPATIBLE_PLUGIN_VER_MSG, rundeckVersion, rundeckCompatibilityVersion));
            return PluginValidation.State.INCOMPATIBLE;
        }
        return PluginValidation.State.VALID;
    }

    private static boolean checkVer(Integer rdVer, String compVer) {
        if (compVer == null) {
            return false;
        }
        if (compVer.contains("x")) {
            return true;
        }
        boolean greater = compVer.contains("+");
        Integer icver = new Integer(compVer.replaceAll("\\+", ""));
        return PluginMetadataValidator.compare(rdVer, icver, greater);
    }

    static boolean compare(Integer rd, Integer compat, boolean greater) {
        if (greater && rd >= compat) {
            return true;
        }
        return compat.equals(rd);
    }
}

