/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins.configuration;

import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyBase;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyObjectValidator;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyValidator;
import com.dtolabs.rundeck.core.plugins.configuration.ValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PropertyUtil {
    static final PropertyValidator booleanValidator = value -> "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
    static final PropertyValidator integerValidator = value -> {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Not a valid integer");
        }
        return true;
    };
    static final PropertyValidator longValidator = value -> {
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Not a valid integer");
        }
        return true;
    };

    public static Property forType(Property.Type type, String name, String title, String description, boolean required, String defaultValue, List<String> values) {
        return PropertyUtil.forType(type, name, title, description, required, defaultValue, values, null);
    }

    public static Property forType(Property.Type type, String name, String title, String description, boolean required, String defaultValue, List<String> values, PropertyValidator validator) {
        return PropertyUtil.forType(type, name, title, description, required, defaultValue, values, validator, null);
    }

    public static Property forType(Property.Type type, String name, String title, String description, boolean required, String defaultValue, List<String> values, PropertyValidator validator, PropertyScope scope) {
        return PropertyUtil.forType(type, name, title, description, required, defaultValue, values, validator, scope, null);
    }

    public static Property forType(Property.Type type, String name, String title, String description, boolean required, String defaultValue, List<String> values, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions) {
        return PropertyUtil.forType(type, name, title, description, required, defaultValue, values, null, validator, scope, renderingOptions, false);
    }

    public static Property forType(Property.Type type, String name, String title, String description, boolean required, String defaultValue, List<String> values, Map<String, String> labels, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions, boolean dynamicValues) {
        return PropertyUtil.forType(type, name, title, description, required, defaultValue, values, null, validator, scope, renderingOptions, false, true);
    }

    public static Property forType(Property.Type type, String name, String title, String description, boolean required, String defaultValue, List<String> values, Map<String, String> labels, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions, boolean dynamicValues, boolean blankIfUnexpandable) {
        switch (type) {
            case Integer: {
                return PropertyUtil.integer(name, title, description, required, defaultValue, validator, scope, renderingOptions);
            }
            case Boolean: {
                return PropertyUtil.bool(name, title, description, required, defaultValue, scope, renderingOptions);
            }
            case Long: {
                return PropertyUtil.longProp(name, title, description, required, defaultValue, validator, scope, renderingOptions);
            }
            case Select: {
                return PropertyUtil.select(name, title, description, required, defaultValue, values, labels, scope, renderingOptions, dynamicValues);
            }
            case FreeSelect: {
                return PropertyUtil.freeSelect(name, title, description, required, defaultValue, values, labels, validator, scope, renderingOptions);
            }
            case Options: {
                return PropertyUtil.options(name, title, description, required, defaultValue, values, labels, validator, scope, renderingOptions);
            }
        }
        return PropertyUtil.string(name, title, description, required, defaultValue, validator, scope, renderingOptions, blankIfUnexpandable);
    }

    public static Property string(String name, String title, String description, boolean required, String defaultValue) {
        return PropertyUtil.string(name, title, description, required, defaultValue, null);
    }

    public static Property string(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator) {
        return PropertyUtil.string(name, title, description, required, defaultValue, validator, null);
    }

    public static Property string(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope) {
        return PropertyUtil.string(name, title, description, required, defaultValue, validator, scope, null);
    }

    public static Property string(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions) {
        return PropertyUtil.string(name, title, description, required, defaultValue, validator, scope, renderingOptions, true);
    }

    public static Property string(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions, boolean blankIfUnexpandable) {
        return new StringProperty(name, title, description, required, defaultValue, validator, scope, renderingOptions, blankIfUnexpandable);
    }

    public static Property bool(String name, String title, String description, boolean required, String defaultValue) {
        return PropertyUtil.bool(name, title, description, required, defaultValue, null);
    }

    public static BooleanProperty bool(String name, String title, String description, boolean required, String defaultValue, PropertyScope scope) {
        return PropertyUtil.bool(name, title, description, required, defaultValue, scope, null);
    }

    public static BooleanProperty bool(String name, String title, String description, boolean required, String defaultValue, PropertyScope scope, Map<String, Object> renderingOptions) {
        return new BooleanProperty(name, title, description, required, defaultValue, scope, renderingOptions);
    }

    public static Property integer(String name, String title, String description, boolean required, String defaultValue) {
        return PropertyUtil.integer(name, title, description, required, defaultValue, null);
    }

    public static Property integer(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator) {
        return PropertyUtil.integer(name, title, description, required, defaultValue, validator, null);
    }

    public static Property integer(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope) {
        return PropertyUtil.integer(name, title, description, required, defaultValue, validator, scope, null);
    }

    public static Property integer(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions) {
        return new IntegerProperty(name, title, description, required, defaultValue, validator, scope, renderingOptions);
    }

    public static Property longProp(String name, String title, String description, boolean required, String defaultValue) {
        return PropertyUtil.longProp(name, title, description, required, defaultValue, null);
    }

    public static Property longProp(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator) {
        return PropertyUtil.longProp(name, title, description, required, defaultValue, validator, null);
    }

    public static Property longProp(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope) {
        return PropertyUtil.longProp(name, title, description, required, defaultValue, validator, scope, null);
    }

    public static Property longProp(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions) {
        return new LongProperty(name, title, description, required, defaultValue, validator, scope, renderingOptions);
    }

    public static Property select(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues) {
        return PropertyUtil.select(name, title, description, required, defaultValue, selectValues, null);
    }

    public static Property select(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, PropertyScope scope) {
        return PropertyUtil.select(name, title, description, required, defaultValue, selectValues, scope, null);
    }

    public static Property select(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, PropertyScope scope, Map<String, Object> renderingOptions) {
        return PropertyUtil.select(name, title, description, required, defaultValue, selectValues, null, scope, renderingOptions, false);
    }

    public static Property select(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, Map<String, String> selectLabels, PropertyScope scope, Map<String, Object> renderingOptions, boolean dynamicValues) {
        return new SelectProperty(name, title, description, required, defaultValue, selectValues, selectLabels, scope, renderingOptions, dynamicValues);
    }

    public static Property select(String name, String title, String description, boolean required, String defaultValue, Collection<? extends Enum<?>> selectValues, PropertyScope scope, Map<String, Object> renderingOptions) {
        return PropertyUtil.select(name, title, description, required, defaultValue, selectValues, null, scope, renderingOptions);
    }

    public static Property select(String name, String title, String description, boolean required, String defaultValue, Collection<? extends Enum<?>> selectValues, Map<String, String> selectLabels, PropertyScope scope, Map<String, Object> renderingOptions) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Enum<?> selectValue : selectValues) {
            strings.add(selectValue.name());
        }
        return new SelectProperty(name, title, description, required, defaultValue, strings, selectLabels, scope, renderingOptions, false);
    }

    public static Property freeSelect(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues) {
        return PropertyUtil.freeSelect(name, title, description, required, defaultValue, selectValues, null);
    }

    public static Property freeSelect(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, PropertyValidator validator) {
        return PropertyUtil.freeSelect(name, title, description, required, defaultValue, selectValues, validator, null);
    }

    public static Property freeSelect(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, PropertyValidator validator, PropertyScope scope) {
        return PropertyUtil.freeSelect(name, title, description, required, defaultValue, selectValues, validator, scope, null);
    }

    public static Property freeSelect(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions) {
        return new FreeSelectProperty(name, title, description, required, defaultValue, selectValues, null, validator, scope, renderingOptions);
    }

    public static Property freeSelect(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, Map<String, String> labels, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions) {
        return new FreeSelectProperty(name, title, description, required, defaultValue, selectValues, labels, validator, scope, renderingOptions);
    }

    public static Property options(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, Map<String, String> labels, PropertyScope scope, Map<String, Object> renderingOptions) {
        return PropertyUtil.options(name, title, description, required, defaultValue, selectValues, labels, null, scope, renderingOptions);
    }

    public static Property options(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, Map<String, String> labels, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions) {
        return new OptionsProperty(name, title, description, required, defaultValue, selectValues, labels, validator, scope, renderingOptions);
    }

    static PropertyValidator andValidator(PropertyValidator first, PropertyValidator second) {
        if (null == first) {
            return second;
        }
        if (null == second) {
            return first;
        }
        return value -> first.isValid(value) && second.isValid(value);
    }

    static final class LongProperty
    extends PropertyBase {
        public LongProperty(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions) {
            super(name, title, description, required, defaultValue, PropertyUtil.andValidator(longValidator, validator), scope, renderingOptions);
        }

        @Override
        public Property.Type getType() {
            return Property.Type.Long;
        }
    }

    static final class IntegerProperty
    extends PropertyBase {
        public IntegerProperty(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions) {
            super(name, title, description, required, defaultValue, PropertyUtil.andValidator(integerValidator, validator), scope, renderingOptions);
        }

        @Override
        public Property.Type getType() {
            return Property.Type.Integer;
        }
    }

    static final class BooleanProperty
    extends PropertyBase {
        public BooleanProperty(String name, String title, String description, boolean required, String defaultValue, PropertyScope scope, Map<String, Object> renderingOptions) {
            super(name, title, description, required, defaultValue, booleanValidator, scope, renderingOptions);
        }

        @Override
        public Property.Type getType() {
            return Property.Type.Boolean;
        }
    }

    static final class OptionsValidator
    implements PropertyObjectValidator {
        final List<String> selectValues;

        OptionsValidator(List<String> selectValues) {
            this.selectValues = selectValues;
        }

        @Override
        public boolean isValid(String value) throws ValidationException {
            if (this.selectValues == null) {
                return true;
            }
            HashSet<String> propvalset = new HashSet<String>();
            if (value.indexOf(44) > 0) {
                Stream<String> stream = Arrays.stream(value.split(", *"));
                propvalset.addAll(stream.map(new Function<String, String>(){

                    @Override
                    public String apply(String s1) {
                        return s1.trim();
                    }
                }).filter(new Predicate<String>(){

                    @Override
                    public boolean test(String s) {
                        return !"".equals(s);
                    }
                }).collect(Collectors.toSet()));
            } else {
                propvalset.add(value);
            }
            return this.selectValues.containsAll(propvalset);
        }

        @Override
        public boolean isValid(Object value) throws ValidationException {
            if (this.selectValues == null) {
                return true;
            }
            HashSet propvalset = new HashSet();
            if (!(value instanceof Collection)) {
                throw new ValidationException("Value is not a String collection");
            }
            propvalset.addAll((Collection)value);
            return this.selectValues.containsAll(propvalset);
        }
    }

    static final class SelectValidator
    implements PropertyValidator {
        final List<String> selectValues;
        final boolean dynamicValues;

        SelectValidator(List<String> selectValues, boolean dynamicValues) {
            this.selectValues = selectValues;
            this.dynamicValues = dynamicValues;
        }

        @Override
        public boolean isValid(String value) throws ValidationException {
            return this.dynamicValues || this.selectValues.contains(value);
        }
    }

    static final class OptionsProperty
    extends FreeSelectProperty {
        public OptionsProperty(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, Map<String, String> selectLabels, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions) {
            super(name, title, description, required, defaultValue, selectValues, selectLabels, validator == null ? new OptionsValidator(selectValues) : validator, scope, renderingOptions);
        }

        @Override
        public Property.Type getType() {
            return Property.Type.Options;
        }
    }

    static final class SelectProperty
    extends FreeSelectProperty {
        public SelectProperty(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, Map<String, String> selectLabels, PropertyScope scope, Map<String, Object> renderingOptions, boolean dynamicValues) {
            super(name, title, description, required, defaultValue, selectValues, selectLabels, new SelectValidator(selectValues, dynamicValues), scope, renderingOptions);
        }

        @Override
        public Property.Type getType() {
            return Property.Type.Select;
        }
    }

    static class FreeSelectProperty
    extends PropertyBase {
        final List<String> selectValues;
        final Map<String, String> selectLabels;

        public FreeSelectProperty(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, Map<String, String> selectLabels, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions) {
            super(name, title, description, required, defaultValue, validator, scope, renderingOptions);
            this.selectValues = selectValues;
            this.selectLabels = selectLabels;
        }

        @Override
        public Property.Type getType() {
            return Property.Type.FreeSelect;
        }

        @Override
        public List<String> getSelectValues() {
            return this.selectValues;
        }

        @Override
        public Map<String, String> getSelectLabels() {
            return this.selectLabels;
        }
    }

    static final class StringProperty
    extends PropertyBase {
        public StringProperty(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope, Map<String, Object> renderingOptions, boolean blankIfUnexpandable) {
            super(name, title, description, required, defaultValue, validator, scope, renderingOptions, blankIfUnexpandable);
        }

        @Override
        public Property.Type getType() {
            return Property.Type.String;
        }
    }
}

