/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.launcher;

import com.dtolabs.launcher.Preferences;
import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Setup
implements CLIToolLogger {
    public static final Logger logger = LoggerFactory.getLogger(Setup.class);
    public static String RDECK_BASE = Constants.getSystemBaseDir();
    public static final String SETUP_USAGE = "rd-setup [-v] -n nodename [-N hostname] [ --key=value ]";
    public static final boolean FORCE_FLAG = true;
    private Parameters parameters = new Parameters();
    public static final String TEMPLATE_RESOURCES_PATH = "com/dtolabs/launcher/setup/templates";
    static String[] templates = new String[]{"admin.aclpolicy", "system-job_reader.aclpolicy_template", "system-job_runner.aclpolicy_template", "system-job_writer.aclpolicy_template", "system-job_viewer.aclpolicy_template", "system-project_admin.aclpolicy_template", "framework.properties", "profile.bat", "profile", "project.properties"};
    static final HashSet<String> restrictedPermTemplates = new HashSet();

    public static void main(String[] args) {
        int exitCode = 1;
        Setup setup = new Setup();
        try {
            setup.execute(args);
            exitCode = 0;
        }
        catch (Throwable exc) {
            System.err.println("ERROR: " + exc.getMessage());
        }
        System.exit(exitCode);
    }

    public void execute(String[] args) throws SetupException {
        this.parameters.parse(args);
        this.performSetup(args);
    }

    public void performSetup() throws SetupException {
        this.performSetup(new String[0]);
    }

    private void performSetup(String[] args) throws SetupException {
        this.parameters.validate();
        this.validateInstall();
        File basedir = new File(this.parameters.getBaseDir());
        if (!basedir.exists() && !basedir.mkdirs()) {
            throw new SetupException("Unable to create RDECK_BASE directory: " + this.parameters.getBaseDir());
        }
        this.generatePreferences(args, this.parameters.getProperties());
        this.newImpl(basedir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newImpl(File basedir) throws SetupException {
        File etcdir = new File(Constants.getFrameworkConfigDir(basedir.getAbsolutePath()));
        if (!etcdir.exists() && !etcdir.mkdir()) {
            throw new SetupException("Unable to create directory: " + etcdir.getAbsolutePath());
        }
        boolean overwrite = this.parameters.forceFlag;
        File preferences = new File(etcdir, "preferences.properties");
        Properties prefs = new Properties();
        if (preferences.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(preferences);){
                prefs.load(fileInputStream);
            }
            catch (IOException e) {
                throw new SetupException("Error loading file: " + preferences.getAbsolutePath(), e);
            }
        }
        long time = System.currentTimeMillis();
        try {
            for (String filename : templates) {
                File destFile = new File(etcdir, filename);
                File templFile = this.getTemplateFile(filename + ".template");
                if (overwrite && destFile.isFile()) {
                    File backup = new File(etcdir, filename + ".backup-" + time);
                    FileUtils.getFileUtils().copyFile(destFile, backup);
                }
                if (!overwrite && destFile.isFile()) continue;
                FilterSetCollection filterset = new FilterSetCollection();
                FilterSet set = new FilterSet();
                set.setFiltersfile(preferences);
                filterset.addFilterSet(set);
                FileUtils.getFileUtils().copyFile(templFile, destFile, filterset, true);
                if (!restrictedPermTemplates.contains(filename) || destFile.setWritable(false, false)) continue;
                logger.warn("Failed to remove writable flag for file: " + destFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new SetupException("Error copying templates", e);
        }
        Properties frameworkProps = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(new File(etcdir, "framework.properties"));){
            frameworkProps.load(fileInputStream);
        }
        catch (IOException e) {
            throw new SetupException("unable to load framework.properties", e);
        }
        for (String prop : new String[]{"framework.var.dir", "framework.tmp.dir", "framework.logs.dir", "framework.etc.dir", "framework.projects.dir"}) {
            String path = frameworkProps.getProperty(prop);
            String expandpath = path.replaceAll("\\$\\{framework\\.var\\.dir\\}", frameworkProps.getProperty("framework.var.dir"));
            File dir = new File(expandpath);
            if (dir.isDirectory() || dir.mkdirs()) continue;
            throw new SetupException("Unable to create dir: " + dir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getTemplateFile(String filename) throws IOException {
        File templateFile = null;
        String resource = "com/dtolabs/launcher/setup/templates/" + filename;
        InputStream is = Setup.class.getClassLoader().getResourceAsStream(resource);
        if (null == is) {
            throw new RuntimeException("Unable to load required template: " + resource);
        }
        templateFile = File.createTempFile("temp", filename);
        templateFile.deleteOnExit();
        try {
            File file = this.copyToNativeLineEndings(is, templateFile);
            return file;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyToNativeLineEndings(InputStream input, File destFile) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(input));
        try (FileOutputStream out = new FileOutputStream(destFile);){
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
            String line = bufferedReader.readLine();
            while (line != null) {
                writer.write(line);
                writer.newLine();
                line = bufferedReader.readLine();
            }
            writer.flush();
        }
        return destFile;
    }

    private void validateInstall() throws SetupException {
        if (null == this.parameters.getBaseDir() || this.parameters.getBaseDir().equals("")) {
            throw new SetupException("rdeck.base property not defined or is the empty string");
        }
        if (!this.checkIfDir("rdeck.base", this.parameters.getBaseDir())) {
            throw new SetupException(this.parameters.getBaseDir() + " is not a valid rdeck install");
        }
    }

    private boolean checkIfDir(String propName, String path) {
        if (null == path || path.equals("")) {
            throw new IllegalArgumentException(propName + "property had null or empty value");
        }
        return new File(path).exists();
    }

    private void generatePreferences(String[] args, Properties input) throws SetupException {
        File frameworkPreferences = new File(Constants.getFrameworkPreferences(this.parameters.getBaseDir()));
        try {
            Preferences.generate(args, frameworkPreferences.getAbsolutePath(), input);
        }
        catch (Exception e) {
            throw new SetupException("failed generating setup preferences: " + e.getMessage(), e);
        }
        if (!frameworkPreferences.exists()) {
            throw new SetupException("Unable to generate preferences file: " + frameworkPreferences);
        }
        if (!frameworkPreferences.isFile()) {
            throw new SetupException(frameworkPreferences + " preferences file is not a regular file");
        }
    }

    public static void printUsage() {
        System.out.println(SETUP_USAGE);
    }

    private static void usageError(String msg) {
        System.err.println("\nERROR: " + msg);
        Setup.printUsage();
    }

    @Override
    public void log(String message) {
        System.out.println(message);
    }

    @Override
    public void error(String message) {
        System.err.println(message);
    }

    @Override
    public void warn(String message) {
        System.err.println(message);
    }

    @Override
    public void verbose(String message) {
        System.out.println(message);
    }

    @Override
    public void debug(String message) {
        System.out.println(message);
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    static {
        restrictedPermTemplates.addAll(Arrays.asList("admin.aclpolicy", "apitoken.aclpolicy"));
    }

    public static class SetupException
    extends Exception {
        public SetupException() {
        }

        public SetupException(String s) {
            super(s);
        }

        public SetupException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public SetupException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class Parameters {
        private boolean forceFlag = true;
        private boolean debugFlag;
        private String serverHostname;
        private String serverName;
        private String baseDir;
        private Properties properties = new Properties();

        protected boolean getForceFlag() {
            return this.forceFlag;
        }

        protected boolean getDebugFlag() {
            return this.debugFlag;
        }

        protected String getNodeArg() {
            return this.serverName;
        }

        private String getOptParam(String[] args, int arg_i) throws SetupException {
            if (arg_i == args.length - 1) {
                throw new SetupException("option: " + args[arg_i] + " must take a parameter");
            }
            if (args[arg_i + 1].startsWith("-")) {
                throw new SetupException("arg: " + args[arg_i] + " does not have a parameter, instead was provided: " + args[arg_i + 1]);
            }
            return args[arg_i + 1];
        }

        private void parse(String[] args) throws SetupException {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-v")) {
                    this.debugFlag = true;
                    continue;
                }
                if (args[i].equals("-n")) {
                    this.serverName = this.getOptParam(args, i);
                    ++i;
                    continue;
                }
                if (args[i].equals("-N")) {
                    this.serverHostname = this.getOptParam(args, i);
                    ++i;
                    continue;
                }
                if (args[i].equals("-d")) {
                    this.baseDir = this.getOptParam(args, i);
                    ++i;
                    continue;
                }
                if (args[i].startsWith("--")) continue;
                Setup.usageError("unrecognized argument: \"" + args[i] + "\"");
            }
        }

        public void validate() throws SetupException {
            if (null == this.serverName) {
                throw new SetupException("server name not specified.");
            }
            if (null == this.serverHostname) {
                this.serverHostname = this.serverName;
            }
            if (null == this.baseDir) {
                this.baseDir = Constants.getSystemBaseDir();
            }
            this.properties.setProperty("rdeck.base", Preferences.forwardSlashPath(this.baseDir));
            this.properties.setProperty("framework.server.hostname", this.serverHostname);
            this.properties.setProperty("framework.server.name", this.serverName);
        }

        public String getNodeHostnameArg() {
            return this.serverHostname;
        }

        public String getServerHostname() {
            return this.serverHostname;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setServerHostname(String serverHostname) {
            this.serverHostname = serverHostname;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public String getBaseDir() {
            return this.baseDir;
        }

        public void setBaseDir(String baseDir) {
            this.baseDir = baseDir;
        }

        public void setProperty(String name, String value) {
            this.properties.setProperty(name, value);
        }
    }
}

