/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps;

import com.dtolabs.rundeck.core.data.SharedDataContextUtils;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.execution.ConfiguredStepExecutionItem;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.PluginStepContextImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.DynamicProperties;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyResolverFactory;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.utils.Converter;
import com.dtolabs.rundeck.plugins.step.StepPlugin;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.rundeck.app.spi.Services;

public class StepPluginAdapter
implements StepExecutor,
Describable,
DynamicProperties {
    public static final Convert CONVERTER = new Convert();
    private StepPlugin plugin;

    public StepPluginAdapter(StepPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Map<String, Object> dynamicProperties(Map<String, Object> projectAndFrameworkValues, Services services) {
        if (this.plugin instanceof DynamicProperties) {
            return ((DynamicProperties)((Object)this.plugin)).dynamicProperties(projectAndFrameworkValues, services);
        }
        return null;
    }

    @Override
    public Description getDescription() {
        if (this.plugin instanceof Describable) {
            Describable desc = (Describable)((Object)this.plugin);
            return desc.getDescription();
        }
        return PluginAdapterUtility.buildDescription(this.plugin, DescriptionBuilder.builder());
    }

    @Override
    public boolean isNodeDispatchStep(StepExecutionItem item) {
        return false;
    }

    @Override
    public StepExecutionResult executeWorkflowStep(StepExecutionContext executionContext, StepExecutionItem item) throws StepException {
        String providerName = item.getType();
        PluginStepContextImpl stepContext = PluginStepContextImpl.from(executionContext);
        Map<String, Object> instanceConfiguration = this.createConfig(executionContext, item);
        PropertyResolver resolver = PropertyResolverFactory.createStepPluginRuntimeResolver(executionContext, instanceConfiguration, "WorkflowStep", providerName);
        Map<String, Object> config = PluginAdapterUtility.configureProperties(resolver, this.getDescription(), this.plugin, PropertyScope.InstanceOnly);
        try {
            this.plugin.executeStep(stepContext, config);
        }
        catch (StepException e) {
            executionContext.getExecutionListener().log(0, e.getMessage());
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            executionContext.getExecutionListener().log(4, "Failed executing step plugin [" + providerName + "]: " + stringWriter.toString());
            return new StepExecutionResultImpl(e, e.getFailureReason(), e.getMessage());
        }
        catch (Throwable e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            executionContext.getExecutionListener().log(4, "Failed executing step plugin [" + providerName + "]: " + stringWriter.toString());
            return new StepExecutionResultImpl(e, StepFailureReason.PluginFailed, e.getMessage());
        }
        return new StepExecutionResultImpl();
    }

    public Map<String, Object> createConfig(StepExecutionContext executionContext, StepExecutionItem item) {
        Map<String, Object> instanceConfiguration = this.getStepConfiguration(item);
        Description description = this.getDescription();
        HashMap<String, Boolean> blankIfUnexMap = new HashMap<String, Boolean>();
        if (description != null) {
            description.getProperties().forEach(p -> blankIfUnexMap.put(p.getName(), p.isBlankIfUnexpandable()));
        }
        if (null != instanceConfiguration) {
            instanceConfiguration = SharedDataContextUtils.replaceDataReferences(instanceConfiguration, ContextView.global(), ContextView::nodeStep, null, executionContext.getSharedDataContext(), false, blankIfUnexMap);
        }
        return instanceConfiguration;
    }

    private Map<String, Object> getStepConfiguration(StepExecutionItem item) {
        if (item instanceof ConfiguredStepExecutionItem) {
            return ((ConfiguredStepExecutionItem)item).getStepConfiguration();
        }
        return null;
    }

    public StepPlugin getPlugin() {
        return this.plugin;
    }

    public static class Convert
    implements Converter<StepPlugin, StepExecutor> {
        @Override
        public StepExecutor convert(StepPlugin plugin) {
            return new StepPluginAdapter(plugin);
        }
    }
}

