/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.plugins.AbstractDescribableScriptPlugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.ScriptPluginResourceModelSource;
import com.dtolabs.rundeck.core.storage.keys.KeyStorageTree;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.rundeck.app.spi.Services;

public class ScriptPluginResourceModelSourceFactory
extends AbstractDescribableScriptPlugin
implements ResourceModelSourceFactory {
    public static final String RESOURCE_FORMAT_PROP = "resource-format";
    public static final String DISABLE_CONTENT_CONVERSION = "disableContentConversion";
    final String format;

    public ScriptPluginResourceModelSourceFactory(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
        Object o = provider.getMetadata().get(RESOURCE_FORMAT_PROP);
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("resource-format was not a string");
        }
        this.format = (String)o;
    }

    public static void validateScriptPlugin(ScriptPluginProvider provider) throws PluginException {
        try {
            ScriptPluginResourceModelSourceFactory.createDescription(provider, true, DescriptionBuilder.builder());
        }
        catch (ConfigurationException e) {
            throw new PluginException(e);
        }
        if (!provider.getMetadata().containsKey(RESOURCE_FORMAT_PROP) || !(provider.getMetadata().get(RESOURCE_FORMAT_PROP) instanceof String)) {
            throw new PluginException("resource-format script plugin property string is required");
        }
    }

    @Override
    public ResourceModelSource createResourceModelSource(Properties configuration) throws ConfigurationException {
        return this.createResourceModelSource(null, configuration);
    }

    @Override
    public ResourceModelSource createResourceModelSource(Services services, Properties configuration) throws ConfigurationException {
        Map<String, String> data = configuration.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        ExecutionContextImpl context = null;
        context = services != null ? new ExecutionContextImpl.Builder().framework(this.getFramework()).storageTree(services.getService(KeyStorageTree.class)).build() : new ExecutionContextImpl.Builder().framework(this.getFramework()).build();
        Description pluginDesc = this.getDescription();
        boolean disableContentConversion = false;
        if (configuration.containsKey(DISABLE_CONTENT_CONVERSION)) {
            disableContentConversion = (Boolean)configuration.get(DISABLE_CONTENT_CONVERSION);
        }
        if (!disableContentConversion) {
            this.loadContentConversionPropertyValues(data, context, pluginDesc.getProperties());
        }
        Properties properties = new Properties();
        properties.putAll(data);
        ScriptPluginResourceModelSource urlResourceModelSource = new ScriptPluginResourceModelSource(this.getProvider(), this.getFramework(), this);
        urlResourceModelSource.configure(properties);
        return urlResourceModelSource;
    }

    @Override
    public boolean isAllowCustomProperties() {
        return true;
    }
}

