/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.shared.resources;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.NodesFileGenerator;
import com.dtolabs.shared.resources.ResourceXMLConstants;
import com.dtolabs.shared.resources.ResourceXMLParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceXMLGenerator
implements NodesFileGenerator {
    static Logger log4j = LoggerFactory.getLogger((String)ResourceXMLGenerator.class.getName());
    private File file;
    private OutputStream output;
    private List<ResourceXMLParser.Entity> entities;
    private static final String ALLOWED_CHARS = "_-";

    public ResourceXMLGenerator(File file) {
        this.file = file;
        this.entities = new ArrayList<ResourceXMLParser.Entity>();
    }

    public ResourceXMLGenerator(OutputStream output) {
        this.output = output;
        this.entities = new ArrayList<ResourceXMLParser.Entity>();
    }

    public List<ResourceXMLParser.Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<ResourceXMLParser.Entity> entities) {
        this.entities = entities;
    }

    public void addEntity(ResourceXMLParser.Entity entity) {
        this.entities.add(entity);
    }

    @Override
    public void addNode(INodeEntry node) {
        ResourceXMLParser.Entity entity = this.createEntity(node);
        this.addEntity(entity);
    }

    @Override
    public void addNodes(Collection<INodeEntry> iNodeEntries) {
        for (INodeEntry iNodeEntry : iNodeEntries) {
            this.addNode(iNodeEntry);
        }
    }

    private ResourceXMLParser.Entity createEntity(INodeEntry node) {
        ResourceXMLParser.Entity ent = new ResourceXMLParser.Entity();
        ent.setName(node.getNodename());
        ent.setResourceType("node");
        if (null != node.getAttributes()) {
            for (String setName : node.getAttributes().keySet()) {
                String value = node.getAttributes().get(setName);
                ent.setProperty(setName, value);
            }
        }
        if (null != node.getTags()) {
            ent.setProperty("tags", ResourceXMLGenerator.joinStrings(node.getTags(), ", "));
        }
        return ent;
    }

    private static String joinStrings(Set tags, String delim) {
        ArrayList strings = new ArrayList(tags);
        Object[] objects = strings.toArray(new String[strings.size()]);
        Arrays.sort(objects);
        StringBuffer sb = new StringBuffer();
        for (Object tag : objects) {
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append((String)tag);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate() throws IOException {
        Document doc = DocumentFactory.getInstance().createDocument();
        Element root = doc.addElement("project");
        for (ResourceXMLParser.Entity entity : this.entities) {
            if (!"node".equals(entity.getResourceType())) continue;
            Element ent = this.genEntityCommon(root, entity);
            this.genNode(ent, entity);
        }
        if (null != this.file) {
            try (FileOutputStream out = new FileOutputStream(this.file);){
                ResourceXMLGenerator.serializeDocToStream(out, doc);
            }
        } else if (null != this.output) {
            ResourceXMLGenerator.serializeDocToStream(this.output, doc);
        }
    }

    private void genAttributes(Element ent, ResourceXMLParser.Entity entity) {
        if (null == entity.getProperties()) {
            return;
        }
        for (String key : entity.getProperties().stringPropertyNames()) {
            if (ResourceXMLConstants.allPropSet.contains(key)) continue;
            if (this.isValidName(key)) {
                ent.addAttribute(key, entity.getProperties().getProperty(key));
                continue;
            }
            Element atelm = ent.addElement("attribute");
            atelm.addAttribute("name", key);
            atelm.addAttribute("value", entity.getProperties().getProperty(key));
        }
    }

    private boolean isValidName(String attrName) {
        if (attrName.matches("^(?i)xml.*")) {
            return false;
        }
        for (int i = 0; i < attrName.length(); ++i) {
            char ch = attrName.charAt(i);
            if (i == 0 && !Character.isLetter(ch)) {
                return false;
            }
            if (this.isValidNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidNameChar(char ch) {
        return Character.isLetterOrDigit(ch) || ALLOWED_CHARS.indexOf(ch) >= 0;
    }

    private void genNode(Element ent, ResourceXMLParser.Entity entity) {
        for (String nodeProp : ResourceXMLConstants.nodeProps) {
            ent.addAttribute(nodeProp, this.notNull(entity.getProperty(nodeProp)));
        }
        this.genAttributes(ent, entity);
    }

    private Element genEntityCommon(Element root, ResourceXMLParser.Entity entity) {
        Element tag = root.addElement(entity.getResourceType());
        tag.addAttribute("name", entity.getName());
        tag.addAttribute("description", this.notNull(entity.getProperty("description")));
        tag.addAttribute("tags", this.notNull(entity.getProperty("tags")));
        return tag;
    }

    private String notNull(String s) {
        if (null == s) {
            return "";
        }
        return s;
    }

    private static void serializeDocToStream(OutputStream output, Document doc) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter(output, format);
        writer.write(doc);
        writer.flush();
    }
}

