/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.plugins.jobs;

import com.dtolabs.rundeck.core.jobs.JobOption;
import com.dtolabs.rundeck.core.jobs.options.JobOptionConfigData;
import com.dtolabs.rundeck.core.plugins.configuration.ValidationException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.NonNull;

public class JobOptionImpl
implements JobOption,
Comparable {
    static final String DEFAULT_DELIMITER = ",";
    @NonNull
    private String name;
    private Integer sortIndex;
    private String description;
    private String defaultValue;
    private String defaultStoragePath;
    @NonNull
    private Boolean enforced;
    private Boolean required;
    private Boolean isDate;
    private String dateFormat;
    private TreeSet<String> values;
    private URL realValuesUrl;
    private String label;
    private String regex;
    private String valuesList;
    private String valuesListDelimiter;
    private Boolean multivalued;
    private String delimiter;
    private Boolean secureInput;
    private Boolean secureExposed;
    private String optionType;
    private JobOptionConfigData configData;
    private Boolean multivalueAllSelected;
    private String optionValuesPluginType;
    private Boolean hidden;
    private Boolean sortValues;
    private List<String> optionValues;

    public static JobOptionImpl fromOptionMap(LinkedHashMap option) throws ValidationException {
        JobOptionImplBuilder builder = JobOptionImpl.builder();
        builder.name((String)option.get("name"));
        builder.label(option.containsKey("label") ? (String)option.get("label") : null);
        builder.enforced(option.containsKey("enforced") && (Boolean)option.get("enforced") != false);
        builder.required(option.containsKey("required") && (Boolean)option.get("required") != false);
        boolean isDate = option.containsKey("isDate") && (Boolean)option.get("isDate") != false;
        builder.isDate(isDate);
        if (isDate) {
            builder.dateFormat((String)option.get("dateFormat"));
        }
        if (option.containsKey("type")) {
            builder.optionType((String)option.get("type"));
        }
        if (option.containsKey("description")) {
            builder.description((String)option.get("description"));
        }
        if (option.containsKey("sortIndex")) {
            builder.sortIndex((Integer)option.get("sortIndex"));
        }
        if (option.containsKey("value")) {
            builder.defaultValue((String)option.get("value"));
        }
        if (option.containsKey("storagePath")) {
            builder.defaultStoragePath((String)option.get("storagePath"));
        }
        if (option.containsKey("valuesUrl")) {
            try {
                builder.realValuesUrl(new URL((String)option.get("valuesUrl")));
            }
            catch (MalformedURLException e) {
                throw new ValidationException(e.getMessage());
            }
        }
        if (option.containsKey("regex")) {
            builder.regex((String)option.get("regex"));
        }
        if (option.containsKey("values")) {
            builder.values(option.get("values") instanceof Collection ? new TreeSet<String>((Collection)option.get("values")) : new TreeSet((SortedSet)option.get("values")));
            if (option.containsKey("valuesListDelimiter")) {
                builder.valuesListDelimiter = (String)option.get("valuesListDelimiter");
            } else {
                builder.valuesListDelimiter = DEFAULT_DELIMITER;
            }
            builder.valuesList = JobOptionImpl.produceValuesList(builder.build());
            builder.values = null;
        }
        if (option.containsKey("multivalued")) {
            Boolean multivalued = (Boolean)option.get("multivalued");
            builder.multivalued(multivalued);
            if (multivalued.booleanValue()) {
                if (option.containsKey("delimiter")) {
                    builder.delimiter((String)option.get("delimiter"));
                }
                if (option.containsKey("multivalueAllSelected")) {
                    builder.multivalueAllSelected((Boolean)option.get("multivalueAllSelected"));
                }
            }
        }
        builder.secureExposed(false);
        builder.secureInput(false);
        if (option.containsKey("secure") && ((Boolean)option.get("secure")).booleanValue()) {
            builder.secureInput(true);
            if (option.containsKey("valueExposed")) {
                builder.secureExposed((Boolean)option.get("valueExposed"));
            }
        }
        if (option.containsKey("optionValuesPluginType")) {
            builder.optionValuesPluginType = (String)option.get("optionValuesPluginType");
        }
        if (option.containsKey("hidden")) {
            builder.hidden((Boolean)option.get("hidden"));
        }
        return builder.build();
    }

    private static String produceValuesList(JobOptionImpl jobOption) {
        if (jobOption.values != null) {
            if (jobOption.valuesListDelimiter == null) {
                jobOption.valuesListDelimiter = DEFAULT_DELIMITER;
            }
            jobOption.valuesList = String.join((CharSequence)jobOption.valuesListDelimiter, jobOption.values);
            jobOption.values = null;
            return jobOption.valuesList;
        }
        return "";
    }

    public int compareTo(Object o) {
        JobOptionImpl option = (JobOptionImpl)o;
        if (null != this.sortIndex && null != option.sortIndex) {
            return this.sortIndex.compareTo(option.sortIndex);
        }
        if (null == this.sortIndex && null == option.sortIndex && this.name != null) {
            return this.name.compareTo(option.name);
        }
        return this.sortIndex != null ? -1 : 1;
    }

    private static Boolean $default$enforced() {
        return false;
    }

    private static Boolean $default$required() {
        return false;
    }

    private static Boolean $default$isDate() {
        return false;
    }

    private static Boolean $default$multivalued() {
        return false;
    }

    private static Boolean $default$secureInput() {
        return false;
    }

    private static Boolean $default$secureExposed() {
        return false;
    }

    private static Boolean $default$multivalueAllSelected() {
        return false;
    }

    private static Boolean $default$hidden() {
        return false;
    }

    private static Boolean $default$sortValues() {
        return false;
    }

    JobOptionImpl(@NonNull String name, Integer sortIndex, String description, String defaultValue, String defaultStoragePath, @NonNull Boolean enforced, Boolean required, Boolean isDate, String dateFormat, TreeSet<String> values, URL realValuesUrl, String label, String regex, String valuesList, String valuesListDelimiter, Boolean multivalued, String delimiter, Boolean secureInput, Boolean secureExposed, String optionType, JobOptionConfigData configData, Boolean multivalueAllSelected, String optionValuesPluginType, Boolean hidden, Boolean sortValues, List<String> optionValues) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (enforced == null) {
            throw new NullPointerException("enforced is marked non-null but is null");
        }
        this.name = name;
        this.sortIndex = sortIndex;
        this.description = description;
        this.defaultValue = defaultValue;
        this.defaultStoragePath = defaultStoragePath;
        this.enforced = enforced;
        this.required = required;
        this.isDate = isDate;
        this.dateFormat = dateFormat;
        this.values = values;
        this.realValuesUrl = realValuesUrl;
        this.label = label;
        this.regex = regex;
        this.valuesList = valuesList;
        this.valuesListDelimiter = valuesListDelimiter;
        this.multivalued = multivalued;
        this.delimiter = delimiter;
        this.secureInput = secureInput;
        this.secureExposed = secureExposed;
        this.optionType = optionType;
        this.configData = configData;
        this.multivalueAllSelected = multivalueAllSelected;
        this.optionValuesPluginType = optionValuesPluginType;
        this.hidden = hidden;
        this.sortValues = sortValues;
        this.optionValues = optionValues;
    }

    public static JobOptionImplBuilder builder() {
        return new JobOptionImplBuilder();
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getSortIndex() {
        return this.sortIndex;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDefaultStoragePath() {
        return this.defaultStoragePath;
    }

    @Override
    @NonNull
    public Boolean getEnforced() {
        return this.enforced;
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public Boolean getIsDate() {
        return this.isDate;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    public TreeSet<String> getValues() {
        return this.values;
    }

    @Override
    public URL getRealValuesUrl() {
        return this.realValuesUrl;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getRegex() {
        return this.regex;
    }

    @Override
    public String getValuesList() {
        return this.valuesList;
    }

    @Override
    public String getValuesListDelimiter() {
        return this.valuesListDelimiter;
    }

    @Override
    public Boolean getMultivalued() {
        return this.multivalued;
    }

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public Boolean getSecureInput() {
        return this.secureInput;
    }

    @Override
    public Boolean getSecureExposed() {
        return this.secureExposed;
    }

    @Override
    public String getOptionType() {
        return this.optionType;
    }

    @Override
    public JobOptionConfigData getConfigData() {
        return this.configData;
    }

    @Override
    public Boolean getMultivalueAllSelected() {
        return this.multivalueAllSelected;
    }

    @Override
    public String getOptionValuesPluginType() {
        return this.optionValuesPluginType;
    }

    @Override
    public Boolean getHidden() {
        return this.hidden;
    }

    @Override
    public Boolean getSortValues() {
        return this.sortValues;
    }

    @Override
    public List<String> getOptionValues() {
        return this.optionValues;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setSortIndex(Integer sortIndex) {
        this.sortIndex = sortIndex;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDefaultStoragePath(String defaultStoragePath) {
        this.defaultStoragePath = defaultStoragePath;
    }

    public void setEnforced(@NonNull Boolean enforced) {
        if (enforced == null) {
            throw new NullPointerException("enforced is marked non-null but is null");
        }
        this.enforced = enforced;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setIsDate(Boolean isDate) {
        this.isDate = isDate;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setValues(TreeSet<String> values) {
        this.values = values;
    }

    public void setRealValuesUrl(URL realValuesUrl) {
        this.realValuesUrl = realValuesUrl;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setValuesList(String valuesList) {
        this.valuesList = valuesList;
    }

    public void setValuesListDelimiter(String valuesListDelimiter) {
        this.valuesListDelimiter = valuesListDelimiter;
    }

    public void setMultivalued(Boolean multivalued) {
        this.multivalued = multivalued;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setSecureInput(Boolean secureInput) {
        this.secureInput = secureInput;
    }

    public void setSecureExposed(Boolean secureExposed) {
        this.secureExposed = secureExposed;
    }

    public void setOptionType(String optionType) {
        this.optionType = optionType;
    }

    public void setConfigData(JobOptionConfigData configData) {
        this.configData = configData;
    }

    public void setMultivalueAllSelected(Boolean multivalueAllSelected) {
        this.multivalueAllSelected = multivalueAllSelected;
    }

    public void setOptionValuesPluginType(String optionValuesPluginType) {
        this.optionValuesPluginType = optionValuesPluginType;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void setSortValues(Boolean sortValues) {
        this.sortValues = sortValues;
    }

    public void setOptionValues(List<String> optionValues) {
        this.optionValues = optionValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobOptionImpl)) {
            return false;
        }
        JobOptionImpl other = (JobOptionImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$sortIndex = this.getSortIndex();
        Integer other$sortIndex = other.getSortIndex();
        if (this$sortIndex == null ? other$sortIndex != null : !((Object)this$sortIndex).equals(other$sortIndex)) {
            return false;
        }
        Boolean this$enforced = this.getEnforced();
        Boolean other$enforced = other.getEnforced();
        if (this$enforced == null ? other$enforced != null : !((Object)this$enforced).equals(other$enforced)) {
            return false;
        }
        Boolean this$required = this.getRequired();
        Boolean other$required = other.getRequired();
        if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
            return false;
        }
        Boolean this$isDate = this.getIsDate();
        Boolean other$isDate = other.getIsDate();
        if (this$isDate == null ? other$isDate != null : !((Object)this$isDate).equals(other$isDate)) {
            return false;
        }
        Boolean this$multivalued = this.getMultivalued();
        Boolean other$multivalued = other.getMultivalued();
        if (this$multivalued == null ? other$multivalued != null : !((Object)this$multivalued).equals(other$multivalued)) {
            return false;
        }
        Boolean this$secureInput = this.getSecureInput();
        Boolean other$secureInput = other.getSecureInput();
        if (this$secureInput == null ? other$secureInput != null : !((Object)this$secureInput).equals(other$secureInput)) {
            return false;
        }
        Boolean this$secureExposed = this.getSecureExposed();
        Boolean other$secureExposed = other.getSecureExposed();
        if (this$secureExposed == null ? other$secureExposed != null : !((Object)this$secureExposed).equals(other$secureExposed)) {
            return false;
        }
        Boolean this$multivalueAllSelected = this.getMultivalueAllSelected();
        Boolean other$multivalueAllSelected = other.getMultivalueAllSelected();
        if (this$multivalueAllSelected == null ? other$multivalueAllSelected != null : !((Object)this$multivalueAllSelected).equals(other$multivalueAllSelected)) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        Boolean this$sortValues = this.getSortValues();
        Boolean other$sortValues = other.getSortValues();
        if (this$sortValues == null ? other$sortValues != null : !((Object)this$sortValues).equals(other$sortValues)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$defaultStoragePath = this.getDefaultStoragePath();
        String other$defaultStoragePath = other.getDefaultStoragePath();
        if (this$defaultStoragePath == null ? other$defaultStoragePath != null : !this$defaultStoragePath.equals(other$defaultStoragePath)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        SortedSet this$values = this.getValues();
        SortedSet other$values = other.getValues();
        if (this$values == null ? other$values != null : !this$values.equals(other$values)) {
            return false;
        }
        URL this$realValuesUrl = this.getRealValuesUrl();
        URL other$realValuesUrl = other.getRealValuesUrl();
        if (this$realValuesUrl == null ? other$realValuesUrl != null : !((Object)this$realValuesUrl).equals(other$realValuesUrl)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$regex = this.getRegex();
        String other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !this$regex.equals(other$regex)) {
            return false;
        }
        String this$valuesList = this.getValuesList();
        String other$valuesList = other.getValuesList();
        if (this$valuesList == null ? other$valuesList != null : !this$valuesList.equals(other$valuesList)) {
            return false;
        }
        String this$valuesListDelimiter = this.getValuesListDelimiter();
        String other$valuesListDelimiter = other.getValuesListDelimiter();
        if (this$valuesListDelimiter == null ? other$valuesListDelimiter != null : !this$valuesListDelimiter.equals(other$valuesListDelimiter)) {
            return false;
        }
        String this$delimiter = this.getDelimiter();
        String other$delimiter = other.getDelimiter();
        if (this$delimiter == null ? other$delimiter != null : !this$delimiter.equals(other$delimiter)) {
            return false;
        }
        String this$optionType = this.getOptionType();
        String other$optionType = other.getOptionType();
        if (this$optionType == null ? other$optionType != null : !this$optionType.equals(other$optionType)) {
            return false;
        }
        JobOptionConfigData this$configData = this.getConfigData();
        JobOptionConfigData other$configData = other.getConfigData();
        if (this$configData == null ? other$configData != null : !this$configData.equals(other$configData)) {
            return false;
        }
        String this$optionValuesPluginType = this.getOptionValuesPluginType();
        String other$optionValuesPluginType = other.getOptionValuesPluginType();
        if (this$optionValuesPluginType == null ? other$optionValuesPluginType != null : !this$optionValuesPluginType.equals(other$optionValuesPluginType)) {
            return false;
        }
        List<String> this$optionValues = this.getOptionValues();
        List<String> other$optionValues = other.getOptionValues();
        return !(this$optionValues == null ? other$optionValues != null : !((Object)this$optionValues).equals(other$optionValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobOptionImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sortIndex = this.getSortIndex();
        result = result * 59 + ($sortIndex == null ? 43 : ((Object)$sortIndex).hashCode());
        Boolean $enforced = this.getEnforced();
        result = result * 59 + ($enforced == null ? 43 : ((Object)$enforced).hashCode());
        Boolean $required = this.getRequired();
        result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
        Boolean $isDate = this.getIsDate();
        result = result * 59 + ($isDate == null ? 43 : ((Object)$isDate).hashCode());
        Boolean $multivalued = this.getMultivalued();
        result = result * 59 + ($multivalued == null ? 43 : ((Object)$multivalued).hashCode());
        Boolean $secureInput = this.getSecureInput();
        result = result * 59 + ($secureInput == null ? 43 : ((Object)$secureInput).hashCode());
        Boolean $secureExposed = this.getSecureExposed();
        result = result * 59 + ($secureExposed == null ? 43 : ((Object)$secureExposed).hashCode());
        Boolean $multivalueAllSelected = this.getMultivalueAllSelected();
        result = result * 59 + ($multivalueAllSelected == null ? 43 : ((Object)$multivalueAllSelected).hashCode());
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        Boolean $sortValues = this.getSortValues();
        result = result * 59 + ($sortValues == null ? 43 : ((Object)$sortValues).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $defaultStoragePath = this.getDefaultStoragePath();
        result = result * 59 + ($defaultStoragePath == null ? 43 : $defaultStoragePath.hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        SortedSet $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : $values.hashCode());
        URL $realValuesUrl = this.getRealValuesUrl();
        result = result * 59 + ($realValuesUrl == null ? 43 : ((Object)$realValuesUrl).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        String $valuesList = this.getValuesList();
        result = result * 59 + ($valuesList == null ? 43 : $valuesList.hashCode());
        String $valuesListDelimiter = this.getValuesListDelimiter();
        result = result * 59 + ($valuesListDelimiter == null ? 43 : $valuesListDelimiter.hashCode());
        String $delimiter = this.getDelimiter();
        result = result * 59 + ($delimiter == null ? 43 : $delimiter.hashCode());
        String $optionType = this.getOptionType();
        result = result * 59 + ($optionType == null ? 43 : $optionType.hashCode());
        JobOptionConfigData $configData = this.getConfigData();
        result = result * 59 + ($configData == null ? 43 : $configData.hashCode());
        String $optionValuesPluginType = this.getOptionValuesPluginType();
        result = result * 59 + ($optionValuesPluginType == null ? 43 : $optionValuesPluginType.hashCode());
        List<String> $optionValues = this.getOptionValues();
        result = result * 59 + ($optionValues == null ? 43 : ((Object)$optionValues).hashCode());
        return result;
    }

    public String toString() {
        return "JobOptionImpl(name=" + this.getName() + ", sortIndex=" + this.getSortIndex() + ", description=" + this.getDescription() + ", defaultValue=" + this.getDefaultValue() + ", defaultStoragePath=" + this.getDefaultStoragePath() + ", enforced=" + this.getEnforced() + ", required=" + this.getRequired() + ", isDate=" + this.getIsDate() + ", dateFormat=" + this.getDateFormat() + ", values=" + this.getValues() + ", realValuesUrl=" + this.getRealValuesUrl() + ", label=" + this.getLabel() + ", regex=" + this.getRegex() + ", valuesList=" + this.getValuesList() + ", valuesListDelimiter=" + this.getValuesListDelimiter() + ", multivalued=" + this.getMultivalued() + ", delimiter=" + this.getDelimiter() + ", secureInput=" + this.getSecureInput() + ", secureExposed=" + this.getSecureExposed() + ", optionType=" + this.getOptionType() + ", configData=" + this.getConfigData() + ", multivalueAllSelected=" + this.getMultivalueAllSelected() + ", optionValuesPluginType=" + this.getOptionValuesPluginType() + ", hidden=" + this.getHidden() + ", sortValues=" + this.getSortValues() + ", optionValues=" + this.getOptionValues() + ")";
    }

    public static class JobOptionImplBuilder {
        private String name;
        private Integer sortIndex;
        private String description;
        private String defaultValue;
        private String defaultStoragePath;
        private boolean enforced$set;
        private Boolean enforced$value;
        private boolean required$set;
        private Boolean required$value;
        private boolean isDate$set;
        private Boolean isDate$value;
        private String dateFormat;
        private TreeSet<String> values;
        private URL realValuesUrl;
        private String label;
        private String regex;
        private String valuesList;
        private String valuesListDelimiter;
        private boolean multivalued$set;
        private Boolean multivalued$value;
        private String delimiter;
        private boolean secureInput$set;
        private Boolean secureInput$value;
        private boolean secureExposed$set;
        private Boolean secureExposed$value;
        private String optionType;
        private JobOptionConfigData configData;
        private boolean multivalueAllSelected$set;
        private Boolean multivalueAllSelected$value;
        private String optionValuesPluginType;
        private boolean hidden$set;
        private Boolean hidden$value;
        private boolean sortValues$set;
        private Boolean sortValues$value;
        private List<String> optionValues;

        JobOptionImplBuilder() {
        }

        public JobOptionImplBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public JobOptionImplBuilder sortIndex(Integer sortIndex) {
            this.sortIndex = sortIndex;
            return this;
        }

        public JobOptionImplBuilder description(String description) {
            this.description = description;
            return this;
        }

        public JobOptionImplBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public JobOptionImplBuilder defaultStoragePath(String defaultStoragePath) {
            this.defaultStoragePath = defaultStoragePath;
            return this;
        }

        public JobOptionImplBuilder enforced(@NonNull Boolean enforced) {
            if (enforced == null) {
                throw new NullPointerException("enforced is marked non-null but is null");
            }
            this.enforced$value = enforced;
            this.enforced$set = true;
            return this;
        }

        public JobOptionImplBuilder required(Boolean required) {
            this.required$value = required;
            this.required$set = true;
            return this;
        }

        public JobOptionImplBuilder isDate(Boolean isDate) {
            this.isDate$value = isDate;
            this.isDate$set = true;
            return this;
        }

        public JobOptionImplBuilder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public JobOptionImplBuilder values(TreeSet<String> values) {
            this.values = values;
            return this;
        }

        public JobOptionImplBuilder realValuesUrl(URL realValuesUrl) {
            this.realValuesUrl = realValuesUrl;
            return this;
        }

        public JobOptionImplBuilder label(String label) {
            this.label = label;
            return this;
        }

        public JobOptionImplBuilder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public JobOptionImplBuilder valuesList(String valuesList) {
            this.valuesList = valuesList;
            return this;
        }

        public JobOptionImplBuilder valuesListDelimiter(String valuesListDelimiter) {
            this.valuesListDelimiter = valuesListDelimiter;
            return this;
        }

        public JobOptionImplBuilder multivalued(Boolean multivalued) {
            this.multivalued$value = multivalued;
            this.multivalued$set = true;
            return this;
        }

        public JobOptionImplBuilder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public JobOptionImplBuilder secureInput(Boolean secureInput) {
            this.secureInput$value = secureInput;
            this.secureInput$set = true;
            return this;
        }

        public JobOptionImplBuilder secureExposed(Boolean secureExposed) {
            this.secureExposed$value = secureExposed;
            this.secureExposed$set = true;
            return this;
        }

        public JobOptionImplBuilder optionType(String optionType) {
            this.optionType = optionType;
            return this;
        }

        public JobOptionImplBuilder configData(JobOptionConfigData configData) {
            this.configData = configData;
            return this;
        }

        public JobOptionImplBuilder multivalueAllSelected(Boolean multivalueAllSelected) {
            this.multivalueAllSelected$value = multivalueAllSelected;
            this.multivalueAllSelected$set = true;
            return this;
        }

        public JobOptionImplBuilder optionValuesPluginType(String optionValuesPluginType) {
            this.optionValuesPluginType = optionValuesPluginType;
            return this;
        }

        public JobOptionImplBuilder hidden(Boolean hidden) {
            this.hidden$value = hidden;
            this.hidden$set = true;
            return this;
        }

        public JobOptionImplBuilder sortValues(Boolean sortValues) {
            this.sortValues$value = sortValues;
            this.sortValues$set = true;
            return this;
        }

        public JobOptionImplBuilder optionValues(List<String> optionValues) {
            this.optionValues = optionValues;
            return this;
        }

        public JobOptionImpl build() {
            Boolean enforced$value = this.enforced$value;
            if (!this.enforced$set) {
                enforced$value = JobOptionImpl.$default$enforced();
            }
            Boolean required$value = this.required$value;
            if (!this.required$set) {
                required$value = JobOptionImpl.$default$required();
            }
            Boolean isDate$value = this.isDate$value;
            if (!this.isDate$set) {
                isDate$value = JobOptionImpl.$default$isDate();
            }
            Boolean multivalued$value = this.multivalued$value;
            if (!this.multivalued$set) {
                multivalued$value = JobOptionImpl.$default$multivalued();
            }
            Boolean secureInput$value = this.secureInput$value;
            if (!this.secureInput$set) {
                secureInput$value = JobOptionImpl.$default$secureInput();
            }
            Boolean secureExposed$value = this.secureExposed$value;
            if (!this.secureExposed$set) {
                secureExposed$value = JobOptionImpl.$default$secureExposed();
            }
            Boolean multivalueAllSelected$value = this.multivalueAllSelected$value;
            if (!this.multivalueAllSelected$set) {
                multivalueAllSelected$value = JobOptionImpl.$default$multivalueAllSelected();
            }
            Boolean hidden$value = this.hidden$value;
            if (!this.hidden$set) {
                hidden$value = JobOptionImpl.$default$hidden();
            }
            Boolean sortValues$value = this.sortValues$value;
            if (!this.sortValues$set) {
                sortValues$value = JobOptionImpl.$default$sortValues();
            }
            return new JobOptionImpl(this.name, this.sortIndex, this.description, this.defaultValue, this.defaultStoragePath, enforced$value, required$value, isDate$value, this.dateFormat, this.values, this.realValuesUrl, this.label, this.regex, this.valuesList, this.valuesListDelimiter, multivalued$value, this.delimiter, secureInput$value, secureExposed$value, this.optionType, this.configData, multivalueAllSelected$value, this.optionValuesPluginType, hidden$value, sortValues$value, this.optionValues);
        }

        public String toString() {
            return "JobOptionImpl.JobOptionImplBuilder(name=" + this.name + ", sortIndex=" + this.sortIndex + ", description=" + this.description + ", defaultValue=" + this.defaultValue + ", defaultStoragePath=" + this.defaultStoragePath + ", enforced$value=" + this.enforced$value + ", required$value=" + this.required$value + ", isDate$value=" + this.isDate$value + ", dateFormat=" + this.dateFormat + ", values=" + this.values + ", realValuesUrl=" + this.realValuesUrl + ", label=" + this.label + ", regex=" + this.regex + ", valuesList=" + this.valuesList + ", valuesListDelimiter=" + this.valuesListDelimiter + ", multivalued$value=" + this.multivalued$value + ", delimiter=" + this.delimiter + ", secureInput$value=" + this.secureInput$value + ", secureExposed$value=" + this.secureExposed$value + ", optionType=" + this.optionType + ", configData=" + this.configData + ", multivalueAllSelected$value=" + this.multivalueAllSelected$value + ", optionValuesPluginType=" + this.optionValuesPluginType + ", hidden$value=" + this.hidden$value + ", sortValues$value=" + this.sortValues$value + ", optionValues=" + this.optionValues + ")";
        }
    }
}

